/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.homologene;

import java.util.Set;
import org.biojava.bio.program.homologene.OrthoPairFilter;
import org.biojava.bio.program.homologene.OrthoPairSet;
import org.biojava.bio.program.homologene.Taxon;

public interface OrthoPairSetFilter {
    public boolean accept(OrthoPairSet var1);

    public static final class SomePairsInCollection
    implements OrthoPairSetFilter {
        OrthoPairFilter filter;

        public SomePairsInCollection(OrthoPairFilter filter) {
            this.filter = filter;
        }

        public boolean accept(OrthoPairSet group) {
            OrthoPairSet.Iterator setI = group.iterator();
            while (setI.hasNext()) {
                if (!this.filter.accept(setI.nextOrthoPair())) continue;
                return true;
            }
            return false;
        }
    }

    public static final class AllPairsInCollection
    implements OrthoPairSetFilter {
        OrthoPairFilter filter;

        public AllPairsInCollection(OrthoPairFilter filter) {
            this.filter = filter;
        }

        public boolean accept(OrthoPairSet group) {
            OrthoPairSet.Iterator setI = group.iterator();
            while (setI.hasNext()) {
                if (this.filter.accept(setI.nextOrthoPair())) continue;
                return false;
            }
            return true;
        }
    }

    public static final class ByMinIdentity
    implements OrthoPairSetFilter {
        double minValue;

        public ByMinIdentity(double minValue) {
            this.minValue = minValue;
        }

        public boolean accept(OrthoPairSet group) {
            return group.getMinIdentity() >= this.minValue;
        }
    }

    public static final class ByTaxon
    implements OrthoPairSetFilter {
        Taxon taxon;

        public ByTaxon(Taxon taxon) {
            this.taxon = taxon;
        }

        public boolean accept(OrthoPairSet group) {
            Set taxa = group.getTaxa();
            return taxa.contains(this.taxon);
        }
    }

    public static final class Xor
    implements OrthoPairSetFilter {
        OrthoPairSetFilter a;
        OrthoPairSetFilter b;

        public Xor(OrthoPairSetFilter a, OrthoPairSetFilter b) {
            this.a = a;
            this.b = b;
        }

        public boolean accept(OrthoPairSet group) {
            return this.a.accept(group) ^ this.b.accept(group);
        }
    }

    public static final class And
    implements OrthoPairSetFilter {
        OrthoPairSetFilter a;
        OrthoPairSetFilter b;

        public And(OrthoPairSetFilter a, OrthoPairSetFilter b) {
            this.a = a;
            this.b = b;
        }

        public boolean accept(OrthoPairSet group) {
            return this.a.accept(group) && this.b.accept(group);
        }
    }

    public static final class Or
    implements OrthoPairSetFilter {
        OrthoPairSetFilter a;
        OrthoPairSetFilter b;

        public Or(OrthoPairSetFilter a, OrthoPairSetFilter b) {
            this.a = a;
            this.b = b;
        }

        public boolean accept(OrthoPairSet group) {
            return this.a.accept(group) || this.b.accept(group);
        }
    }

    public static final class Not
    implements OrthoPairSetFilter {
        OrthoPairSetFilter a;

        public Not(OrthoPairSetFilter a) {
            this.a = a;
        }

        public boolean accept(OrthoPairSet group) {
            return !this.a.accept(group);
        }
    }

    public static final class AcceptAll
    implements OrthoPairSetFilter {
        public boolean accept(OrthoPairSet group) {
            return true;
        }
    }
}

