/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.performanceMeasures;

import de.jstacs.DataType;
import de.jstacs.classifiers.performanceMeasures.AbstractNumericalTwoClassPerformanceMeasure;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.utils.ToolBox;

public class SensitivityForFixedSpecificity
extends AbstractNumericalTwoClassPerformanceMeasure {
    public SensitivityForFixedSpecificity() {
        try {
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.DOUBLE, "Specificity", "The fixed specificity for the sensitivity.", true, new NumberValidator<Double>(0.0, 1.0), 0.999)});
        }
        catch (ParameterException parameterException) {
            // empty catch block
        }
    }

    public SensitivityForFixedSpecificity(double specificity) throws Exception {
        this();
        this.getParameterAt(0).setValue(specificity);
    }

    public SensitivityForFixedSpecificity(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public String getName() {
        return "Sensitivity for a fixed specificity";
    }

    @Override
    public NumericalResultSet compute(double[] sortedScoresClass0, double[] weightClass0, double[] sortedScoresClass1, double[] weightClass1) {
        double sn;
        double specificity = (Double)this.getParameterAt(0).getValue();
        double threshold = SensitivityForFixedSpecificity.findThreshold(sortedScoresClass1, sortedScoresClass0, weightClass1, specificity, true);
        int m = sortedScoresClass0.length;
        int i = SensitivityForFixedSpecificity.findSplitIndex(sortedScoresClass0, threshold);
        if (weightClass0 == null) {
            sn = (double)(m - i) / (double)m;
        } else {
            sn = ToolBox.sum(i, m, weightClass0);
            sn /= sn + ToolBox.sum(0, i, weightClass0);
        }
        return new NumericalResultSet(new NumericalResult[][]{{new NumericalResult(this.getName() + " of " + specificity, "", sn), new NumericalResult("Threshold for the " + this.getName().toLowerCase() + " of " + specificity, "", threshold)}});
    }
}

