/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.EmptyDataSetException;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotationParser;
import de.jstacs.io.AbstractStringExtractor;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.io.SymbolExtractor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;

public class ArbitraryFloatSequence
extends Sequence<float[]> {
    private float[] content;

    public ArbitraryFloatSequence(AlphabetContainer alphabetContainer, float[] content) throws WrongAlphabetException, WrongSequenceTypeException {
        super(alphabetContainer, null);
        this.content = new float[content.length];
        for (int i = 0; i < content.length; ++i) {
            if (!alphabetContainer.isEncodedSymbol(i, content[i])) {
                throw new WrongAlphabetException();
            }
            this.content[i] = content[i];
        }
    }

    private ArbitraryFloatSequence(AlphabetContainer cont, SequenceAnnotation[] annotation, float[] content) {
        super(cont, annotation);
        this.content = content;
    }

    public ArbitraryFloatSequence(AlphabetContainer alphabetContainer, String sequence) throws WrongAlphabetException, WrongSequenceTypeException {
        this(alphabetContainer, null, new SymbolExtractor(sequence, alphabetContainer.getDelim()));
    }

    public ArbitraryFloatSequence(AlphabetContainer alphabetContainer, SequenceAnnotation[] annotation, String sequence, String delim) throws WrongAlphabetException, WrongSequenceTypeException, IllegalArgumentException {
        this(alphabetContainer, annotation, new SymbolExtractor(sequence, ArbitraryFloatSequence.checkDelim(alphabetContainer, delim)));
    }

    private static String checkDelim(AlphabetContainer alphabetContainer, String delim) throws IllegalArgumentException {
        if (!alphabetContainer.isDiscrete() && delim.length() == 0) {
            throw new IllegalArgumentException("The emtpy delimiter is forbidden for non discrete AlphabetContainers.");
        }
        return delim;
    }

    public ArbitraryFloatSequence(AlphabetContainer alphabetContainer, SequenceAnnotation[] annotation, SymbolExtractor extractor) throws WrongAlphabetException, WrongSequenceTypeException {
        super(alphabetContainer, annotation);
        this.content = new float[extractor.countElements()];
        for (int k = 0; k < this.content.length; ++k) {
            this.content[k] = (float)alphabetContainer.getCode(k, extractor.nextElement());
        }
    }

    @Override
    public double continuousVal(int pos) {
        return this.content[pos];
    }

    @Override
    public int discreteVal(int pos) {
        return this.toDiscrete(pos, this.content[pos]);
    }

    @Override
    public int getLength() {
        return this.content.length;
    }

    @Override
    protected ArbitraryFloatSequence flatCloneWithoutAnnotation() {
        try {
            return new ArbitraryFloatSequence(this.alphabetCon, null, this.content);
        }
        catch (Exception doesnothappen) {
            throw new RuntimeException(doesnothappen);
        }
    }

    @Override
    public boolean isMultiDimensional() {
        return false;
    }

    @Override
    public float[] getEmptyContainer() {
        return new float[1];
    }

    @Override
    public void fillContainer(float[] container, int pos) {
        container[0] = (float)this.continuousVal(pos);
    }

    @Override
    public int compareTo(float[] t1, float[] t2) {
        if (t1.length == 1 && t2.length == 1) {
            return (int)Math.signum(t1[0] - t2[0]);
        }
        return t1.length - t2.length;
    }

    @Override
    protected Object getEmptyRepresentation() {
        return new StringBuffer();
    }

    @Override
    protected void addToRepresentation(Object representation, int pos, String delim) {
        ((StringBuffer)representation).append(this.alphabetCon.getSymbol(pos, this.continuousVal(pos)) + delim);
    }

    @Override
    protected String getStringRepresentation(Object representation) {
        return representation.toString();
    }

    @Override
    protected int hashCodeForPos(int pos) {
        long bits = Double.doubleToLongBits(this.continuousVal(pos));
        return (int)(bits ^ bits >>> 32);
    }

    public static DataSet getDataSet(AlphabetContainer con, String filename, SequenceAnnotationParser parser) throws FileNotFoundException, WrongAlphabetException, WrongSequenceTypeException, EmptyDataSetException, IOException {
        return ArbitraryFloatSequence.getDataSet(con, new SparseStringExtractor(filename, '>', parser));
    }

    public static DataSet getDataSet(AlphabetContainer con, String filename) throws FileNotFoundException, WrongAlphabetException, WrongSequenceTypeException, EmptyDataSetException, IOException {
        return ArbitraryFloatSequence.getDataSet(con, new SparseStringExtractor(filename));
    }

    public static DataSet getDataSet(AlphabetContainer con, AbstractStringExtractor ... se) throws WrongAlphabetException, WrongSequenceTypeException, EmptyDataSetException {
        LinkedList<ArbitraryFloatSequence> list = new LinkedList<ArbitraryFloatSequence>();
        SymbolExtractor symEx = new SymbolExtractor(con.getDelim());
        String annot = null;
        for (int i = 0; i < se.length; ++i) {
            while (se[i].hasMoreElements()) {
                SequenceAnnotation[] anns = se[i].getCurrentSequenceAnnotations();
                String s = (String)se[i].nextElement();
                symEx.setStringToBeParsed(s);
                list.add(new ArbitraryFloatSequence(con, anns, symEx));
            }
            annot = i == 0 ? se[i].getAnnotation() : annot + ", " + se[i].getAnnotation();
        }
        return new DataSet(annot, list.toArray(new Sequence[0]));
    }
}

