/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters;

import de.jstacs.DataType;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.utils.ComparableElement;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class ParameterSetTagger {
    private Hashtable<String, ComparableElement<Parameter, Integer>> tagParameterHashtable = new Hashtable();

    public ParameterSetTagger(String[] tags, ParameterSet ... sets) {
        int t = 0;
        for (int s = 0; s < sets.length; ++s) {
            int n = 0;
            while (n < sets[s].getNumberOfParameters()) {
                if (this.tagParameterHashtable.containsKey(tags[t])) {
                    throw new IllegalArgumentException("The tags have to be unambiguous. See tag: " + tags[t]);
                }
                this.tagParameterHashtable.put(tags[t], new ComparableElement<Parameter, Integer>(sets[s].getParameterAt(n), t));
                ++n;
                ++t;
            }
        }
        if (tags.length != t) {
            throw new IllegalArgumentException("Not all tags have been used.");
        }
    }

    public void fillParameters(String delimiter, String ... args) throws IllegalArgumentException, SimpleParameter.IllegalValueException {
        for (int i = 0; i < args.length; ++i) {
            int idx = args[i].indexOf(delimiter);
            if (idx < 0) {
                throw new IllegalArgumentException("Unable to assign argument " + i + " to a parameter: " + args[i]);
            }
            this.setValueFromTag(args[i].substring(0, idx), args[i].substring(idx + delimiter.length()));
        }
    }

    public Parameter getParameterFromTag(String tag) {
        return this.tagParameterHashtable.get(tag).getElement();
    }

    public boolean isSet(String tag) {
        return this.getParameterFromTag(tag).isSet();
    }

    public Object getValueFromTag(String tag) {
        return this.getParameterFromTag(tag).getValue();
    }

    public <T> T getValueFromTag(String tag, Class<T> c) {
        return (T)this.getValueFromTag(tag);
    }

    public void setValueFromTag(String tag, Object value) throws SimpleParameter.IllegalValueException {
        Parameter p = null;
        try {
            p = this.getParameterFromTag(tag);
        }
        catch (NullPointerException ex) {
            throw new SimpleParameter.IllegalValueException("No parameter with tag \"" + tag + "\" in set of parameters.");
        }
        if (p.getDatatype() != DataType.STRING && value instanceof String && ((String)value).length() == 0) {
            value = null;
        }
        p.setValue(value);
    }

    public boolean hasDefaultOrIsSet() {
        Iterator<Map.Entry<String, ComparableElement<Parameter, Integer>>> it = this.tagParameterHashtable.entrySet().iterator();
        Parameter current = null;
        while (it.hasNext() && (!(current = it.next().getValue().getElement()).isRequired() || current.hasDefaultOrIsSet())) {
            current = null;
        }
        return current == null;
    }

    public String toString(Comparator<Map.Entry<String, ComparableElement<Parameter, Integer>>> ec) {
        Iterator<Map.Entry<String, ComparableElement<Parameter, Integer>>> it = this.tagParameterHashtable.entrySet().iterator();
        Map.Entry[] all = new Map.Entry[this.tagParameterHashtable.size()];
        int i = 0;
        while (it.hasNext()) {
            all[i] = it.next();
            ++i;
        }
        Arrays.sort(all, ec);
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < all.length; ++i) {
            sb.append((String)all[i].getKey() + "\t... " + ((Parameter)((ComparableElement)all[i].getValue()).getElement()).toString() + "\n");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(new RankEntryComparator<String, Parameter>());
    }

    public class RankEntryComparator<K, V>
    implements Comparator<Map.Entry<K, ComparableElement<V, Integer>>> {
        @Override
        public int compare(Map.Entry<K, ComparableElement<V, Integer>> o1, Map.Entry<K, ComparableElement<V, Integer>> o2) {
            return o1.getValue().getWeight() - o2.getValue().getWeight();
        }
    }

    public static class KeyEntryComparator<K extends Comparable<K>, V>
    implements Comparator<Map.Entry<K, V>> {
        @Override
        public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
            return ((Comparable)o1.getKey()).compareTo(o2.getKey());
        }
    }
}

