/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.WrongLengthException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.TrainableState;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.Emission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.SilentEmission;
import java.text.NumberFormat;
import javax.naming.OperationNotSupportedException;

public class SimpleState
implements TrainableState {
    protected Emission e;
    protected String name;
    protected boolean forward;

    public SimpleState(Emission e, String name, boolean forward) {
        this.e = e;
        this.name = name;
        this.forward = forward;
    }

    @Override
    public String getGraphvizNodeOptions(double weight, double maxWeight, NumberFormat nf) {
        String res = "shape=" + this.e.getNodeShape(this.forward) + ", label=" + this.e.getNodeLabel(weight < 0.0 ? weight : (maxWeight - weight) / maxWeight, this.name, nf);
        if (weight > 0.0) {
            res = res + ", width=2,height=2,style=filled,fillcolor=\"0 0 " + (maxWeight - weight) / maxWeight + "\"";
        }
        return res;
    }

    @Override
    public double getLogScoreFor(int startPos, int endPos, Sequence seq) throws WrongLengthException, OperationNotSupportedException {
        return this.e.getLogProbFor(this.forward, startPos, endPos, seq);
    }

    @Override
    public void addToStatistic(int startPos, int endPos, double weight, Sequence seq) throws OperationNotSupportedException {
        this.e.addToStatistic(this.forward, startPos, endPos, weight, seq);
    }

    @Override
    public boolean isSilent() {
        return this.e instanceof SilentEmission;
    }

    @Override
    public String toString(NumberFormat nf) {
        AlphabetContainer con = this.e.getAlphabetContainer();
        return "state " + this.name + (con == null || !con.isDiscrete() ? "" : " " + (this.forward ? "forward" : "reverse")) + "\n" + this.e.toString(nf);
    }
}

