/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.Emission;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.random.DiMRGParams;
import de.jstacs.utils.random.DirichletMRG;
import de.jstacs.utils.random.DirichletMRGParams;
import de.jstacs.utils.random.FastDirichletMRGParams;
import java.text.NumberFormat;
import java.util.Arrays;
import javax.naming.OperationNotSupportedException;

public final class MixtureEmission
implements Emission {
    private Emission[] emission;
    private double[] hyper;
    private double[] logProb;
    private double[] help;
    private double[] statistic;
    private static final String XML_TAG = "MixtureEmission";

    public MixtureEmission(Emission[] emission, double[] hyperParameters) throws CloneNotSupportedException {
        if (hyperParameters != null && emission.length != hyperParameters.length) {
            throw new IllegalArgumentException("The number of emissions and the number of hyper-parameters has to be equal.");
        }
        AlphabetContainer con = emission[0].getAlphabetContainer();
        for (int e = 1; e < emission.length; ++e) {
            if (!con.checkConsistency(emission[e].getAlphabetContainer())) {
                throw new IllegalArgumentException("The emissions must work on the same AlphabetContainer.");
            }
            if (hyperParameters == null || !(hyperParameters[e] < 0.0)) continue;
            throw new IllegalArgumentException("The hyper-parameters have to be non-negative.");
        }
        this.emission = (Emission[])ArrayHandler.clone((Cloneable[])emission);
        this.hyper = hyperParameters == null ? new double[emission.length] : (double[])hyperParameters.clone();
        this.logProb = new double[emission.length];
        Arrays.fill(this.logProb, -Math.log(emission.length));
        this.init();
    }

    public MixtureEmission(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, XML_TAG);
        this.emission = (Emission[])XMLParser.extractObjectForTags(xml, "emissions");
        this.hyper = (double[])XMLParser.extractObjectForTags(xml, "hyper");
        this.logProb = (double[])XMLParser.extractObjectForTags(xml, "logProb");
        this.init();
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.emission, "emissions");
        XMLParser.appendObjectWithTags(xml, this.hyper, "hyper");
        XMLParser.appendObjectWithTags(xml, this.logProb, "logProb");
        XMLParser.addTags(xml, XML_TAG);
        return xml;
    }

    private void init() {
        this.help = new double[this.emission.length];
        this.statistic = new double[this.emission.length];
    }

    public MixtureEmission clone() throws CloneNotSupportedException {
        MixtureEmission clone = (MixtureEmission)super.clone();
        clone.emission = (Emission[])ArrayHandler.clone((Cloneable[])this.emission);
        clone.help = (double[])this.help.clone();
        clone.hyper = (double[])this.hyper.clone();
        clone.logProb = (double[])this.logProb.clone();
        clone.statistic = (double[])this.statistic.clone();
        return clone;
    }

    @Override
    public void joinStatistics(Emission ... emissions) {
        int j;
        int i;
        Emission[] temp = new Emission[emissions.length];
        for (i = 0; i < this.emission.length; ++i) {
            for (j = 0; j < emissions.length; ++j) {
                temp[j] = ((MixtureEmission)emissions[j]).emission[j];
            }
            this.emission[i].joinStatistics(temp);
        }
        for (i = 0; i < emissions.length; ++i) {
            if (emissions[i] == this) continue;
            for (j = 0; j < this.statistic.length; ++j) {
                int n = j;
                this.statistic[n] = this.statistic[n] + ((MixtureEmission)emissions[i]).statistic[j];
            }
        }
        for (i = 0; i < emissions.length; ++i) {
            if (emissions[i] == this) continue;
            System.arraycopy(this.statistic, 0, ((MixtureEmission)emissions[i]).statistic, 0, this.statistic.length);
        }
    }

    @Override
    public void addToStatistic(boolean forward, int startPos, int endPos, double weight, Sequence seq) throws OperationNotSupportedException {
        int e;
        for (e = 0; e < this.emission.length; ++e) {
            this.help[e] = this.logProb[e] - this.emission[e].getLogProbFor(forward, startPos, endPos, seq);
        }
        Normalisation.logSumNormalisation(this.help);
        for (e = 0; e < this.emission.length; ++e) {
            this.emission[e].addToStatistic(forward, startPos, endPos, weight * this.help[e], seq);
            int n = e;
            this.statistic[n] = this.statistic[n] + this.help[e];
        }
    }

    @Override
    public void estimateFromStatistic() {
        int e;
        double sum = 0.0;
        for (e = 0; e < this.emission.length; ++e) {
            this.emission[e].estimateFromStatistic();
            int n = e;
            this.statistic[n] = this.statistic[n] + this.hyper[e];
            sum += this.statistic[e];
        }
        sum = Math.log(sum);
        for (e = 0; e < this.emission.length; ++e) {
            this.logProb[e] = Math.log(this.statistic[e]) - sum;
        }
    }

    @Override
    public AlphabetContainer getAlphabetContainer() {
        return this.emission[0].getAlphabetContainer();
    }

    @Override
    public double getLogPriorTerm() {
        double lp = 0.0;
        for (int e = 0; e < this.emission.length; ++e) {
            lp += this.emission[e].getLogPriorTerm();
            lp += this.logProb[e] * this.hyper[e];
        }
        return lp;
    }

    @Override
    public double getLogProbFor(boolean forward, int startPos, int endPos, Sequence seq) throws OperationNotSupportedException {
        for (int e = 0; e < this.emission.length; ++e) {
            this.help[e] = this.logProb[e] - this.emission[e].getLogProbFor(forward, startPos, endPos, seq);
        }
        return Normalisation.getLogSum(0, this.emission.length, this.help);
    }

    @Override
    public void initializeFunctionRandomly() {
        DiMRGParams p;
        int zero = 0;
        for (int e = 0; e < this.emission.length; ++e) {
            if (this.hyper[e] != 0.0) continue;
            ++zero;
        }
        if (zero == this.emission.length) {
            p = new FastDirichletMRGParams(1.0);
        } else if (zero == 0) {
            p = new DirichletMRGParams(this.hyper);
        } else {
            throw new IllegalArgumentException();
        }
        DirichletMRG.DEFAULT_INSTANCE.generateLog(this.logProb, 0, this.emission.length, p);
        for (int e = 0; e < this.emission.length; ++e) {
            this.emission[e].initializeFunctionRandomly();
        }
    }

    @Override
    public void resetStatistic() {
        for (int e = 0; e < this.emission.length; ++e) {
            this.emission[e].resetStatistic();
        }
    }

    @Override
    public String getNodeShape(boolean forward) {
        String res = "";
        if (this.getAlphabetContainer().isReverseComplementable()) {
            res = res + "\"house\", orientation=";
            if (forward) {
                res = res + "-";
            }
            res = res + "90";
        } else {
            res = res + "\"box\"";
        }
        return res;
    }

    @Override
    public String getNodeLabel(double weight, String name, NumberFormat nf) {
        return "\"" + name + "\"";
    }

    @Override
    public void setParameters(Emission t) throws IllegalArgumentException {
        if (!t.getClass().equals(this.getClass())) {
            throw new IllegalArgumentException("The emissions are not comparable.");
        }
        MixtureEmission tt = (MixtureEmission)t;
        for (int i = 0; i < this.emission.length; ++i) {
            this.emission[i].setParameters(tt.emission[i]);
        }
    }

    @Override
    public String toString(NumberFormat nf) {
        StringBuffer sb = new StringBuffer(this.emission.length * 100000);
        for (int i = 0; i < this.emission.length; ++i) {
            sb.append(nf.format(Math.exp(this.logProb[i])) + "\n" + this.emission[i].toString(nf));
        }
        return null;
    }
}

