/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils;

import de.jstacs.utils.Pair;
import de.jstacs.utils.ToolBox;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class SeqLogoPlotter {
    public static void plotLogoToPNG(String path, int height, double[][] ps) throws IOException {
        Pair<BufferedImage, Graphics2D> pair = SeqLogoPlotter.getBufferedImageAndGraphics(height, ps);
        Graphics2D g = pair.getSecondElement();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        SeqLogoPlotter.plotLogo(g, height, ps);
        ImageIO.write((RenderedImage)pair.getFirstElement(), "png", new File(path));
    }

    public static BufferedImage plotLogoToBufferedImage(int height, double[][] ps) {
        Pair<BufferedImage, Graphics2D> pair = SeqLogoPlotter.getBufferedImageAndGraphics(height, ps);
        Graphics2D g = pair.getSecondElement();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        SeqLogoPlotter.plotLogo(g, height, ps);
        return pair.getFirstElement();
    }

    protected static Pair<BufferedImage, Graphics2D> getBufferedImageAndGraphics(int height, double[][] ps) {
        int w = SeqLogoPlotter.getWidth(height, ps);
        BufferedImage img = new BufferedImage(w, height, 1);
        Graphics2D g = (Graphics2D)img.getGraphics();
        return new Pair<BufferedImage, Graphics2D>(img, g);
    }

    public static void plotLogo(Graphics2D g, int h, double[][] ps) {
        SeqLogoPlotter.plotLogo(g, h, ps, null, "Position", "bits");
    }

    public static void plotLogo(Graphics2D g, int height, double[][] ps, String[] labels, String labX, String labY) {
        int w = SeqLogoPlotter.getWidth(height, ps);
        SeqLogoPlotter.plotLogo(g, w, height, ps, labels, labX, labY);
    }

    public static int getWidth(int height, double[][] ps) {
        return (int)((double)height / 6.0 * ((double)ps.length + 1.5));
    }

    public static int getHeight(int width, double[][] ps) {
        return (int)((double)width * 6.0 / ((double)ps.length + 1.5));
    }

    public static void plotLogo(Graphics2D g, int w, int h, double[][] ps, String[] labels, String labX, String labY) {
        SeqLogoPlotter.plotLogo(g, 0, h, w, h, ps, labels, labX, labY);
    }

    public static void plotLogo(Graphics2D g, int x, int y, int w, int h, double[][] ps, String[] labels, String labX, String labY) {
        Rectangle2D rect;
        g.setColor(Color.WHITE);
        g.fillRect(x, y - h, w, h);
        Font font = new Font(g.getFont().getName(), 1, h / 17);
        g.setFont(font);
        if (labels == null) {
            labels = new String[ps.length];
            for (int i = 0; i < ps.length; ++i) {
                labels[i] = i + 1 + "";
            }
        }
        double wl = (double)h * 0.25;
        double w2 = ((double)w - wl) / (double)ps.length;
        double x2 = (double)x + wl * 0.9;
        double h2 = (double)h * 0.7;
        double y2 = (double)y * 0.75;
        g.setColor(Color.BLACK);
        g.setStroke(new BasicStroke(h / 400 + 1));
        g.drawLine((int)x2, (int)(y2 * 1.04) + 1, (int)(x2 + w2 * (double)ps.length), (int)(y2 * 1.04) + 1);
        g.drawLine((int)(x2 * 0.94) - 1, (int)y2, (int)(x2 * 0.94) - 1, (int)(y2 - h2));
        String[] labs = new String[]{"0", "0.5", "1", "1.5", "2"};
        for (int i = 0; i <= 4; ++i) {
            g.drawLine((int)(x2 * 0.7), (int)(y2 - (double)i * h2 / 4.0), (int)(x2 * 0.94) - 1, (int)(y2 - (double)i * h2 / 4.0));
            rect = g.getFontMetrics().getStringBounds(labs[i], g);
            g.drawString(labs[i], (int)(x2 * 0.6 - rect.getWidth() - 2.0), (int)(y2 - (double)i * h2 / 4.0 - rect.getCenterY()));
        }
        AffineTransform back = g.getTransform();
        g.rotate(-1.5707963267948966);
        rect = g.getFontMetrics().getStringBounds(labY, g);
        g.drawString(labY, -((int)(y2 - 2.0 * h2 / 4.0 + rect.getCenterX())), (int)((double)x + rect.getWidth() / 2.0));
        g.setTransform(back);
        rect = g.getFontMetrics().getStringBounds(labX, g);
        g.drawString(labX, (int)(x2 + w2 * (double)ps.length / 2.0 - rect.getCenterX()), (int)((double)y - 0.3 * rect.getHeight()));
        for (int i = 0; i < ps.length; ++i) {
            SeqLogoPlotter.plotLogo(g, x2, y2, w2, h2, ps[i]);
            g.setColor(Color.BLACK);
            rect = g.getFontMetrics().getStringBounds(labels[i], g);
            g.drawString(labels[i], (float)(x2 + w2 / 2.0 - rect.getCenterX()), (float)(y2 + 2.0 * rect.getHeight()));
            x2 += w2;
        }
    }

    public static void plotTALgetterLogoToPNG(String path, int height, double[][] ps, double[] imp, String[] lab) throws IOException {
        Pair<BufferedImage, Graphics2D> pair = SeqLogoPlotter.getBufferedImageAndGraphics(height, ps);
        Graphics2D g = pair.getSecondElement();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int w = SeqLogoPlotter.getWidth(height, ps);
        SeqLogoPlotter.plotTALgetterLogo(g, 0, height, w, height, ps, imp, lab, "RVD", "bits", "Importance");
        ImageIO.write((RenderedImage)pair.getFirstElement(), "png", new File(path));
    }

    public static BufferedImage plotTALgetterLogoToBufferedImage(int height, double[][] ps, double[] imp, String[] lab) {
        Pair<BufferedImage, Graphics2D> pair = SeqLogoPlotter.getBufferedImageAndGraphics(height, ps);
        Graphics2D g = pair.getSecondElement();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int w = SeqLogoPlotter.getWidth(height, ps);
        SeqLogoPlotter.plotTALgetterLogo(g, 0, height, w, height, ps, imp, lab, "RVD", "bits", "Importance");
        return pair.getFirstElement();
    }

    public static void plotTALgetterLogo(Graphics2D g, int x, int y, int w, int h, double[][] ps, double[] imp, String[] labels, String labX, String labY, String labY2) {
        int i;
        Rectangle2D rect;
        g.setColor(Color.WHITE);
        g.fillRect(x, y - h, w, h);
        Font font = new Font(g.getFont().getName(), 1, h / 17);
        g.setFont(font);
        if (labels == null) {
            labels = new String[ps.length];
            for (int i2 = 0; i2 < ps.length; ++i2) {
                labels[i2] = i2 + 1 + "";
            }
        }
        double wl = (double)h * 0.5;
        double w2 = ((double)w - wl) / (double)ps.length;
        double x2 = (double)x + wl * 0.45;
        double h2 = (double)h * 0.7;
        double y2 = (double)y * 0.75;
        g.setColor(Color.BLACK);
        g.setStroke(new BasicStroke(h / 400 + 1));
        g.drawLine((int)x2, (int)(y2 * 1.04) + 1, (int)(x2 + w2 * (double)ps.length), (int)(y2 * 1.04) + 1);
        g.drawLine((int)(x2 * 0.94) - 1, (int)y2, (int)(x2 * 0.94) - 1, (int)(y2 - h2));
        String[] labs = new String[]{"0", "0.5", "1", "1.5", "2"};
        for (int i3 = 0; i3 <= 4; ++i3) {
            g.drawLine((int)(x2 * 0.7), (int)(y2 - (double)i3 * h2 / 4.0), (int)(x2 * 0.94) - 1, (int)(y2 - (double)i3 * h2 / 4.0));
            rect = g.getFontMetrics().getStringBounds(labs[i3], g);
            g.drawString(labs[i3], (int)(x2 * 0.6 - rect.getWidth() - 2.0), (int)(y2 - (double)i3 * h2 / 4.0 - rect.getCenterY()));
        }
        AffineTransform back = g.getTransform();
        g.rotate(-1.5707963267948966);
        rect = g.getFontMetrics().getStringBounds(labY, g);
        g.drawString(labY, -((int)(y2 - 2.0 * h2 / 4.0 + rect.getCenterX())), (int)((double)x + rect.getHeight()));
        g.setTransform(back);
        rect = g.getFontMetrics().getStringBounds(labX, g);
        g.drawString(labX, (int)(x2 + w2 * (double)ps.length / 2.0 - rect.getCenterX()), (int)((double)y - 0.3 * rect.getHeight()));
        for (int i4 = 0; i4 < ps.length; ++i4) {
            SeqLogoPlotter.plotLogo(g, x2, y2, w2, h2, ps[i4]);
            g.setColor(Color.BLACK);
            rect = g.getFontMetrics().getStringBounds(labels[i4], g);
            g.drawString(labels[i4], (float)(x2 + w2 / 2.0 - rect.getCenterX()), (float)(y2 + 2.0 * rect.getHeight()));
            x2 += w2;
        }
        g.drawLine((int)(x2 + w2 * 0.1) + 1, (int)y2, (int)(x2 + w2 * 0.1) + 1, (int)(y2 - h2));
        labs = new String[]{"0", "0.5", "1"};
        Rectangle2D rect2 = g.getFontMetrics().getStringBounds("0.5", g);
        for (i = 0; i <= 2; ++i) {
            g.drawLine((int)(x2 + w2 * 0.34) + 2, (int)(y2 - (double)i * h2 / 2.0), (int)(x2 + w2 * 0.1) + 1, (int)(y2 - (double)i * h2 / 2.0));
            g.drawString(labs[i], (int)(x2 + w2 * 0.5 + 2.0), (int)(y2 - (double)i * h2 / 2.0 - rect.getCenterY()));
        }
        back = g.getTransform();
        g.rotate(-1.5707963267948966);
        rect = g.getFontMetrics().getStringBounds(labY2, g);
        g.drawString(labY2, -((int)(y2 - 2.0 * h2 / 4.0 + rect.getCenterX())), (int)((double)w - rect.getHeight() / 2.0));
        g.setTransform(back);
        x2 = (double)x + wl * 0.45 + 2.0 * w2;
        g.setColor(Color.GRAY);
        for (i = 1; i < imp.length; ++i) {
            g.drawLine((int)(x2 - w2 / 2.0 + w2 / 20.0), (int)(y2 - h2 * imp[i - 1] + w2 / 20.0), (int)(x2 + w2 / 2.0 - w2 / 20.0), (int)(y2 - h2 * imp[i] + w2 / 20.0));
            x2 += w2;
        }
        x2 = (double)x + wl * 0.45 + w2;
        g.setColor(Color.BLUE);
        for (i = 0; i < imp.length; ++i) {
            g.fillRect((int)(x2 + w2 / 2.0 - w2 / 20.0), (int)(y2 - h2 * imp[i]), (int)(w2 / 10.0), (int)(w2 / 10.0));
            x2 += w2;
        }
    }

    private static void plotLogo(Graphics2D g, double x, double y, double w, double h, double[] p) {
        int i;
        double ic = Math.log(4.0) / Math.log(2.0);
        for (int i2 = 0; i2 < p.length; ++i2) {
            if (!(p[i2] > 0.0)) continue;
            ic += p[i2] * Math.log(p[i2]) / Math.log(2.0);
        }
        h *= (ic /= 2.0);
        double[] mp = (double[])p.clone();
        int i3 = 0;
        while (i3 < mp.length) {
            int n = i3++;
            mp[n] = mp[n] * -1.0;
        }
        int[] r = ToolBox.rank(mp, false);
        int[] order = new int[r.length];
        for (i = 0; i < r.length; ++i) {
            order[r[i]] = i;
        }
        for (i = 0; i < order.length; ++i) {
            double curr = p[order[i]];
            if (order[i] == 0) {
                g.setColor(Color.GREEN);
                g.fill(SeqLogoPlotter.getA(x, y, w, h * curr));
            } else if (order[i] == 1) {
                g.setColor(Color.BLUE);
                g.fill(SeqLogoPlotter.getC(x, y, w, h * curr));
            } else if (order[i] == 2) {
                g.setColor(Color.ORANGE);
                g.fill(SeqLogoPlotter.getG(x, y, w, h * curr));
            } else {
                g.setColor(Color.RED);
                g.fill(SeqLogoPlotter.getT(x, y, w, h * curr));
            }
            y -= h * curr;
        }
    }

    private static Area getC(double x, double y, double w, double h) {
        Ellipse2D.Double s = new Ellipse2D.Double(0.0, -90.0, 90.0, 90.0);
        Area a1 = new Area(s);
        Ellipse2D.Double s2 = new Ellipse2D.Double(15.0, -75.0, 60.0, 60.0);
        Area a2 = new Area(s2);
        a1.subtract(a2);
        Rectangle2D.Double s3 = new Rectangle2D.Double(65.0, -60.0, 30.0, 30.0);
        Area a3 = new Area(s3);
        a1.subtract(a3);
        AffineTransform t = new AffineTransform();
        t.scale(0.011363636363636364, 0.011111111111111112);
        t.scale(w, h);
        a1.transform(t);
        t = new AffineTransform();
        t.translate(x, y);
        a1.transform(t);
        return a1;
    }

    private static Area getT(double x, double y, double w, double h) {
        Rectangle2D.Double s = new Rectangle2D.Double(37.5, -100.0, 15.0, 100.0);
        Area a1 = new Area(s);
        Rectangle2D.Double s2 = new Rectangle2D.Double(0.0, -100.0, 90.0, 15.0);
        Area a2 = new Area(s2);
        a1.add(a2);
        AffineTransform t = new AffineTransform();
        t.scale(0.011111111111111112, 0.01);
        t.scale(w, h);
        a1.transform(t);
        t = new AffineTransform();
        t.translate(x, y);
        a1.transform(t);
        return a1;
    }

    private static Area getG(double x, double y, double w, double h) {
        Ellipse2D.Double s = new Ellipse2D.Double(0.0, -90.0, 90.0, 90.0);
        Area a1 = new Area(s);
        Ellipse2D.Double s2 = new Ellipse2D.Double(15.0, -75.0, 60.0, 60.0);
        Area a2 = new Area(s2);
        a1.subtract(a2);
        Rectangle2D.Double s3 = new Rectangle2D.Double(65.0, -60.0, 30.0, 30.0);
        Area a3 = new Area(s3);
        a1.subtract(a3);
        Rectangle2D.Double s4 = new Rectangle2D.Double(55.0, -40.0, 35.0, 15.0);
        Area a4 = new Area(s4);
        a1.add(a4);
        Rectangle2D.Double s5 = new Rectangle2D.Double(80.0, -40.0, 10.0, 40.0);
        Area a5 = new Area(s5);
        a1.add(a5);
        AffineTransform t = new AffineTransform();
        t.scale(0.011111111111111112, 0.011111111111111112);
        t.scale(w, h);
        a1.transform(t);
        t = new AffineTransform();
        t.translate(x, y);
        a1.transform(t);
        return a1;
    }

    private static Area getA(double x, double y, double w, double h) {
        Polygon s = new Polygon(new int[]{0, 40, 50, 90, 75, 45, 45, 15, 0}, new int[]{0, -100, -100, 0, 0, -80, -80, 0, 0}, 9);
        Area a = new Area(s);
        Polygon s2 = new Polygon(new int[]{20, 70, 70, 20}, new int[]{-35, -35, -50, -50}, 4);
        Area a2 = new Area(s2);
        a.add(a2);
        AffineTransform t = new AffineTransform();
        t.scale(0.011111111111111112, 0.01);
        t.scale(w, h);
        a.transform(t);
        t = new AffineTransform();
        t.translate(x, y);
        a.transform(t);
        return a;
    }
}

