/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.game12;

import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.game.ElementRecognizer;
import org.biojava.bio.seq.io.game12.StAXFeatureHandler;
import org.biojava.bio.seq.io.game12.StAXHandlerFactory;
import org.biojava.utils.stax.StAXContentHandler;
import org.biojava.utils.stax.StringElementHandlerBase;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GAMESeqHandler
extends StAXFeatureHandler {
    private String seqId;
    private int seqLength = 0;
    public static final StAXHandlerFactory GAME_SEQ_HANDLER_FACTORY = new StAXHandlerFactory(){

        public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
            return new GAMESeqHandler(staxenv);
        }
    };

    GAMESeqHandler(StAXFeatureHandler staxenv) {
        super(staxenv);
        super.addHandler(new ElementRecognizer.ByLocalName("name"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new NameHandler();
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("description"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new DescriptionHandler();
            }
        });
    }

    public int getSequenceLength() {
        return this.seqLength;
    }

    public void startElementHandler(String nsURI, String localName, String qName, Attributes attrs) throws SAXException {
        this.seqId = attrs.getValue("id").trim();
        String length = attrs.getValue("length").trim();
        try {
            this.listener.setName(this.seqId);
            this.listener.addSequenceProperty("length", length);
        }
        catch (ParseException pe) {
            throw new SAXException("could not set sequence properties.");
        }
    }

    public void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler staxHandler) throws SAXException {
    }

    private class DescriptionHandler
    extends StringElementHandlerBase {
        private DescriptionHandler() {
        }

        protected void setStringValue(String s) {
        }
    }

    private class NameHandler
    extends StringElementHandlerBase {
        private NameHandler() {
        }

        protected void setStringValue(String s) {
        }
    }
}

