/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.utils;

import de.jstacs.classifiers.AbstractClassifier;
import de.jstacs.classifiers.AbstractScoreBasedClassifier;
import de.jstacs.data.DataSet;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.ImageResult;
import de.jstacs.utils.REnvironment;
import javax.naming.OperationNotSupportedException;

public class ClassificationVisualizer {
    private ClassificationVisualizer() {
    }

    private static String getPlotScoresCmd(AbstractScoreBasedClassifier cl, DataSet class0, DataSet class1, REnvironment e, int bins, double density, String plotOptions) throws Exception {
        StringBuffer b = new StringBuffer(100000);
        if (cl.getNumberOfClasses() != 2) {
            throw new OperationNotSupportedException("This method is only possible for 2-class-classifiers.");
        }
        e.createVector("sample0", cl.getScores(class0));
        e.createVector("sample1", cl.getScores(class1));
        b.append("min0 = min( sample0 ); max0 = max( sample0 );\n");
        b.append("min1 = min( sample1 ); max1 = max( sample1 );\n");
        b.append("min = min( min0, min1 ); max = max( max0, max1 );\n");
        b.append("s=(max-min)/" + bins + "; binBreaks = seq(min,max,by=s);\n");
        b.append("h0 = hist( sample0, breaks=c(min0,s+binBreaks[binBreaks>=min0 & binBreaks<=max0]), plot=F );\n");
        b.append("h1 = hist( sample1, breaks=c(min1,s+binBreaks[binBreaks>=min1 & binBreaks<=max1]), plot=F );\n\n");
        plotOptions = plotOptions == null ? "" : plotOptions.trim();
        if (plotOptions.length() == 0) {
            plotOptions = ", xlim=c(min, max), ylim=c(0, max(h0$density,h1$density)), xlab=\"ratio of the scores\", ylab=\"density\", main=\"histogram for " + ClassificationVisualizer.getClassifierName(cl) + "\"";
        } else if (plotOptions.charAt(0) != ',') {
            plotOptions = ", " + plotOptions;
        }
        int c1 = 4;
        int c2 = 2;
        b.append("plot( h0, col=" + c1 + ", border=" + c1 + ", angle=45, density=" + density + ", freq=F " + plotOptions + ");\n");
        b.append("plot( h1, col=" + c2 + ", border=" + c2 + ", angle=-45, density=" + density + ", add=T, freq=F );\n");
        return b.toString();
    }

    public static ImageResult plotScores(AbstractScoreBasedClassifier cl, DataSet class0, DataSet class1, REnvironment e, int bins, double density, String plotOptions) throws Exception {
        return new ImageResult("plot of the scores", "this plot shows the scores that are used to assign the classes", e.plot(ClassificationVisualizer.getPlotScoresCmd(cl, class0, class1, e, bins, density, plotOptions), 720.0, 360.0));
    }

    public static void plotScores(AbstractScoreBasedClassifier cl, DataSet class0, DataSet class1, REnvironment e, int bins, double density, String plotOptions, String fName) throws Exception {
        e.plotToPDF(ClassificationVisualizer.getPlotScoresCmd(cl, class0, class1, e, bins, density, plotOptions), 10.0, 5.0, fName, true);
    }

    public static ImageResult getScatterplot(AbstractScoreBasedClassifier cl1, AbstractScoreBasedClassifier cl2, DataSet class0, DataSet class1, REnvironment e, boolean drawThreshold) throws Exception {
        if (cl1.getNumberOfClasses() != 2 || cl2.getNumberOfClasses() != 2) {
            throw new OperationNotSupportedException("This method is only possible for 2-class-classifiers.");
        }
        e.createVector("cl1_0", cl1.getScores(class0));
        e.createVector("cl2_0", cl2.getScores(class0));
        e.createVector("cl1_1", cl1.getScores(class1));
        e.createVector("cl2_1", cl2.getScores(class1));
        e.voidEval("xlim = c(min(cl1_0,cl1_1),max(cl1_0,cl1_1))");
        e.voidEval("ylim = c(min(cl2_0,cl2_1),max(cl2_0,cl2_1))");
        String pltcmd = "plot( cl1_1, cl2_1, col=2, xlim = xlim, ylim = ylim, xlab=\"" + ClassificationVisualizer.getClassifierName(cl1) + "\", ylab=\"" + ClassificationVisualizer.getClassifierName(cl2) + "\", main=\"" + ClassificationVisualizer.getTitle(class0, class1) + "\"); points( cl1_0, cl2_0, col=1, pch=2 );";
        if (drawThreshold) {
            pltcmd = pltcmd + "lines( c(0,0), ylim, lty=2, col=3 ); lines( xlim, c(0,0), lty=2, col=3 )";
        }
        return new ImageResult("scatterplot of the scores", "this plot shows the scores that are used to assign the classes scattered against each other", e.plot(pltcmd, 720.0, 720.0));
    }

    private static String getClassifierName(AbstractClassifier cl) {
        CategoricalResult[] cat = cl.getClassifierAnnotation();
        String res = cat[0].getValue() + "(" + cat[1].getValue();
        for (int i = 2; i < cat.length; ++i) {
            res = res + "; " + cat[i].getValue();
        }
        return res + ")";
    }

    private static String getTitle(DataSet class0, DataSet class1) {
        String res = "scatterplot for ";
        res = class0 != null && class1 != null ? res + class0.getAnnotation() + " and " + class1.getAnnotation() : (class0 == null ? res + class1.getAnnotation() : res + class0.getAnnotation());
        return res;
    }
}

