/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.ComplementableDiscreteAlphabet;
import de.jstacs.data.sequences.ArbitrarySequence;
import de.jstacs.data.sequences.ByteSequence;
import de.jstacs.data.sequences.IntSequence;
import de.jstacs.data.sequences.ShortSequence;
import de.jstacs.data.sequences.SimpleDiscreteSequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import java.util.Arrays;
import javax.naming.OperationNotSupportedException;

public abstract class Sequence<T>
implements Comparable<Sequence<T>> {
    protected AlphabetContainer alphabetCon;
    protected Sequence<T> rc;
    protected SequenceAnnotation[] annotation;
    private Integer hashCode;

    protected Sequence(AlphabetContainer container, SequenceAnnotation[] annotation) {
        if (container == null) {
            throw new NullPointerException();
        }
        this.alphabetCon = container;
        if (annotation != null) {
            this.annotation = (SequenceAnnotation[])annotation.clone();
        }
        this.hashCode = null;
    }

    public abstract double continuousVal(int var1);

    public abstract int discreteVal(int var1);

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Sequence)) {
            return false;
        }
        Sequence s = (Sequence)o;
        return this.compareTo(s) == 0 && this.alphabetCon.checkConsistency(s.alphabetCon);
    }

    public final AlphabetContainer getAlphabetContainer() {
        return this.alphabetCon;
    }

    public final SequenceAnnotation[] getAnnotation() {
        if (this.annotation != null) {
            return (SequenceAnnotation[])this.annotation.clone();
        }
        return null;
    }

    public SequenceAnnotation getSequenceAnnotationByTypeAndIdentifier(String type, String identifier) {
        if (this.annotation != null) {
            for (SequenceAnnotation ann : this.annotation) {
                if (!ann.getType().equals(type) || !ann.getIdentifier().equals(identifier)) continue;
                return ann;
            }
        }
        return null;
    }

    public SequenceAnnotation getSequenceAnnotationByType(String type, int idx) {
        if (this.annotation != null) {
            int i = 0;
            for (SequenceAnnotation ann : this.annotation) {
                if (!ann.getType().equals(type)) continue;
                if (i == idx) {
                    return ann;
                }
                ++i;
            }
        }
        return null;
    }

    public int getNumberOfSequenceAnnotationsByType(String type) {
        int i = 0;
        if (this.annotation != null) {
            for (SequenceAnnotation ann : this.annotation) {
                if (!ann.getType().equals(type)) continue;
                ++i;
            }
        }
        return i;
    }

    public Sequence<T> getCompositeSequence(AlphabetContainer abc, int[] starts, int[] lengths) {
        return new CompositeSequence(abc, this, starts, lengths);
    }

    public Sequence getCompositeSequence(int[] starts, int[] lengths) {
        return new CompositeSequence(this, starts, lengths);
    }

    public final Sequence getSubSequence(AlphabetContainer abc, int start) {
        return this.getSubSequence(abc, start, this.getLength() - start);
    }

    public Sequence getSubSequence(AlphabetContainer abc, int start, int length) {
        if (start == 0 && length == this.getLength()) {
            return this;
        }
        return new SubSequence(abc, this, start, length);
    }

    public final Sequence getSubSequence(int start) {
        return this.getSubSequence(start, this.getLength() - start);
    }

    public Sequence getSubSequence(int start, int length) {
        if (start == 0 && length == this.getLength()) {
            return this;
        }
        return new SubSequence(this, start, length);
    }

    public Sequence annotate(boolean add, SequenceAnnotation ... annotation) {
        Sequence seq = this.flatCloneWithoutAnnotation();
        if (add && annotation != null) {
            int num = annotation.length;
            if (this.annotation != null) {
                num += this.annotation.length;
            }
            SequenceAnnotation[] temp = new SequenceAnnotation[num];
            if (this.annotation != null) {
                num = this.annotation.length;
                System.arraycopy(this.annotation, 0, temp, 0, num);
            } else {
                num = 0;
            }
            System.arraycopy(annotation, 0, temp, num, annotation.length);
            seq.annotation = temp;
        } else {
            seq.annotation = annotation != null ? (SequenceAnnotation[])annotation.clone() : null;
        }
        return seq;
    }

    protected abstract Sequence flatCloneWithoutAnnotation();

    public abstract int getLength();

    public String toString() {
        return this.toString(this.alphabetCon.getDelim(), 0, this.getLength());
    }

    public String toString(int start) {
        return this.toString(this.alphabetCon.getDelim(), start, this.getLength());
    }

    public String toString(int start, int end) {
        return this.toString(this.alphabetCon.getDelim(), start, end);
    }

    @Override
    public int compareTo(Sequence<T> s) {
        int c = this.alphabetCon.compareTo(s.alphabetCon);
        if (c == 0) {
            int seqL;
            int l = this.getLength();
            if (l == (seqL = s.getLength())) {
                int i;
                T t1 = this.getEmptyContainer();
                T t2 = s.getEmptyContainer();
                for (i = 0; i < l; ++i) {
                    this.fillContainer(t1, i);
                    s.fillContainer(t2, i);
                    c = this.compareTo(t1, t2);
                    if (c != 0) break;
                }
                return i < l ? c : 0;
            }
            return l - seqL;
        }
        return c;
    }

    protected abstract int compareTo(T var1, T var2);

    protected int toDiscrete(int pos, double content) {
        return this.alphabetCon.toDiscrete(pos, content);
    }

    public String toString(String delim, int start, int end) {
        Object representation = this.getEmptyRepresentation();
        for (int i = start; i < end; ++i) {
            this.addToRepresentation(representation, i, delim);
        }
        return this.getStringRepresentation(representation);
    }

    protected abstract Object getEmptyRepresentation();

    protected abstract void addToRepresentation(Object var1, int var2, String var3);

    protected abstract String getStringRepresentation(Object var1);

    public static Sequence create(AlphabetContainer con, String sequence) throws WrongAlphabetException, IllegalArgumentException {
        return Sequence.create(con, sequence, con.getDelim());
    }

    public static Sequence create(AlphabetContainer con, String sequence, String delim) throws WrongAlphabetException, IllegalArgumentException {
        return Sequence.create(con, null, sequence, delim);
    }

    public static Sequence create(AlphabetContainer con, SequenceAnnotation[] annotation, String sequence, String delim) throws WrongAlphabetException, IllegalArgumentException {
        try {
            if (con.isDiscrete()) {
                int l = (int)con.getMaximalAlphabetLength();
                if (l <= 127) {
                    return new ByteSequence(con, annotation, sequence, delim);
                }
                if (l <= Short.MAX_VALUE) {
                    return new ShortSequence(con, annotation, sequence, delim);
                }
                if (l <= Integer.MAX_VALUE) {
                    return new IntSequence(con, annotation, sequence, delim);
                }
                throw new WrongAlphabetException("Could not encode. Too many symbols.");
            }
            return new ArbitrarySequence(con, annotation, sequence, delim);
        }
        catch (WrongSequenceTypeException e) {
            RuntimeException doesNotHappen = new RuntimeException(e.getMessage());
            doesNotHappen.setStackTrace(e.getStackTrace());
            throw doesNotHappen;
        }
    }

    public final Sequence reverse() throws OperationNotSupportedException {
        return this.reverse(0, this.getLength());
    }

    public Sequence reverse(int start, int end) throws OperationNotSupportedException {
        if (this.alphabetCon.isSimple()) {
            int i = 0;
            int j = end;
            try {
                if (this instanceof SimpleDiscreteSequence || this instanceof SubSequence && ((SubSequence)this).content instanceof SimpleDiscreteSequence) {
                    int[] erg = new int[j - start];
                    --j;
                    while (j >= start) {
                        erg[i] = this.discreteVal(j);
                        --j;
                        ++i;
                    }
                    return new IntSequence(this.alphabetCon, erg);
                }
                double[] erg = new double[j - start];
                --j;
                while (j >= start) {
                    erg[i] = this.continuousVal(j);
                    --j;
                    ++i;
                }
                return new ArbitrarySequence(this.alphabetCon, erg);
            }
            catch (Exception e) {
                RuntimeException doesNotHappen = new RuntimeException(e.getMessage());
                doesNotHappen.setStackTrace(e.getStackTrace());
                throw doesNotHappen;
            }
        }
        throw new OperationNotSupportedException("The sequence has to be simple.");
    }

    public Sequence complement() throws OperationNotSupportedException {
        return this.complement(0, this.getLength());
    }

    public Sequence reverseComplement() throws OperationNotSupportedException {
        return this.reverseComplement(0, this.getLength());
    }

    public Sequence complement(int start, int end) throws OperationNotSupportedException {
        if (this.alphabetCon.isReverseComplementable()) {
            ComplementableDiscreteAlphabet cda = (ComplementableDiscreteAlphabet)this.alphabetCon.getAlphabetAt(0);
            try {
                if (cda.length() > 127.0) {
                    int[] erg = new int[end - start];
                    int i = 0;
                    for (int j = start; j < end; ++j) {
                        erg[i] = cda.getComplementaryCode(this.discreteVal(j));
                        ++i;
                    }
                    return new IntSequence(this.alphabetCon, erg);
                }
                byte[] erg = new byte[end - start];
                int i = 0;
                for (int j = start; j < end; ++j) {
                    erg[i] = (byte)cda.getComplementaryCode(this.discreteVal(j));
                    ++i;
                }
                return new ByteSequence(this.alphabetCon, erg);
            }
            catch (Exception e) {
                RuntimeException doesNotHappen = new RuntimeException(e.getMessage());
                doesNotHappen.setStackTrace(e.getStackTrace());
                throw doesNotHappen;
            }
        }
        throw new OperationNotSupportedException("The alphabet of sequence has to be complementable.");
    }

    public Sequence reverseComplement(int start, int end) throws OperationNotSupportedException {
        if (this.rc != null && start == 0 && end == this.getLength()) {
            return this.rc;
        }
        if (this.alphabetCon.isReverseComplementable()) {
            try {
                SimpleDiscreteSequence revComp;
                ComplementableDiscreteAlphabet cda = (ComplementableDiscreteAlphabet)this.alphabetCon.getAlphabetAt(0);
                int i = 0;
                int j = end;
                if (cda.length() > 127.0) {
                    int[] erg = new int[end - start];
                    --j;
                    while (j >= start) {
                        erg[i] = cda.getComplementaryCode(this.discreteVal(j));
                        --j;
                        ++i;
                    }
                    revComp = new IntSequence(this.alphabetCon, erg);
                } else {
                    byte[] erg = new byte[end - start];
                    --j;
                    while (j >= start) {
                        erg[i] = (byte)cda.getComplementaryCode(this.discreteVal(j));
                        --j;
                        ++i;
                    }
                    revComp = new ByteSequence(this.alphabetCon, erg);
                }
                if (start == 0 && end == this.getLength()) {
                    this.rc = revComp;
                    this.rc.rc = this;
                }
                return revComp;
            }
            catch (Exception e) {
                RuntimeException doesNotHappen = new RuntimeException(e.getMessage());
                doesNotHappen.setStackTrace(e.getStackTrace());
                throw doesNotHappen;
            }
        }
        throw new OperationNotSupportedException("The alphabet of sequence has to be reverse-complementable.");
    }

    public int hashCode() {
        return this.hashCode == null ? this.computeHashCode() : this.hashCode.intValue();
    }

    private int computeHashCode() {
        int len = this.getLength();
        int hashCode = 0;
        for (int i = 0; i < len; ++i) {
            hashCode = 31 * hashCode + this.hashCodeForPos(i);
        }
        if (this.annotation != null) {
            hashCode = 31 * hashCode + Arrays.hashCode(this.annotation);
        }
        this.hashCode = hashCode;
        return hashCode;
    }

    protected abstract int hashCodeForPos(int var1);

    public int getHammingDistance(Sequence seq) throws WrongAlphabetException {
        if (!this.alphabetCon.checkConsistency(seq.alphabetCon)) {
            throw new WrongAlphabetException();
        }
        if (this.getLength() != seq.getLength()) {
            return -1;
        }
        return this.getHammingDistance(0, seq, Integer.MAX_VALUE);
    }

    private int getHammingDistance(int startPos, Sequence shortSequence, int hMax) {
        int l = shortSequence.getLength();
        int h = 0;
        for (int p = 0; p < l && h < hMax; h += this.continuousVal(startPos + p) == shortSequence.continuousVal(p) ? 0 : 1, ++p) {
        }
        return h;
    }

    public boolean matches(int maxHammingDistance, Sequence shortSequence) throws WrongAlphabetException {
        if (!this.alphabetCon.checkConsistency(shortSequence.alphabetCon)) {
            throw new WrongAlphabetException();
        }
        int l = this.getLength() - shortSequence.getLength();
        if (l < 0) {
            return false;
        }
        for (int p = 0; p <= l; ++p) {
            int h = this.getHammingDistance(p, shortSequence, maxHammingDistance + 1);
            if (h > maxHammingDistance) continue;
            return true;
        }
        return false;
    }

    public abstract boolean isMultiDimensional();

    public abstract T getEmptyContainer();

    public abstract void fillContainer(T var1, int var2);

    protected static class SubSequence<T>
    extends RecursiveSequence<T> {
        private static final long serialVersionUID = 1L;
        private int start;
        private int length;

        private SubSequence(AlphabetContainer abc, SequenceAnnotation[] annotation, Sequence<T> seq, int start, int length, boolean check) {
            super(abc, annotation, seq instanceof SubSequence ? ((SubSequence)seq).content : seq);
            if (check && !abc.checkConsistency(seq.getAlphabetContainer().getSubContainer(start, length))) {
                throw new IllegalArgumentException("Wrong AlphabetContainer.");
            }
            int sl = seq.getLength();
            if (start < 0 || start > sl) {
                throw new IllegalArgumentException("Illegal start position: start=" + start + " not in [0," + sl + "]");
            }
            if (length < 0 || start + length > sl) {
                throw new IllegalArgumentException("Illegal length: length=" + length + " not in [0," + (sl - start) + "]");
            }
            this.start = seq instanceof SubSequence ? ((SubSequence)seq).start + start : start;
            this.length = length;
        }

        public SubSequence(AlphabetContainer abc, Sequence seq, int start, int length) {
            this(abc, null, seq, start, length, true);
        }

        public SubSequence(Sequence seq, int start, int length) {
            this(seq.getAlphabetContainer().getSubContainer(start, length), null, seq, start, length, false);
        }

        @Override
        public Sequence reverseComplement(int start, int end) throws OperationNotSupportedException {
            if (this.rc != null && start == 0 && end == this.getLength()) {
                return this.rc;
            }
            if (this.content.rc != null) {
                SubSequence<T> revComp = new SubSequence<T>(this.content.rc, this.content.rc.getLength() - this.start - end, end - start);
                if (start == 0 && end == this.getLength()) {
                    this.rc = revComp;
                    this.rc.rc = this;
                }
                return revComp;
            }
            return super.reverseComplement(start, end);
        }

        @Override
        protected final int getIndex(int pos) {
            if (pos < 0 || pos >= this.length) {
                throw new ArrayIndexOutOfBoundsException(pos);
            }
            return this.start + pos;
        }

        @Override
        public final int discreteVal(int pos) {
            if (pos < 0 || pos >= this.length) {
                throw new ArrayIndexOutOfBoundsException(pos);
            }
            return this.content.discreteVal(this.start + pos);
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        protected Sequence flatCloneWithoutAnnotation() {
            return new SubSequence<T>(this.alphabetCon, null, this.content, this.start, this.length, false);
        }
    }

    protected static class CompositeSequence<T>
    extends RecursiveSequence<T> {
        private static final long serialVersionUID = 1L;
        private int[] starts;
        private int[] lengths;

        private CompositeSequence(AlphabetContainer abc, SequenceAnnotation[] annotation, Sequence<T> seq, int[] starts, int[] lengths, boolean check) {
            super(abc, annotation, seq);
            if (check && !abc.checkConsistency(seq.getAlphabetContainer().getCompositeContainer(starts, lengths))) {
                throw new IllegalArgumentException("Wrong AlphabetContainer.");
            }
            if (starts.length != lengths.length) {
                throw new IllegalArgumentException("starts and lengths have to be from the same dimension");
            }
            this.starts = (int[])starts.clone();
            this.lengths = (int[])lengths.clone();
            for (int i = 0; i < lengths.length; ++i) {
                if (starts[i] < 0 || seq.getLength() <= starts[i]) {
                    throw new IllegalArgumentException(i + "-th start has to be from range [0," + (seq.getLength() - 1) + "]");
                }
                if (lengths[i] < 0 || seq.getLength() < starts[i] + lengths[i]) {
                    throw new IllegalArgumentException(i + "-th length has to be from range [0," + (seq.getLength() - starts[i]) + "]");
                }
                this.starts[i] = starts[i];
                this.lengths[i] = lengths[i];
            }
        }

        public CompositeSequence(Sequence seq, int[] starts, int[] lengths) {
            this(seq.getAlphabetContainer().getCompositeContainer(starts, lengths), null, seq, starts, lengths, false);
        }

        public CompositeSequence(AlphabetContainer abc, Sequence<T> seq, int[] starts, int[] lengths) {
            this(abc, null, seq, starts, lengths, true);
        }

        @Override
        protected int getIndex(int pos) {
            int sum = 0;
            int i = 0;
            while (i < this.lengths.length && sum + this.lengths[i] <= pos) {
                sum += this.lengths[i++];
            }
            return this.starts[i] + (pos - sum);
        }

        @Override
        public int getLength() {
            int sum = 0;
            for (int i = 0; i < this.lengths.length; ++i) {
                sum += this.lengths[i];
            }
            return sum;
        }

        @Override
        protected Sequence flatCloneWithoutAnnotation() {
            return new CompositeSequence<T>(this.alphabetCon, null, this.content, this.starts, this.lengths, false);
        }
    }

    public static abstract class RecursiveSequence<T>
    extends Sequence<T> {
        protected Sequence<T> content;

        public RecursiveSequence(AlphabetContainer alphabet, SequenceAnnotation[] annotation, Sequence<T> seq) {
            super(alphabet, annotation);
            this.content = seq;
        }

        public RecursiveSequence(AlphabetContainer alphabet, Sequence<T> seq) {
            this(alphabet, null, seq);
        }

        @Override
        public double continuousVal(int pos) {
            return this.content.continuousVal(this.getIndex(pos));
        }

        @Override
        public int discreteVal(int pos) {
            return this.content.discreteVal(this.getIndex(pos));
        }

        protected abstract int getIndex(int var1);

        @Override
        public boolean isMultiDimensional() {
            return this.content.isMultiDimensional();
        }

        @Override
        public T getEmptyContainer() {
            return this.content.getEmptyContainer();
        }

        @Override
        public void fillContainer(T container, int pos) {
            this.content.fillContainer(container, this.getIndex(pos));
        }

        @Override
        public int compareTo(T t1, T t2) {
            return this.content.compareTo(t1, t2);
        }

        @Override
        protected Object getEmptyRepresentation() {
            return this.content.getEmptyRepresentation();
        }

        @Override
        protected void addToRepresentation(Object representation, int pos, String delim) {
            this.content.addToRepresentation(representation, this.getIndex(pos), delim);
        }

        @Override
        protected String getStringRepresentation(Object representation) {
            return this.content.getStringRepresentation(representation);
        }

        @Override
        protected int hashCodeForPos(int pos) {
            return this.content.hashCodeForPos(this.getIndex(pos));
        }
    }
}

