/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.io;

import de.jstacs.DataType;
import de.jstacs.InstantiableFromParameterSet;
import de.jstacs.Singleton;
import de.jstacs.parameters.InstanceParameterSet;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.ParameterSet;
import java.lang.reflect.Constructor;

public class ParameterSetParser {
    public static int getIntFromParameter(Parameter par) throws WrongParameterTypeException {
        if (par.getDatatype() == DataType.INT) {
            return (Integer)par.getValue();
        }
        throw new WrongParameterTypeException("Parameter " + par.getName() + " is not of type int.");
    }

    public static float getFloatFromParameter(Parameter par) throws WrongParameterTypeException {
        if (par.getDatatype() == DataType.FLOAT) {
            return ((Float)par.getValue()).floatValue();
        }
        throw new WrongParameterTypeException("Parameter " + par.getName() + " is not of type float.");
    }

    public static double getDoubleFromParameter(Parameter par) throws WrongParameterTypeException {
        if (par.getDatatype() == DataType.DOUBLE) {
            return (Double)par.getValue();
        }
        throw new WrongParameterTypeException("Parameter " + par.getName() + " is not of type double.");
    }

    public static short getShortFromParameter(Parameter par) throws WrongParameterTypeException {
        if (par.getDatatype() == DataType.SHORT) {
            return (Short)par.getValue();
        }
        throw new WrongParameterTypeException("Parameter " + par.getName() + " is not of type short.");
    }

    public static long getLongFromParameter(Parameter par) throws WrongParameterTypeException {
        if (par.getDatatype() == DataType.LONG) {
            return (Long)par.getValue();
        }
        throw new WrongParameterTypeException("Parameter " + par.getName() + " is not of type long.");
    }

    public static byte getByteFromParameter(Parameter par) throws WrongParameterTypeException {
        if (par.getDatatype() == DataType.BYTE) {
            return (Byte)par.getValue();
        }
        throw new WrongParameterTypeException("Parameter " + par.getName() + " is not of type byte.");
    }

    public static boolean getBooleanFromParameter(Parameter par) throws WrongParameterTypeException {
        if (par.getDatatype() == DataType.BOOLEAN) {
            return (Boolean)par.getValue();
        }
        throw new WrongParameterTypeException("Parameter " + par.getName() + " is not of type boolean.");
    }

    public static String getStringFromParameter(Parameter par) throws WrongParameterTypeException {
        if (par.getDatatype() == DataType.STRING) {
            return (String)par.getValue();
        }
        throw new WrongParameterTypeException("Parameter " + par.getName() + " is not of type String.");
    }

    public static <T extends InstantiableFromParameterSet> T getInstanceFromParameterSet(InstanceParameterSet<T> pars) throws NotInstantiableException {
        return ParameterSetParser.getInstanceFromParameterSet(pars, pars.getInstanceClass());
    }

    public static <T extends InstantiableFromParameterSet> T getInstanceFromParameterSet(ParameterSet pars, Class<T> instanceClass) throws NotInstantiableException {
        InstantiableFromParameterSet res;
        if (instanceClass == null) {
            throw new NotInstantiableException("An instance class must be specified.");
        }
        Class<?> parClass = pars.getClass();
        Constructor<T> construct = null;
        while (construct == null && parClass != Object.class) {
            try {
                construct = instanceClass.getConstructor(parClass);
            }
            catch (Exception e) {
                construct = null;
                parClass = parClass.getSuperclass();
            }
        }
        if (construct == null) {
            if (Singleton.class.isAssignableFrom(instanceClass)) {
                try {
                    res = (InstantiableFromParameterSet)((Object)Singleton.SingletonHandler.getSingelton(instanceClass));
                }
                catch (Exception e) {
                    throw new NotInstantiableException("You must provide a static field SINGELTON.");
                }
            }
            throw new NotInstantiableException("No appropriate constructor found for " + instanceClass);
        }
        try {
            res = (InstantiableFromParameterSet)construct.newInstance(pars);
        }
        catch (Exception e) {
            throw new NotInstantiableException(e.getCause().getMessage());
        }
        return (T)res;
    }

    public static class WrongParameterTypeException
    extends ParameterException {
        private static final long serialVersionUID = 1L;

        public WrongParameterTypeException(String msg) {
            super(msg);
        }
    }

    public static class NotInstantiableException
    extends ParameterException {
        private static final long serialVersionUID = 1L;

        public NotInstantiableException(String msg) {
            super(msg);
        }
    }
}

