/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous;

import de.jstacs.NotTrainedException;
import de.jstacs.data.DataSet;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.trainable.TrainableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.DGTrainSMParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.DAGTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.parameters.FSDAGTrainSMParameterSet;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class FSDAGTrainSM
extends DAGTrainSM {
    private static final String XML_TAG = "FSDAGTrainSM";

    public FSDAGTrainSM(FSDAGTrainSMParameterSet params) throws CloneNotSupportedException, IllegalArgumentException, NonParsableException {
        super(params);
    }

    public FSDAGTrainSM(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public String getInstanceName() {
        return "fixed structure directed acyclic graphical model";
    }

    @Override
    public byte getMaximalMarkovOrder() {
        int max = this.constraints[0].getMarginalOrder();
        for (int i = 1; i < this.length; ++i) {
            if (max >= this.constraints[i].getMarginalOrder()) continue;
            max = this.constraints[i].getMarginalOrder();
        }
        return (byte)(max - 1);
    }

    @Override
    protected String getXMLTag() {
        return XML_TAG;
    }

    @Override
    public void train(DataSet data, double[] weights) throws Exception {
        this.estimateParameters(data, weights);
    }

    public void train(DataSet data, double[] weights, int[][] graph) throws Exception {
        if (!FSDAGTrainSM.checkAcyclic(this.length, graph)) {
            throw new IllegalArgumentException("the graph is not acyclic");
        }
        this.trainUnchecked(data, weights, graph);
    }

    public void drawParameters(DataSet data, double[] weights, int[][] graph) throws Exception {
        if (graph != null) {
            if (!FSDAGTrainSM.checkAcyclic(this.length, graph)) {
                throw new IllegalArgumentException("the graph is not acyclic");
            }
            this.params.getParameterAt(2).setValue(FSDAGTrainSMParameterSet.encode(graph));
            this.createConstraints(graph);
        }
        this.drawParameters(data, weights);
    }

    private void trainUnchecked(DataSet data, double[] weights, int[][] graph) throws Exception {
        this.params.getParameterAt(2).setValue(FSDAGTrainSMParameterSet.encode(graph));
        this.createConstraints(graph);
        this.estimateParameters(data, weights);
    }

    public static void train(TrainableStatisticalModel[] models, int[][] graph, double[][] weights, DataSet ... data) throws Exception {
        if (!FSDAGTrainSM.checkAcyclic(graph.length, graph)) {
            throw new IllegalArgumentException("the graph is not acyclic");
        }
        if (data.length == 1) {
            for (int i = 0; i < models.length; ++i) {
                ((FSDAGTrainSM)models[i]).trainUnchecked(data[0], weights[i], graph);
            }
        } else {
            for (int i = 0; i < models.length; ++i) {
                ((FSDAGTrainSM)models[i]).trainUnchecked(data[i], weights[i], graph);
            }
        }
    }

    @Override
    protected void set(DGTrainSMParameterSet params, boolean trained) throws CloneNotSupportedException, NonParsableException {
        super.set(params, trained);
        int i = 0;
        StringBuffer xml = new StringBuffer((String)params.getParameterAt(2).getValue());
        int[][] graph = new int[this.length][];
        TreeMap<String, String> filter = new TreeMap<String, String>();
        for (i = 0; i < this.length; i = (int)((byte)(i + 1))) {
            filter.clear();
            filter.put("node", "" + i);
            StringBuffer help = XMLParser.extractForTag(xml, "parents", null, filter);
            if (help == null) {
                graph[i] = new int[]{i};
                continue;
            }
            StringTokenizer t = new StringTokenizer(help.toString(), ",");
            graph[i] = new int[t.countTokens() + 1];
            int j = 0;
            while (t.hasMoreTokens()) {
                graph[i][j] = Integer.parseInt(t.nextToken().trim());
                if (graph[i][j] < 0 || graph[i][j] >= this.length || graph[i][j] == i) {
                    throw new IllegalArgumentException("The graph was not correct encoded. See parents from node " + i);
                }
                j = (byte)(j + 1);
            }
            graph[i][j] = i;
            if (XMLParser.extractForTag(xml, "parents", null, filter) == null) continue;
            throw new IllegalArgumentException("The graph was not correct encoded. There are at least 2 sets of parents for node " + i);
        }
        if (!FSDAGTrainSM.checkAcyclic(this.length, graph)) {
            throw new IllegalArgumentException("the graph is not acyclic");
        }
        this.createConstraints(graph);
    }

    @Override
    public String getStructure() {
        if (this.trained) {
            try {
                return super.getStructure();
            }
            catch (NotTrainedException e) {
                RuntimeException r = new RuntimeException(e.getMessage());
                throw r;
            }
        }
        StringBuffer all = new StringBuffer(500);
        for (int counter1 = 0; counter1 < this.constraints.length; ++counter1) {
            all.append(this.constraints[counter1].toString() + "\n");
        }
        return all.toString();
    }
}

