/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous;

import java.util.Arrays;

public class SequenceIterator
implements Cloneable {
    int[] seq;
    private int[] maxSymbol;
    private int l;

    public SequenceIterator(int length) {
        this.seq = new int[length + 1];
        this.maxSymbol = null;
        this.l = -1;
    }

    public SequenceIterator clone() throws CloneNotSupportedException {
        SequenceIterator clone = (SequenceIterator)super.clone();
        clone.seq = (int[])this.seq.clone();
        clone.maxSymbol = (int[])this.maxSymbol.clone();
        return clone;
    }

    public boolean next() {
        int s_index = 0;
        while (this.seq[s_index] == this.maxSymbol[s_index]) {
            this.seq[s_index++] = 0;
        }
        int n = s_index;
        this.seq[n] = this.seq[n] + 1;
        return this.seq[this.l] == 0;
    }

    public void reset() {
        Arrays.fill(this.seq, 0);
    }

    public void setBounds(int[] bounds) {
        this.maxSymbol = new int[bounds.length + 1];
        for (int counter = 0; counter < bounds.length; ++counter) {
            this.maxSymbol[counter] = bounds[counter] - 1;
        }
        this.l = bounds.length;
        this.maxSymbol[this.l] = 1;
        this.reset();
    }

    public boolean skip(int firstPos) {
        int counter1 = 0;
        while (counter1 < firstPos) {
            this.seq[counter1++] = 0;
        }
        while (this.seq[counter1] == this.maxSymbol[counter1]) {
            this.seq[counter1++] = 0;
        }
        int n = counter1;
        this.seq[n] = this.seq[n] + 1;
        return this.seq[this.l] == 0;
    }

    public int discreteValAt(int pos) {
        if (pos < this.l) {
            return this.seq[pos];
        }
        throw new IndexOutOfBoundsException();
    }

    public int getNumberOfSequences() {
        int res = this.maxSymbol[0] + 1;
        for (int i = 1; i < this.maxSymbol.length - 1; ++i) {
            res *= this.maxSymbol[i] + 1;
        }
        return res;
    }
}

