/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs;

import de.jstacs.DataType;
import de.jstacs.Storable;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;

public abstract class AnnotatedEntity
implements Storable {
    protected String name;
    protected String comment;
    protected DataType datatype;

    protected AnnotatedEntity(String name, String comment, DataType datatype) {
        this.name = name;
        this.comment = comment;
        this.datatype = datatype;
    }

    protected AnnotatedEntity(StringBuffer rep) throws NonParsableException {
        rep = XMLParser.extractForTag(rep, this.getXMLTag());
        this.name = XMLParser.extractObjectForTags(rep, "name", String.class);
        this.comment = XMLParser.extractObjectForTags(rep, "comment", String.class);
        this.datatype = XMLParser.extractObjectForTags(rep, "datatype", DataType.class);
        this.extractFurtherInfos(rep);
    }

    public abstract String getXMLTag();

    @Override
    public final StringBuffer toXML() {
        StringBuffer buf = new StringBuffer();
        XMLParser.appendObjectWithTags(buf, this.name, "name");
        XMLParser.appendObjectWithTags(buf, this.comment, "comment");
        XMLParser.appendObjectWithTags(buf, (Object)this.datatype, "datatype");
        this.appendFurtherInfos(buf);
        XMLParser.addTags(buf, this.getXMLTag());
        return buf;
    }

    protected abstract void appendFurtherInfos(StringBuffer var1);

    protected abstract void extractFurtherInfos(StringBuffer var1) throws NonParsableException;

    public final DataType getDatatype() {
        return this.datatype;
    }

    public abstract Object getValue();

    public final String getName() {
        return this.name;
    }

    public final String getComment() {
        return this.comment;
    }
}

