/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data;

import de.jstacs.data.DataSet;
import de.jstacs.data.RecyclableSequenceEnumerator;
import de.jstacs.data.sequences.Sequence;
import java.util.HashSet;
import java.util.Iterator;
import javax.naming.OperationNotSupportedException;

public class DataSetKMerEnumerator
implements RecyclableSequenceEnumerator {
    private Iterator<Sequence> it;
    private HashSet<Sequence> current;

    public DataSetKMerEnumerator(DataSet data, int k, boolean eliminateRevComp) throws OperationNotSupportedException {
        int f = eliminateRevComp ? 2 : 1;
        this.current = new HashSet(f * data.getMaximalElementLength());
        for (int j = 0; j < data.getNumberOfElements(); ++j) {
            Sequence seq = data.getElementAt(j);
            for (int l = 0; l <= seq.getLength() - k; ++l) {
                Sequence temp = seq.getSubSequence(l, k);
                if (this.current.contains(temp) || eliminateRevComp && this.current.contains(temp.reverseComplement())) continue;
                this.current.add(temp);
            }
        }
        this.reset();
    }

    @Override
    public void reset() {
        this.it = this.current.iterator();
    }

    @Override
    public boolean hasMoreElements() {
        return this.it.hasNext();
    }

    @Override
    public Sequence nextElement() {
        return this.it.next();
    }
}

