/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.homol;

import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.seq.homol.Homology;
import org.biojava.bio.seq.homol.HomologyFeature;
import org.biojava.bio.symbol.Alignment;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;

public class SimpleHomology
extends AbstractChangeable
implements Homology {
    private SimpleFeatureHolder features;
    private Alignment alignment;

    public FeatureHolder getFeatures() {
        return this.features;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAlignment(Alignment alignment) throws BioException, ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs = this.getChangeSupport(Homology.ALIGNMENT);
            ChangeEvent ce = new ChangeEvent(this, Homology.ALIGNMENT, alignment, this.alignment);
            ChangeSupport changeSupport = cs;
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.alignment = alignment;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.alignment = alignment;
        }
        this.features = new SimpleFeatureHolder();
        for (Object o : alignment.getLabels()) {
            if (!HomologyFeature.class.isInstance(o)) {
                throw new BioException("The labels of the Alignment used to construct a SimpleHomology should be the relevant HomologyFeatures");
            }
            this.features.addFeature((Feature)o);
        }
    }

    public String toString() {
        return "SimpleHomology [" + this.alignment.getLabels().size() + " features]";
    }
}

