/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import org.biojava.utils.bytecode.CodeClass;
import org.biojava.utils.bytecode.CodeUtils;
import org.biojava.utils.bytecode.IntrospectedCodeClass;

public class ParametricType {
    private static CodeClass[] OBJECT_CC = new CodeClass[]{IntrospectedCodeClass.forClass(Object.class)};
    private final String name;
    private final boolean isPrimitive;
    private final boolean isObject;
    private final boolean isArray;
    private final CodeClass[] classes;

    public static ParametricType createType(String name) {
        return new ParametricType(name, false, false, false);
    }

    public static ParametricType createPrimitiveType(String name) {
        return new ParametricType(name, true, false, false);
    }

    public static ParametricType createObjectType(String name) {
        return new ParametricType(name, false, true, false);
    }

    public static ParametricType createArrayType(String name) {
        return new ParametricType(name, false, true, true);
    }

    public static ParametricType createType(String name, CodeClass[] classes) {
        return new ParametricType(name, classes);
    }

    private ParametricType(String name, boolean isPrimitive, boolean isObject, boolean isArray) {
        this.name = name;
        this.isPrimitive = isPrimitive;
        this.isObject = isObject;
        this.isArray = isArray;
        this.classes = isObject ? OBJECT_CC : CodeUtils.EMPTY_LIST;
    }

    private ParametricType(String name, CodeClass[] classes) {
        this.name = name;
        this.classes = classes;
        this.isObject = true;
        this.isPrimitive = false;
        this.isArray = false;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public boolean isObject() {
        return this.isObject;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean canAccept(CodeClass cc) {
        if (cc.isArray() && this.isArray()) {
            return true;
        }
        if (!cc.isPrimitive() && this.isObject()) {
            return true;
        }
        return cc.isPrimitive() && this.isPrimitive();
    }

    public CodeClass[] getClasses() {
        return this.classes;
    }

    public String toString() {
        return "GenericType:" + this.name;
    }
}

