/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.graphs;

import java.util.Arrays;

public class UnionFind {
    private int[] a;

    public UnionFind(int size) {
        this.a = new int[size];
        Arrays.fill(this.a, -1);
    }

    public int[][] getComponents() {
        int i;
        int count1 = 0;
        for (i = 0; i < this.a.length; ++i) {
            if (this.a[i] < 0) {
                ++count1;
                continue;
            }
            this.find(i);
        }
        int[][] erg = new int[count1][];
        count1 = 0;
        for (i = 0; i < this.a.length && count1 < erg.length; ++i) {
            int j;
            if (this.a[i] >= 0) continue;
            int[] help = new int[this.a.length];
            help[0] = i;
            int count2 = 1;
            for (j = 0; j < this.a.length; ++j) {
                if (i != this.a[j]) continue;
                help[count2++] = j;
            }
            erg[count1] = new int[count2];
            for (j = 0; j < count2; ++j) {
                erg[count1][j] = help[j];
            }
            Arrays.sort(erg[count1]);
            ++count1;
        }
        return erg;
    }

    public int find(int n) {
        int l = n;
        while (this.a[l] >= 0) {
            l = this.a[l];
        }
        while (this.a[n] > 0) {
            int m = this.a[n];
            this.a[n] = l;
            n = m;
        }
        return l;
    }

    public boolean union(int k1, int k2) {
        if ((k1 = this.find(k1)) != (k2 = this.find(k2))) {
            if (this.a[k1] < this.a[k2]) {
                int i = k1;
                k1 = k2;
                k2 = i;
            }
            int n = k2;
            this.a[n] = this.a[n] + this.a[k1];
            this.a[k1] = k2;
            return true;
        }
        return false;
    }
}

