/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.results;

import de.jstacs.AnnotatedEntityList;
import de.jstacs.DataType;
import de.jstacs.Storable;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.results.SimpleResult;
import de.jstacs.utils.DoubleList;

public class MeanResultSet
extends NumericalResultSet {
    private int count;
    private double[] squares;
    private SimpleResult[] infos;
    private boolean aggregateAll;
    private DoubleList[] allValues;

    private MeanResultSet(NumericalResult[] res, SimpleResult[] infos, double[] squares, int count, boolean aggregateAll, DoubleList[] allValues) {
        super(new NumericalResult[][]{res});
        this.count = count;
        this.infos = new SimpleResult[infos.length];
        this.squares = squares;
        this.aggregateAll = aggregateAll;
        this.allValues = allValues;
        System.arraycopy(infos, 0, this.infos, 0, infos.length);
    }

    public MeanResultSet(boolean aggregateAll, SimpleResult ... infos) {
        super(new NumericalResult[0][]);
        this.count = 0;
        this.infos = new SimpleResult[infos.length + 1];
        System.arraycopy(infos, 0, this.infos, 0, infos.length);
        this.aggregateAll = aggregateAll;
    }

    public MeanResultSet(SimpleResult ... infos) {
        this(false, infos);
    }

    public MeanResultSet() {
        this(new SimpleResult[0]);
    }

    public MeanResultSet(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = super.toXML();
        XMLParser.addTags(buf, "superSet");
        this.setCount();
        XMLParser.appendObjectWithTags(buf, this.infos, "infos");
        XMLParser.appendObjectWithTags(buf, this.aggregateAll, "aggregateAll");
        if (this.count > 0) {
            XMLParser.appendObjectWithTags(buf, this.squares, "squares");
            XMLParser.appendObjectWithTags(buf, this.allValues, "allValues");
        }
        XMLParser.addTags(buf, "meanResultSet");
        return buf;
    }

    @Override
    protected void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "meanResultSet");
        super.fromXML(XMLParser.extractForTag(representation, "superSet"));
        Storable[] infosTemp = XMLParser.extractObjectForTags(representation, "infos", Storable[].class);
        this.infos = new SimpleResult[infosTemp.length];
        for (int i = 0; i < this.infos.length; ++i) {
            this.infos[i] = (SimpleResult)infosTemp[i];
        }
        this.aggregateAll = (Boolean)XMLParser.extractObjectForTags(representation, "aggregateAll");
        this.count = (Integer)this.infos[this.infos.length - 1].getValue();
        if (this.count > 0) {
            this.squares = XMLParser.extractObjectForTags(representation, "squares", double[].class);
            this.allValues = (DoubleList[])XMLParser.extractObjectForTags(representation, "allValues");
        }
    }

    public static MeanResultSet addResults(MeanResultSet r1, MeanResultSet r2) throws AdditionImpossibleException {
        int i;
        if (r1.getNumberOfResults() != r2.getNumberOfResults()) {
            throw new AdditionImpossibleException();
        }
        for (i = 0; i < r1.infos.length - 1 && r1.infos[i].equals(r2.infos[i]); ++i) {
        }
        if (i != r1.infos.length - 1) {
            throw new AdditionImpossibleException();
        }
        boolean aggregateAll = r1.aggregateAll && r2.aggregateAll;
        NumericalResult[] results = new NumericalResult[r1.getNumberOfResults()];
        double[] squares = new double[r1.getNumberOfResults()];
        DoubleList[] allValues = null;
        if (aggregateAll) {
            allValues = new DoubleList[squares.length];
            for (i = 0; i < allValues.length; ++i) {
                allValues[i] = new DoubleList();
            }
        }
        for (i = 0; i < results.length; ++i) {
            NumericalResult curr2;
            NumericalResult curr1 = r1.getResultAt(i);
            if (!curr1.isComparableResult(curr2 = r2.getResultAt(i))) {
                throw new AdditionImpossibleException();
            }
            squares[i] = r1.squares[i] + r2.squares[i];
            results[i] = new NumericalResult(curr1.getName(), curr1.getComment(), (Double)curr1.getValue() + (Double)curr2.getValue());
            if (!aggregateAll) continue;
            allValues[i].addAll(r1.allValues[i]);
            allValues[i].addAll(r2.allValues[i]);
        }
        MeanResultSet mrs = new MeanResultSet(results, r1.infos, squares, r1.count + r2.count, aggregateAll, allValues);
        return mrs;
    }

    public synchronized void addResults(NumericalResultSet ... rs) throws InconsistentResultNumberException, SimpleParameter.IllegalValueException, AdditionImpossibleException {
        boolean first;
        int i;
        int anz = 0;
        int idx = 0;
        for (i = 0; i < rs.length; ++i) {
            if (rs[i] == null) continue;
            anz += rs[i].getNumberOfResults();
        }
        boolean bl = first = this.count == 0;
        if (first) {
            this.results = new AnnotatedEntityList(anz);
            this.squares = new double[anz];
            if (this.aggregateAll) {
                this.allValues = new DoubleList[this.squares.length];
                for (i = 0; i < this.allValues.length; ++i) {
                    this.allValues[i] = new DoubleList();
                }
            }
        } else if (anz != this.getNumberOfResults()) {
            throw new InconsistentResultNumberException();
        }
        for (int r = 0; r < rs.length; ++r) {
            if (rs[r] == null) continue;
            int end = rs[r].getNumberOfResults();
            i = 0;
            while (i < end) {
                NumericalResult curr = rs[r].getResultAt(i);
                double currVal = 0.0;
                currVal = curr.getDatatype() == DataType.DOUBLE ? (Double)curr.getValue() : (double)((Integer)curr.getValue()).intValue();
                if (this.allValues != null) {
                    this.allValues[idx].add(currVal);
                }
                int n = idx;
                this.squares[n] = this.squares[n] + currVal * currVal;
                if (first) {
                    this.results.add(new Result[]{new NumericalResult(curr.getName(), curr.getComment(), currVal)});
                } else {
                    if (!((Result)this.results.get(idx)).isCastableResult(curr)) {
                        throw new AdditionImpossibleException();
                    }
                    ((NumericalResult)this.results.get(idx)).setResult(Double.valueOf(currVal + ((Number)((Result)this.results.get(idx)).getValue()).doubleValue()));
                }
                ++i;
                ++idx;
            }
        }
        ++this.count;
    }

    public NumericalResultSet getStatistics() {
        int factor = this.count > 1 ? 2 : 1;
        NumericalResult[] resultsTemp = new NumericalResult[this.results.size() * factor];
        double n = this.count;
        for (int i = 0; i < this.results.size(); ++i) {
            resultsTemp[i * factor] = new NumericalResult(((Result)this.results.get(i)).getName(), ((Result)this.results.get(i)).getComment(), (Double)((Result)this.results.get(i)).getValue() / n);
            if (this.count <= 1) continue;
            resultsTemp[i * factor + 1] = new NumericalResult("Standard error of " + ((Result)this.results.get(i)).getName(), "Standard error of the values of " + ((Result)this.results.get(i)).getName(), Math.sqrt((this.squares[i] / n - (Double)resultsTemp[i * factor].getValue() * (Double)resultsTemp[i * factor].getValue()) / (n - 1.0)));
        }
        return new NumericalResultSet(new NumericalResult[][]{resultsTemp});
    }

    public double[] getAllValues(int index) {
        if (this.allValues == null) {
            return null;
        }
        return this.allValues[index].toArray();
    }

    private void setCount() {
        this.infos[this.infos.length - 1] = new NumericalResult("evaluations", "the number of different results, each coming from one iteration of a crossvalidation", this.count);
    }

    public ResultSet getInfos() {
        this.setCount();
        return new ResultSet(new Result[][]{this.infos});
    }

    public static class AdditionImpossibleException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public AdditionImpossibleException() {
            super("The addition is impossible, since the objects do not match.");
        }
    }

    public static class InconsistentResultNumberException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public InconsistentResultNumberException() {
            super("Number of results differs.");
        }
    }
}

