/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.results.savers;

import de.jstacs.results.Result;
import de.jstacs.results.savers.DataSetResultSaver;
import de.jstacs.results.savers.ListResultSaver;
import de.jstacs.results.savers.PlotGeneratorResultSaver;
import de.jstacs.results.savers.ResultSaver;
import de.jstacs.results.savers.ResultSetResultSaver;
import de.jstacs.results.savers.StorableResultSaver;
import de.jstacs.results.savers.TextResultSaver;
import java.util.HashMap;
import java.util.Set;

public class ResultSaverLibrary {
    private static HashMap<Class<? extends Result>, ResultSaver> map;

    public static <T extends Result> void register(Class<? extends T> clazz, ResultSaver<T> saver) {
        if (map == null) {
            map = new HashMap();
        }
        map.put(clazz, saver);
    }

    public static <T extends Result> ResultSaver<T> getSaver(Class<? extends T> resultClass) {
        ResultSaver ren = map.get(resultClass);
        if (ren == null) {
            Set<Class<? extends Result>> clazzes = map.keySet();
            for (Class<? extends Result> clazz : clazzes) {
                if (!clazz.isAssignableFrom(resultClass)) continue;
                return map.get(clazz);
            }
        }
        if (ren == null) {
            System.err.println("Did not find a saver for " + resultClass + ". Custom savers need to be registered by " + ResultSaverLibrary.class.getName() + ".register().");
        }
        return ren;
    }

    static {
        TextResultSaver.register();
        ResultSetResultSaver.register();
        ListResultSaver.register();
        DataSetResultSaver.register();
        PlotGeneratorResultSaver.register();
        StorableResultSaver.register();
    }
}

