/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.latticeReduction;

public class LLL {
    private static final double EPS = 1.0E-13;
    static int dim = 0;
    static double[][] A;
    static double[][] mu;
    static double[] a;

    private static void setDimension(int n) {
        if (n != dim) {
            dim = n;
            A = new double[dim][dim];
            mu = new double[dim][dim];
            a = new double[dim];
        }
    }

    private static void initLLL(double[][] dArray, int[][] nArray, double[][] dArray2, double[][] dArray3, double[] dArray4) {
        int n;
        int n2;
        int n3 = dArray.length;
        if (nArray != null) {
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n3; ++n) {
                    nArray[n2][n] = n2 == n ? 1 : 0;
                }
            }
        }
        if (dArray2 != null) {
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n3; ++n) {
                    dArray2[n2][n] = n2 == n ? 1.0 : 0.0;
                }
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                LLL.A[n2][n] = dArray[n2][n];
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n2; ++n) {
                double d = LLL.dot(dArray[n2], A[n]) / dArray4[n];
                dArray3[n2][n] = d;
                double d2 = d;
                for (int i = 0; i < n3; ++i) {
                    double[] dArray5 = A[n2];
                    int n4 = i;
                    dArray5[n4] = dArray5[n4] - d2 * A[n][i];
                }
            }
            dArray4[n2] = LLL.dot(A[n2], A[n2]);
        }
    }

    public static void reduce(double[][] dArray) {
        LLL.reduce(dArray, null, null, 0.75);
    }

    public static void reduce(double[][] dArray, int[][] nArray) {
        LLL.reduce(dArray, nArray, null, 0.75);
    }

    public static void reduce(double[][] dArray, double[][] dArray2) {
        LLL.reduce(dArray, null, dArray2, 0.75);
    }

    public static void reduce(double[][] dArray, int[][] nArray, double[][] dArray2, double d) {
        if (d < 0.25 || d > 1.0) {
            throw new IllegalArgumentException("constant is not in [1/4,1]");
        }
        int n = dArray.length;
        LLL.setDimension(n);
        LLL.initLLL(dArray, nArray, dArray2, mu, a);
        if (n < 2) {
            return;
        }
        int n2 = 1;
        while (true) {
            LLL.transform(dArray, nArray, dArray2, mu, n2, n2 - 1);
            if (a[n2] + 1.0E-13 < (d - mu[n2][n2 - 1] * mu[n2][n2 - 1]) * a[n2 - 1]) {
                LLL.swap(dArray, nArray, dArray2, mu, a, n2);
                if (n2 <= 1) continue;
                --n2;
                continue;
            }
            for (int i = n2 - 2; i >= 0; --i) {
                LLL.transform(dArray, nArray, dArray2, mu, n2, i);
            }
            if (++n2 == n) break;
        }
    }

    private static void swap(double[][] dArray, int[][] nArray, double[][] dArray2, double[][] dArray3, double[] dArray4, int n) {
        int n2;
        int n3 = dArray.length;
        double d = dArray3[n][n - 1];
        double d2 = dArray4[n] + d * d * dArray4[n - 1];
        double[] dArray5 = dArray3[n];
        int n4 = n - 1;
        dArray5[n4] = dArray5[n4] * (dArray4[n - 1] / d2);
        int n5 = n;
        dArray4[n5] = dArray4[n5] * (dArray4[n - 1] / d2);
        dArray4[n - 1] = d2;
        LLL.swap(dArray, n, n - 1);
        if (nArray != null) {
            LLL.swap(nArray, n, n - 1);
        }
        if (dArray2 != null) {
            LLL.swap(dArray2, n, n - 1);
        }
        for (n2 = 0; n2 < n - 1; ++n2) {
            d2 = dArray3[n - 1][n2];
            dArray3[n - 1][n2] = dArray3[n][n2];
            dArray3[n][n2] = d2;
        }
        for (n2 = n + 1; n2 < n3; ++n2) {
            double d3;
            double d4 = dArray3[n2][n - 1] - d * dArray3[n2][n];
            dArray3[n2][n - 1] = d3 = dArray3[n2][n] + d4 * dArray3[n][n - 1];
            dArray3[n2][n] = d4;
        }
    }

    private static void transform(double[][] dArray, int[][] nArray, double[][] dArray2, double[][] dArray3, int n, int n2) {
        if (Math.abs(dArray3[n][n2]) > 0.5) {
            int n3;
            int n4 = (int)Math.floor(dArray3[n][n2] + 0.5);
            int n5 = dArray.length;
            for (n3 = 0; n3 < n5; ++n3) {
                double[] dArray4 = dArray[n];
                int n6 = n3;
                dArray4[n6] = dArray4[n6] - (double)n4 * dArray[n2][n3];
                if (nArray != null) {
                    int[] nArray2 = nArray[n];
                    int n7 = n3;
                    nArray2[n7] = nArray2[n7] - n4 * nArray[n2][n3];
                }
                if (dArray2 == null) continue;
                double[] dArray5 = dArray2[n];
                int n8 = n3;
                dArray5[n8] = dArray5[n8] - (double)n4 * dArray2[n2][n3];
            }
            for (n3 = 0; n3 < n2; ++n3) {
                double[] dArray6 = dArray3[n];
                int n9 = n3;
                dArray6[n9] = dArray6[n9] - (double)n4 * dArray3[n2][n3];
            }
            double[] dArray7 = dArray3[n];
            int n10 = n2;
            dArray7[n10] = dArray7[n10] - (double)n4;
        }
    }

    private static double dot(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray2[i];
        }
        return d;
    }

    private static void swap(double[][] dArray, int n, int n2) {
        double[] dArray2 = dArray[n];
        dArray[n] = dArray[n2];
        dArray[n2] = dArray2;
    }

    private static void swap(int[][] nArray, int n, int n2) {
        int[] nArray2 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = nArray2;
    }

    private static void print(double[] dArray, String string) {
        System.out.print(string);
        for (int i = 0; i < dArray.length; ++i) {
            System.out.print("  " + dArray[i]);
        }
        System.out.println("  ");
    }
}

