/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.structure.AminoAcid;
import org.biojava.bio.structure.AminoAcidImpl;
import org.biojava.bio.structure.AtomImpl;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.ChainImpl;
import org.biojava.bio.structure.Compound;
import org.biojava.bio.structure.DBRef;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.GroupIterator;
import org.biojava.bio.structure.HetatomImpl;
import org.biojava.bio.structure.NucleotideImpl;
import org.biojava.bio.structure.PDBHeader;
import org.biojava.bio.structure.SSBond;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.StructureImpl;
import org.biojava.bio.structure.io.CAConverter;
import org.biojava.bio.structure.io.PDBParseException;
import org.biojava.bio.structure.io.SeqRes2AtomAligner;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDBFileParser {
    private final boolean DEBUG = false;
    private Structure structure = null;
    private List<Chain> current_model;
    private Chain current_chain = null;
    private Group current_group = null;
    private List<Chain> seqResChains;
    private static SymbolTokenization threeLetter;
    private static SymbolTokenization oneLetter;
    private static final String NEWLINE;
    private Map<String, Object> header;
    private PDBHeader pdbHeader;
    private List<Map<String, Integer>> connects;
    private List<Map<String, String>> helixList;
    private List<Map<String, String>> strandList;
    private List<Map<String, String>> turnList;
    private int lengthCheck;
    private Compound current_compound;
    private List<Compound> compounds = new ArrayList<Compound>();
    private List<DBRef> dbrefs;
    private int molTypeCounter = 1;
    private String continuationField;
    private String continuationString = "";
    private DateFormat dateFormat;
    private static final List<String> compndFieldValues;
    private static final List<String> ignoreCompndFieldValues;
    boolean parseSecStruc = false;
    boolean alignSeqRes = true;
    private String previousContinuationField = "";
    public static final String PDB_AUTHOR_ASSIGNMENT = "PDB_AUTHOR_ASSIGNMENT";
    public static final String HELIX = "HELIX";
    public static final String STRAND = "STRAND";
    public static final String TURN = "TURN";
    private static Map<String, Integer> nucleotides30;
    private static Map<String, Integer> nucleotides23;
    int atomCount = 0;
    public static final int ATOM_CA_THRESHOLD = 500000;
    public static final int MAX_ATOMS = 700000;
    private boolean atomOverflow = false;
    public boolean parseCAOnly = false;

    public PDBFileParser() {
        this.current_model = new ArrayList<Chain>();
        this.header = this.init_header();
        this.pdbHeader = new PDBHeader();
        this.connects = new ArrayList<Map<String, Integer>>();
        this.helixList = new ArrayList<Map<String, String>>();
        this.strandList = new ArrayList<Map<String, String>>();
        this.turnList = new ArrayList<Map<String, String>>();
        this.current_compound = new Compound();
        this.dbrefs = new ArrayList<DBRef>();
        this.dateFormat = new SimpleDateFormat("dd-MMM-yy");
    }

    public boolean isParseCAOnly() {
        return this.parseCAOnly;
    }

    public void setParseCAOnly(boolean parseCAOnly) {
        this.parseCAOnly = parseCAOnly;
    }

    public boolean isAlignSeqRes() {
        return this.alignSeqRes;
    }

    public void setAlignSeqRes(boolean alignSeqRes) {
        this.alignSeqRes = alignSeqRes;
    }

    public boolean isParseSecStruc() {
        return this.parseSecStruc;
    }

    public void setParseSecStruc(boolean parseSecStruc) {
        this.parseSecStruc = parseSecStruc;
    }

    private Map<String, Object> init_header() {
        HashMap<String, Object> header = new HashMap<String, Object>();
        header.put("idCode", "");
        header.put("classification", "");
        header.put("depDate", "0000-00-00");
        header.put("title", "");
        header.put("technique", "");
        header.put("resolution", null);
        header.put("modDate", "0000-00-00");
        return header;
    }

    protected String getTimeStamp() {
        Calendar cal = Calendar.getInstance();
        int hour24 = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        String s = "time: " + hour24 + " " + min + " " + sec;
        return s;
    }

    public Character convert_3code_1code(String code3) throws IllegalSymbolException {
        Symbol sym = threeLetter.parseToken(code3);
        String code1 = oneLetter.tokenizeSymbol(sym);
        return new Character(code1.charAt(0));
    }

    private Character get1LetterCode(String groupCode3) {
        Character aminoCode1 = null;
        try {
            aminoCode1 = this.convert_3code_1code(groupCode3);
        }
        catch (IllegalSymbolException e) {
            if (this.isNucleotide(groupCode3)) {
                aminoCode1 = null;
            }
            System.out.println("unknown amino acid " + groupCode3);
            aminoCode1 = new Character('x');
        }
        return aminoCode1;
    }

    private Group getNewGroup(String recordName, Character aminoCode1) {
        HetatomImpl group;
        if (recordName.equals("ATOM")) {
            if (aminoCode1 != null) {
                AminoAcidImpl aa = new AminoAcidImpl();
                aa.setAminoType(aminoCode1);
                group = aa;
            } else {
                NucleotideImpl nu = new NucleotideImpl();
                group = nu;
            }
        } else {
            group = new HetatomImpl();
        }
        return group;
    }

    private boolean isNucleotide(String groupCode3) {
        String code = groupCode3.trim();
        if (nucleotides30.containsKey(code)) {
            return true;
        }
        return nucleotides23.containsKey(code);
    }

    private void pdb_HEADER_Handler(String line) {
        String classification = line.substring(10, 50).trim();
        String deposition_date = line.substring(50, 59).trim();
        String pdbCode = line.substring(62, 66).trim();
        this.header.put("idCode", pdbCode);
        this.structure.setPDBCode(pdbCode);
        this.header.put("classification", classification);
        this.header.put("depDate", deposition_date);
        this.pdbHeader.setIdCode(pdbCode);
        this.pdbHeader.setClassification(classification);
        try {
            Date dep = this.dateFormat.parse(deposition_date);
            this.pdbHeader.setDepDate(dep);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private void pdb_HELIX_Handler(String line) {
        String initResName = line.substring(15, 18).trim();
        String initChainId = line.substring(19, 20);
        String initSeqNum = line.substring(21, 25).trim();
        String initICode = line.substring(25, 26);
        String endResName = line.substring(27, 30).trim();
        String endChainId = line.substring(31, 32);
        String endSeqNum = line.substring(33, 37).trim();
        String endICode = line.substring(37, 38);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("initResName", initResName);
        m.put("initChainId", initChainId);
        m.put("initSeqNum", initSeqNum);
        m.put("initICode", initICode);
        m.put("endResName", endResName);
        m.put("endChainId", endChainId);
        m.put("endSeqNum", endSeqNum);
        m.put("endICode", endICode);
        this.helixList.add(m);
    }

    private void pdb_SHEET_Handler(String line) {
        String initResName = line.substring(17, 20).trim();
        String initChainId = line.substring(21, 22);
        String initSeqNum = line.substring(22, 26).trim();
        String initICode = line.substring(26, 27);
        String endResName = line.substring(28, 31).trim();
        String endChainId = line.substring(32, 33);
        String endSeqNum = line.substring(33, 37).trim();
        String endICode = line.substring(37, 38);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("initResName", initResName);
        m.put("initChainId", initChainId);
        m.put("initSeqNum", initSeqNum);
        m.put("initICode", initICode);
        m.put("endResName", endResName);
        m.put("endChainId", endChainId);
        m.put("endSeqNum", endSeqNum);
        m.put("endICode", endICode);
        this.strandList.add(m);
    }

    private void pdb_TURN_Handler(String line) {
        String initResName = line.substring(15, 18).trim();
        String initChainId = line.substring(19, 20);
        String initSeqNum = line.substring(20, 24).trim();
        String initICode = line.substring(24, 25);
        String endResName = line.substring(26, 29).trim();
        String endChainId = line.substring(30, 31);
        String endSeqNum = line.substring(31, 35).trim();
        String endICode = line.substring(35, 36);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("initResName", initResName);
        m.put("initChainId", initChainId);
        m.put("initSeqNum", initSeqNum);
        m.put("initICode", initICode);
        m.put("endResName", endResName);
        m.put("endChainId", endChainId);
        m.put("endSeqNum", endSeqNum);
        m.put("endICode", endICode);
        this.turnList.add(m);
    }

    private void pdb_REVDAT_Handler(String line) {
        String modDate = (String)this.header.get("modDate");
        if (modDate.equals("0000-00-00")) {
            String modificationDate = line.substring(13, 22).trim();
            this.header.put("modDate", modificationDate);
            try {
                Date dep = this.dateFormat.parse(modificationDate);
                this.pdbHeader.setModDate(dep);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    private void pdb_SEQRES_Handler(String line) throws PDBParseException {
        String recordName = line.substring(0, 6).trim();
        String chainID = line.substring(11, 12);
        String newLength = line.substring(13, 17).trim();
        String subSequence = line.substring(18, 70);
        if (this.lengthCheck == -1) {
            this.lengthCheck = Integer.parseInt(newLength);
        }
        StringTokenizer subSequenceResidues = new StringTokenizer(subSequence);
        Character aminoCode1 = null;
        if (!recordName.equals("SEQRES")) {
            return;
        }
        this.current_chain = this.isKnownChain(chainID, this.seqResChains);
        if (this.current_chain == null) {
            this.current_chain = new ChainImpl();
            this.current_chain.setName(chainID);
        }
        while (subSequenceResidues.hasMoreTokens()) {
            String threeLetter = subSequenceResidues.nextToken();
            aminoCode1 = this.get1LetterCode(threeLetter);
            this.current_group = this.getNewGroup("ATOM", aminoCode1);
            this.current_group.setPDBName(threeLetter);
            if (this.current_group instanceof AminoAcid) {
                AminoAcid aa = (AminoAcid)this.current_group;
                aa.setRecordType("SEQRES");
            }
            this.current_chain.addGroup(this.current_group);
        }
        Chain test = this.isKnownChain(chainID, this.seqResChains);
        if (test == null) {
            this.seqResChains.add(this.current_chain);
        }
        this.current_group = null;
        this.current_chain = null;
        this.lengthCheck = Integer.parseInt(newLength);
    }

    private void pdb_TITLE_Handler(String line) {
        String title = line.substring(10, 70).trim();
        String t = (String)this.header.get("title");
        t = t + title + " ";
        this.header.put("title", t);
        this.pdbHeader.setTitle(t);
    }

    private void pdb_COMPND_Handler(String line) {
        String[] fieldList;
        String continuationNr = line.substring(9, 10).trim();
        if (line.length() > 72) {
            line = line.substring(0, 72);
        }
        if (!(fieldList = (line = line.substring(10, line.length())).split("\\s+"))[0].equals("") && compndFieldValues.contains(fieldList[0])) {
            this.continuationField = fieldList[0];
            if (this.previousContinuationField.equals("")) {
                this.previousContinuationField = this.continuationField;
            }
        } else if (compndFieldValues.contains(fieldList[1])) {
            this.continuationField = fieldList[1];
            if (this.previousContinuationField.equals("")) {
                this.previousContinuationField = this.continuationField;
            }
        } else if (continuationNr.equals("")) {
            this.continuationField = "MOLECULE:";
            if (this.previousContinuationField.equals("")) {
                this.previousContinuationField = this.continuationField;
            }
        }
        line = line.replace(this.continuationField, "").trim();
        StringTokenizer compndTokens = new StringTokenizer(line);
        while (compndTokens.hasMoreTokens()) {
            String token = compndTokens.nextToken();
            if (this.previousContinuationField.equals("")) {
                this.previousContinuationField = this.continuationField;
            }
            if (this.previousContinuationField.equals(this.continuationField) && compndFieldValues.contains(this.continuationField)) {
                this.continuationString = this.continuationString.concat(token + " ");
            }
            if (!this.continuationField.equals(this.previousContinuationField)) {
                if (this.continuationString.equals("")) {
                    this.continuationString = token;
                    continue;
                }
                this.compndValueSetter(this.previousContinuationField, this.continuationString);
                this.previousContinuationField = this.continuationField;
                this.continuationString = token + " ";
                continue;
            }
            if (!ignoreCompndFieldValues.contains(token)) continue;
        }
    }

    private void compndValueSetter(String field, String value) {
        value = value.trim().replace(";", "");
        if (field.equals("MOL_ID:")) {
            if (this.molTypeCounter != Integer.valueOf(value)) {
                ++this.molTypeCounter;
                this.compounds.add(this.current_compound);
                this.current_compound = null;
                this.current_compound = new Compound();
            }
            this.current_compound.setMolId(value);
        }
        if (field.equals("MOLECULE:")) {
            this.current_compound.setMolName(value);
        }
        if (field.equals("CHAIN:")) {
            StringTokenizer chainTokens = new StringTokenizer(value, ",");
            ArrayList<String> chains = new ArrayList<String>();
            while (chainTokens.hasMoreTokens()) {
                String chainID = chainTokens.nextToken().trim();
                if (chainID.equals("NULL")) {
                    chainID = " ";
                }
                chains.add(chainID);
            }
            this.current_compound.setChainId(chains);
        }
        if (field.equals("SYNONYM:")) {
            StringTokenizer synonyms = new StringTokenizer(value, ",");
            ArrayList<String> names = new ArrayList<String>();
            while (synonyms.hasMoreTokens()) {
                names.add(synonyms.nextToken());
                this.current_compound.setSynonyms(names);
            }
        }
        if (field.equals("EC:")) {
            StringTokenizer ecNumTokens = new StringTokenizer(value, ",");
            ArrayList<String> ecNums = new ArrayList<String>();
            while (ecNumTokens.hasMoreTokens()) {
                ecNums.add(ecNumTokens.nextToken());
                this.current_compound.setEcNums(ecNums);
            }
        }
        if (field.equals("FRAGMENT:")) {
            this.current_compound.setFragment(value);
        }
        if (field.equals("ENGINEERED:")) {
            this.current_compound.setEngineered(value);
        }
        if (field.equals("MUTATION:")) {
            this.current_compound.setMutation(value);
        }
        if (field.equals("BIOLOGICAL_UNIT:")) {
            this.current_compound.setBiologicalUnit(value);
        }
        if (field.equals("OTHER_DETAILS:")) {
            this.current_compound.setDetails(value);
        }
    }

    private void pdb_SOURCE_Handler(String line) {
        try {
            if (this.compounds.size() < Integer.valueOf(this.current_compound.getMolId())) {
                this.compndValueSetter(this.continuationField, this.continuationString);
                this.continuationString = "";
                this.compounds.add(this.current_compound.clone());
            }
            if (!this.continuationString.equals("")) {
                if (this.current_compound.getMolId().equals("0")) {
                    this.current_compound.setMolName(this.continuationString);
                    this.compounds.add(this.current_compound);
                }
                this.continuationString = "";
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        int molTypeCounter = 0;
        String data = line.substring(0, 70);
        StringTokenizer sourceTokens = new StringTokenizer(data);
        while (sourceTokens.hasMoreTokens()) {
            String code = sourceTokens.nextToken();
            String[] values = data.split(":");
            int valueLength = values.length;
            String value = values[valueLength - 1].trim().replace(";", "");
            if (code.equals("MOL_ID:") && molTypeCounter != Integer.valueOf(value)) {
                for (Compound molId : this.compounds) {
                    if (!molId.getMolId().equals(value)) continue;
                    this.current_compound = molId;
                }
                ++molTypeCounter;
            }
            if (code.equals("SYNTHETIC:")) {
                this.current_compound.setSynthetic(value);
                continue;
            }
            if (code.equals("FRAGMENT:")) {
                this.current_compound.setFragment(value);
                continue;
            }
            if (code.equals("ORGANISM_SCIENTIFIC:")) {
                this.current_compound.setOrganismScientific(value);
                continue;
            }
            if (code.equals("ORGANISM_COMMON:")) {
                this.current_compound.setOrganismCommon(value);
                continue;
            }
            if (code.equals("STRAIN:")) {
                this.current_compound.setStrain(value);
                continue;
            }
            if (code.equals("VARIANT:")) {
                this.current_compound.setVariant(value);
                continue;
            }
            if (code.equals("CELL_LINE:")) {
                this.current_compound.setCellLine(value);
                continue;
            }
            if (code.equals("ATCC:")) {
                this.current_compound.setAtcc(value);
                continue;
            }
            if (code.equals("ORGAN:")) {
                this.current_compound.setOrgan(value);
                continue;
            }
            if (code.equals("TISSUE:")) {
                this.current_compound.setTissue(value);
                continue;
            }
            if (code.equals("CELL:")) {
                this.current_compound.setCell(value);
                continue;
            }
            if (code.equals("ORGANELLE:")) {
                this.current_compound.setOrganelle(value);
                continue;
            }
            if (code.equals("SECRETION:")) {
                this.current_compound.setSecretion(value);
                continue;
            }
            if (code.equals("GENE:")) {
                this.current_compound.setGene(value);
                continue;
            }
            if (code.equals("CELLULAR_LOCATION:")) {
                this.current_compound.setCellularLocation(value);
                continue;
            }
            if (code.equals("EXPRESSION_SYSTEM:")) {
                this.current_compound.setExpressionSystem(value);
                continue;
            }
            if (code.equals("EXPRESSION_SYSTEM_STRAIN:")) {
                this.current_compound.setExpressionSystemStrain(value);
                continue;
            }
            if (code.equals("EXPRESSION_SYSTEM_VARIANT:")) {
                this.current_compound.setExpressionSystemVariant(value);
                continue;
            }
            if (code.equals("EXPRESSION_SYSTEM_CELL_LINE:")) {
                this.current_compound.setExpressionSystemCellLine(value);
                continue;
            }
            if (code.equals("EXPRESSION_SYSTEM_ATCC_NUMBER:")) {
                this.current_compound.setExpressionSystemAtccNumber(value);
                continue;
            }
            if (code.equals("EXPRESSION_SYSTEM_ORGAN:")) {
                this.current_compound.setExpressionSystemOrgan(value);
                continue;
            }
            if (code.equals("EXPRESSION_SYSTEM_TISSUE:")) {
                this.current_compound.setExpressionSystemTissue(value);
                continue;
            }
            if (code.equals("EXPRESSION_SYSTEM_CELL:")) {
                this.current_compound.setExpressionSystemCell(value);
                continue;
            }
            if (code.equals("EXPRESSION_SYSTEM_ORGANELLE:")) {
                this.current_compound.setExpressionSystemOrganelle(value);
                continue;
            }
            if (code.equals("EXPRESSION_SYSTEM_CELLULAR_LOCATION:")) {
                this.current_compound.setExpressionSystemCellularLocation(value);
                continue;
            }
            if (code.equals("EXPRESSION_SYSTEM_VECTOR_TYPE:")) {
                this.current_compound.setExpressionSystemVectorType(value);
                continue;
            }
            if (code.equals("EXPRESSION_SYSTEM_VECTOR:")) {
                this.current_compound.setExpressionSystemVector(value);
                continue;
            }
            if (code.equals("EXPRESSION_SYSTEM_PLASMID:")) {
                this.current_compound.setExpressionSystemPlasmid(value);
                continue;
            }
            if (code.equals("EXPRESSION_SYSTEM_GENE:")) {
                this.current_compound.setExpressionSystemGene(value);
                continue;
            }
            if (!code.equals("OTHER_DETAILS:")) continue;
            this.current_compound.setExpressionSystemOtherDetails(value);
        }
    }

    private void pdb_REMARK_2_Handler(String line) {
        int i = line.indexOf("ANGSTROM");
        if (i != -1) {
            String resolution = line.substring(22, 27).trim();
            float res = 99.0f;
            try {
                res = Float.parseFloat(resolution);
            }
            catch (NumberFormatException e) {
                System.err.println(e.getMessage());
                System.err.println("could not parse resolution from line and ignoring it " + line);
                return;
            }
            this.header.put("resolution", new Float(res));
            this.pdbHeader.setResolution(res);
        }
    }

    private void pdb_REMARK_Handler(String line) {
        String l = line.substring(0, 11).trim();
        if (l.equals("REMARK   2")) {
            this.pdb_REMARK_2_Handler(line);
        }
    }

    private void pdb_EXPDTA_Handler(String line) {
        String technique = line.substring(10, 70).trim();
        String t = (String)this.header.get("technique");
        t = t + technique + " ";
        this.header.put("technique", t);
        this.pdbHeader.setTechnique(t);
        int nmr = technique.indexOf("NMR");
        if (nmr != -1) {
            this.structure.setNmr(true);
        }
    }

    private void pdb_ATOM_Handler(String line) throws PDBParseException {
        ++this.atomCount;
        if (this.atomCount == 500000) {
            System.err.println("more than 500000 atoms in this structure, ignoring the SEQRES lines");
            this.seqResChains.clear();
            this.switchCAOnly();
        }
        if (this.atomCount == 700000) {
            System.err.println("too many atoms (>700000in this protein structure.");
            System.err.println("ignoring lines after: " + line);
            return;
        }
        if (this.atomCount > 700000) {
            return;
        }
        String fullname = line.substring(12, 16);
        if (this.parseCAOnly && !fullname.equals(" CA ")) {
            --this.atomCount;
            return;
        }
        String recordName = line.substring(0, 6).trim();
        int pdbnumber = Integer.parseInt(line.substring(6, 11).trim());
        AtomImpl atom = new AtomImpl();
        atom.setPDBserial(pdbnumber);
        Character altLoc = new Character(line.substring(16, 17).charAt(0));
        atom.setAltLoc(altLoc);
        atom.setFullName(fullname);
        atom.setName(fullname.trim());
        double x = Double.parseDouble(line.substring(30, 38).trim());
        double y = Double.parseDouble(line.substring(38, 46).trim());
        double z = Double.parseDouble(line.substring(46, 54).trim());
        double[] coords = new double[]{x, y, z};
        atom.setCoords(coords);
        double occu = 1.0;
        if (line.length() > 59) {
            try {
                occu = Double.parseDouble(line.substring(54, 60).trim());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        double tempf = 0.0;
        if (line.length() > 65) {
            try {
                tempf = Double.parseDouble(line.substring(60, 66).trim());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        atom.setOccupancy(occu);
        atom.setTempFactor(tempf);
        String chain_id = line.substring(21, 22);
        String residueNumber = line.substring(22, 27).trim();
        String groupCode3 = line.substring(17, 20);
        Character aminoCode1 = null;
        if (recordName.equals("ATOM")) {
            aminoCode1 = this.get1LetterCode(groupCode3);
        }
        if (this.current_chain == null) {
            this.current_chain = new ChainImpl();
            this.current_chain.setName(chain_id);
        }
        if (this.current_group == null) {
            this.current_group = this.getNewGroup(recordName, aminoCode1);
            this.current_group.setPDBCode(residueNumber);
            this.current_group.setPDBName(groupCode3);
        }
        if (!chain_id.equals(this.current_chain.getName())) {
            this.current_chain.addGroup(this.current_group);
            Chain testchain = this.isKnownChain(this.current_chain.getName(), this.current_model);
            if (testchain == null) {
                this.current_model.add(this.current_chain);
            }
            if ((testchain = this.isKnownChain(chain_id, this.current_model)) != null) {
                this.current_chain = (ChainImpl)testchain;
            } else {
                this.current_chain = new ChainImpl();
                this.current_chain.setName(chain_id);
            }
            this.current_group = this.getNewGroup(recordName, aminoCode1);
            this.current_group.setPDBCode(residueNumber);
            this.current_group.setPDBName(groupCode3);
        }
        if (!residueNumber.equals(this.current_group.getPDBCode())) {
            this.current_chain.addGroup(this.current_group);
            this.current_group = this.getNewGroup(recordName, aminoCode1);
            this.current_group.setPDBCode(residueNumber);
            this.current_group.setPDBName(groupCode3);
        }
        this.current_group.addAtom(atom);
    }

    private void switchCAOnly() {
        this.parseCAOnly = true;
        this.current_model = CAConverter.getCAOnly(this.current_model);
        for (int i = 0; i < this.structure.nrModels(); ++i) {
            List<Chain> model = this.structure.getModel(i);
            model = CAConverter.getCAOnly(model);
            this.structure.setModel(i, model);
        }
        this.current_chain = CAConverter.getCAOnly(this.current_chain);
    }

    private Integer conect_helper(String line, int start, int end) {
        String sbond = line.substring(start, end).trim();
        int bond = -1;
        Integer b = null;
        if (!sbond.equals("")) {
            bond = Integer.parseInt(sbond);
            b = new Integer(bond);
        }
        return b;
    }

    private void pdb_CONECT_Handler(String line) {
        if (this.atomOverflow) {
            return;
        }
        try {
            int atomserial = Integer.parseInt(line.substring(6, 11).trim());
            Integer bond1 = this.conect_helper(line, 11, 16);
            Integer bond2 = this.conect_helper(line, 16, 21);
            Integer bond3 = this.conect_helper(line, 21, 26);
            Integer bond4 = this.conect_helper(line, 26, 31);
            Integer hyd1 = this.conect_helper(line, 31, 36);
            Integer hyd2 = this.conect_helper(line, 36, 41);
            Integer salt1 = this.conect_helper(line, 41, 46);
            Integer hyd3 = this.conect_helper(line, 46, 51);
            Integer hyd4 = this.conect_helper(line, 51, 56);
            Integer salt2 = this.conect_helper(line, 56, 61);
            HashMap<String, Integer> cons = new HashMap<String, Integer>();
            cons.put("atomserial", new Integer(atomserial));
            if (bond1 != null) {
                cons.put("bond1", bond1);
            }
            if (bond2 != null) {
                cons.put("bond2", bond2);
            }
            if (bond3 != null) {
                cons.put("bond3", bond3);
            }
            if (bond4 != null) {
                cons.put("bond4", bond4);
            }
            if (hyd1 != null) {
                cons.put("hydrogen1", hyd1);
            }
            if (hyd2 != null) {
                cons.put("hydrogen2", hyd2);
            }
            if (salt1 != null) {
                cons.put("salt1", salt1);
            }
            if (hyd3 != null) {
                cons.put("hydrogen3", hyd3);
            }
            if (hyd4 != null) {
                cons.put("hydrogen4", hyd4);
            }
            if (salt2 != null) {
                cons.put("salt2", salt2);
            }
            this.connects.add(cons);
        }
        catch (Exception e) {
            System.err.println("could not parse CONECT line correctly.");
            System.err.println(e.getMessage() + " at line " + line);
            return;
        }
    }

    private void pdb_MODEL_Handler(String line) {
        if (this.current_chain != null) {
            Chain ch;
            if (this.current_group != null) {
                this.current_chain.addGroup(this.current_group);
            }
            if ((ch = this.isKnownChain(this.current_chain.getName(), this.current_model)) == null) {
                this.current_model.add(this.current_chain);
            }
            this.structure.addModel(this.current_model);
            this.current_model = new ArrayList<Chain>();
            this.current_chain = null;
            this.current_group = null;
        }
    }

    private void pdb_DBREF_Handler(String line) {
        DBRef dbref = new DBRef();
        String idCode = line.substring(7, 11);
        String chainId = line.substring(12, 13);
        String seqBegin = line.substring(14, 18);
        String insertBegin = line.substring(18, 19);
        String seqEnd = line.substring(20, 24);
        String insertEnd = line.substring(24, 25);
        String database = line.substring(26, 32);
        String dbAccession = line.substring(33, 41);
        String dbIdCode = line.substring(42, 54);
        String dbseqBegin = line.substring(55, 60);
        String idbnsBeg = line.substring(60, 61);
        String dbseqEnd = line.substring(62, 67);
        String dbinsEnd = line.substring(67, 68);
        dbref.setIdCode(idCode);
        dbref.setChainId(Character.valueOf(chainId.charAt(0)));
        dbref.setSeqBegin(this.intFromString(seqBegin));
        dbref.setInsertBegin(insertBegin.charAt(0));
        dbref.setSeqEnd(this.intFromString(seqEnd));
        dbref.setInsertEnd(insertEnd.charAt(0));
        dbref.setDatabase(database.trim());
        dbref.setDbAcession(dbAccession.trim());
        dbref.setDbIdCode(dbIdCode.trim());
        dbref.setDbSeqBegin(this.intFromString(dbseqBegin));
        dbref.setIdbnsBegin(idbnsBeg.charAt(0));
        dbref.setDbSeqEnd(this.intFromString(dbseqEnd));
        dbref.setIdbnsEnd(dbinsEnd.charAt(0));
        this.dbrefs.add(dbref);
    }

    private void pdb_SSBOND_Handler(String line) {
        String chain1 = line.substring(15, 16);
        String seqNum1 = line.substring(18, 21).trim();
        String icode1 = line.substring(21, 22);
        String chain2 = line.substring(29, 30);
        String seqNum2 = line.substring(31, 35).trim();
        String icode2 = line.substring(35, 36);
        if (icode1.equals(" ")) {
            icode1 = "";
        }
        if (icode2.equals(" ")) {
            icode2 = "";
        }
        SSBond ssbond = new SSBond();
        ssbond.setChainID1(chain1);
        ssbond.setResnum1(seqNum1);
        ssbond.setChainID2(chain2);
        ssbond.setResnum2(seqNum2);
        ssbond.setInsCode1(icode1);
        ssbond.setInsCode2(icode2);
        this.structure.addSSBond(ssbond);
    }

    private int intFromString(String intString) {
        int val = Integer.MIN_VALUE;
        try {
            val = Integer.parseInt(intString.trim());
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
        }
        return val;
    }

    private Chain isKnownChain(String chainID, List<Chain> chains) {
        for (int i = 0; i < chains.size(); ++i) {
            Chain testchain = chains.get(i);
            if (!chainID.equals(testchain.getName())) continue;
            return testchain;
        }
        return null;
    }

    private BufferedReader getBufferedReader(InputStream inStream) throws IOException {
        if (inStream == null) {
            throw new IOException("input stream is null!");
        }
        BufferedReader buf = new BufferedReader(new InputStreamReader(inStream));
        return buf;
    }

    public Structure parsePDBFile(InputStream inStream) throws IOException {
        BufferedReader buf;
        try {
            buf = this.getBufferedReader(inStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException("error initializing BufferedReader");
        }
        return this.parsePDBFile(buf);
    }

    public Structure parsePDBFile(BufferedReader buf) throws IOException {
        this.structure = new StructureImpl();
        this.current_model = new ArrayList<Chain>();
        this.seqResChains = new ArrayList<Chain>();
        this.current_chain = null;
        this.current_group = null;
        this.header = this.init_header();
        this.pdbHeader = new PDBHeader();
        this.connects = new ArrayList<Map<String, Integer>>();
        this.continuationField = "";
        this.continuationString = "";
        this.current_compound = new Compound();
        this.molTypeCounter = 1;
        this.compounds.clear();
        this.helixList.clear();
        this.strandList.clear();
        this.turnList.clear();
        this.lengthCheck = -1;
        this.atomCount = 0;
        this.atomOverflow = false;
        String line = null;
        try {
            line = buf.readLine();
            String recordName = "";
            if (line == null) {
                throw new IOException("could not parse PDB File, BufferedReader returns null!");
            }
            while (line != null) {
                if (line.equals("") || line.equals(NEWLINE)) {
                    line = buf.readLine();
                    continue;
                }
                if (line.startsWith("TER") || line.startsWith("END")) {
                    line = buf.readLine();
                    continue;
                }
                if (line.length() < 6) {
                    System.err.println("found line length < 6. ignoring it. >" + line + "<");
                    line = buf.readLine();
                    continue;
                }
                try {
                    recordName = line.substring(0, 6).trim();
                }
                catch (StringIndexOutOfBoundsException e) {
                    System.err.println("StringIndexOutOfBoundsException at line >" + line + "<" + NEWLINE + "this does not look like an expected PDB file");
                    e.printStackTrace();
                    throw new StringIndexOutOfBoundsException(e.getMessage());
                }
                try {
                    if (recordName.equals("ATOM")) {
                        this.pdb_ATOM_Handler(line);
                    } else if (recordName.equals("SEQRES")) {
                        this.pdb_SEQRES_Handler(line);
                    } else if (recordName.equals("HETATM")) {
                        this.pdb_ATOM_Handler(line);
                    } else if (recordName.equals("MODEL")) {
                        this.pdb_MODEL_Handler(line);
                    } else if (recordName.equals("HEADER")) {
                        this.pdb_HEADER_Handler(line);
                    } else if (recordName.equals("TITLE")) {
                        this.pdb_TITLE_Handler(line);
                    } else if (recordName.equals("SOURCE")) {
                        this.pdb_SOURCE_Handler(line);
                    } else if (recordName.equals("COMPND")) {
                        this.pdb_COMPND_Handler(line);
                    } else if (recordName.equals("EXPDTA")) {
                        this.pdb_EXPDTA_Handler(line);
                    } else if (recordName.equals("REMARK")) {
                        this.pdb_REMARK_Handler(line);
                    } else if (recordName.equals("CONECT")) {
                        this.pdb_CONECT_Handler(line);
                    } else if (recordName.equals("REVDAT")) {
                        this.pdb_REVDAT_Handler(line);
                    } else if (recordName.equals("DBREF")) {
                        this.pdb_DBREF_Handler(line);
                    } else if (recordName.equals("SSBOND")) {
                        this.pdb_SSBOND_Handler(line);
                    } else if (this.parseSecStruc) {
                        if (recordName.equals(HELIX)) {
                            this.pdb_HELIX_Handler(line);
                        } else if (recordName.equals("SHEET")) {
                            this.pdb_SHEET_Handler(line);
                        } else if (recordName.equals(TURN)) {
                            this.pdb_TURN_Handler(line);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println("badly formatted line ... " + line);
                }
                line = buf.readLine();
            }
            this.triggerEndFileChecks();
        }
        catch (Exception e) {
            System.err.println(line);
            e.printStackTrace();
            throw new IOException("Error parsing PDB file");
        }
        if (this.parseSecStruc) {
            this.setSecStruc();
        }
        return this.structure;
    }

    private void triggerEndFileChecks() {
        String modDate = (String)this.header.get("modDate");
        if (modDate.equals("0000-00-00")) {
            String depositionDate = (String)this.header.get("depDate");
            this.header.put("modDate", depositionDate);
            if (!depositionDate.equals(modDate)) {
                try {
                    Date dep = this.dateFormat.parse(depositionDate);
                    this.pdbHeader.setDepDate(dep);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.current_chain != null) {
            this.current_chain.addGroup(this.current_group);
            if (this.isKnownChain(this.current_chain.getName(), this.current_model) == null) {
                this.current_model.add(this.current_chain);
            }
        }
        this.structure.addModel(this.current_model);
        this.structure.setHeader(this.header);
        this.structure.setPDBHeader(this.pdbHeader);
        this.structure.setConnections(this.connects);
        this.structure.setCompounds(this.compounds);
        this.structure.setDBRefs(this.dbrefs);
        if (this.alignSeqRes) {
            SeqRes2AtomAligner aligner = new SeqRes2AtomAligner();
            aligner.align(this.structure, this.seqResChains);
        }
        this.linkChains2Compound(this.structure);
    }

    private void setSecStruc() {
        this.setSecElement(this.helixList, PDB_AUTHOR_ASSIGNMENT, HELIX);
        this.setSecElement(this.strandList, PDB_AUTHOR_ASSIGNMENT, STRAND);
        this.setSecElement(this.turnList, PDB_AUTHOR_ASSIGNMENT, TURN);
    }

    private void setSecElement(List<Map<String, String>> secList, String assignment, String type) {
        block0: for (Map<String, String> m : secList) {
            String initChainId = m.get("initChainId");
            String initSeqNum = m.get("initSeqNum");
            String initICode = m.get("initICode");
            String endChainId = m.get("endChainId");
            String endSeqNum = m.get("endSeqNum");
            String endICode = m.get("endICode");
            if (initICode.equals(" ")) {
                initICode = "";
            }
            if (endICode.equals(" ")) {
                endICode = "";
            }
            GroupIterator gi = new GroupIterator(this.structure);
            boolean inRange = false;
            while (gi.hasNext()) {
                String pdbCode;
                Group g = gi.next();
                Chain c = g.getParent();
                if (c.getName().equals(initChainId)) {
                    pdbCode = initSeqNum + initICode;
                    if (g.getPDBCode().equals(pdbCode)) {
                        inRange = true;
                    }
                }
                if (inRange && g instanceof AminoAcid) {
                    AminoAcid aa = (AminoAcid)g;
                    HashMap<String, String> assignmentMap = new HashMap<String, String>();
                    assignmentMap.put(assignment, type);
                    aa.setSecStruc(assignmentMap);
                }
                if (!c.getName().equals(endChainId) || !(pdbCode = endSeqNum + endICode).equals(g.getPDBCode())) continue;
                inRange = false;
                continue block0;
            }
        }
    }

    public void linkChains2Compound(Structure s) {
        List<Chain> chains;
        Compound comp;
        List<String> chainIds;
        List<Compound> compounds = s.getCompounds();
        for (Compound comp2 : compounds) {
            ArrayList<Chain> chains2 = new ArrayList<Chain>();
            chainIds = comp2.getChainId();
            if (chainIds == null) continue;
            for (String chainId : chainIds) {
                if (chainId.equals("NULL")) {
                    chainId = " ";
                }
                try {
                    Chain c = s.findChain(chainId);
                    chains2.add(c);
                }
                catch (StructureException e) {
                    e.printStackTrace();
                }
            }
            comp2.setChains(chains2);
        }
        if (compounds.size() == 1 && (comp = compounds.get(0)).getChainId() == null && (chains = s.getChains(0)).size() == 1) {
            Chain ch = chains.get(0);
            chainIds = new ArrayList<String>();
            chainIds.add(ch.getName());
            comp.setChainId(chainIds);
            comp.addChain(ch);
        }
        for (Compound comp2 : compounds) {
            if (comp2.getChainId() == null) continue;
            for (String chainId : comp2.getChainId()) {
                if (chainId.equals("NULL")) continue;
                try {
                    Chain c = s.getChainByPDB(chainId);
                    c.setHeader(comp2);
                }
                catch (StructureException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static {
        compndFieldValues = new ArrayList<String>(Arrays.asList("MOL_ID:", "MOLECULE:", "CHAIN:", "SYNONYM:", "EC:", "FRAGMENT:", "ENGINEERED:", "MUTATION:", "BIOLOGICAL_UNIT:", "OTHER_DETAILS:"));
        ignoreCompndFieldValues = new ArrayList<String>(Arrays.asList("HETEROGEN:", "ENGINEEREED:", "FRAGMENT,", "MUTANT:", "SYNTHETIC:"));
        nucleotides30 = new HashMap<String, Integer>();
        nucleotides30.put("DA", 1);
        nucleotides30.put("DC", 1);
        nucleotides30.put("DG", 1);
        nucleotides30.put("DT", 1);
        nucleotides30.put("DI", 1);
        nucleotides30.put("A", 1);
        nucleotides30.put("G", 1);
        nucleotides30.put("C", 1);
        nucleotides30.put("U", 1);
        nucleotides30.put("I", 1);
        nucleotides30.put("TAF", 1);
        nucleotides30.put("TC1", 1);
        nucleotides30.put("TFE", 1);
        nucleotides30.put("TFO", 1);
        nucleotides30.put("TGP", 1);
        nucleotides30.put("THX", 1);
        nucleotides30.put("TLC", 1);
        nucleotides30.put("TLN", 1);
        nucleotides30.put("TP1", 1);
        nucleotides30.put("TPC", 1);
        nucleotides30.put("TPN", 1);
        nucleotides23 = new HashMap<String, Integer>();
        String[] names = new String[]{"C", "G", "A", "T", "U", "I", "+C", "+G", "+A", "+T", "+U", "+I"};
        for (int i = 0; i < names.length; ++i) {
            String n = names[i];
            nucleotides23.put(n, 1);
        }
        try {
            FiniteAlphabet alpha_prot = ProteinTools.getAlphabet();
            threeLetter = alpha_prot.getTokenization("name");
            oneLetter = alpha_prot.getTokenization("token");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        NEWLINE = System.getProperty("line.separator");
    }
}

