/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.utils;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringTools {
    private StringTools() {
    }

    public static String leftIndent(String input, int leftIndent) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < leftIndent; ++i) {
            b.append(" ");
        }
        b.append(input);
        return b.toString();
    }

    public static String leftPad(String input, int totalWidth) {
        return StringTools.leftPad(input, ' ', totalWidth);
    }

    public static String leftPad(String input, char padChar, int totalWidth) {
        StringBuffer b = new StringBuffer();
        b.append(input);
        while (b.length() < totalWidth) {
            b.insert(0, padChar);
        }
        return b.toString();
    }

    public static String rightPad(String input, int totalWidth) {
        return StringTools.rightPad(input, ' ', totalWidth);
    }

    public static String rightPad(String input, char padChar, int totalWidth) {
        StringBuffer b = new StringBuffer();
        b.append(input);
        while (b.length() < totalWidth) {
            b.append(padChar);
        }
        return b.toString();
    }

    public static String[] wordWrap(String input, String sepRegex, int width) {
        ArrayList<String> lines = new ArrayList<String>();
        Pattern p = Pattern.compile(sepRegex);
        int start = 0;
        while (start < input.length()) {
            int splitPoint = start + width;
            int newline = input.indexOf(10, start);
            if (newline >= start && newline < splitPoint) {
                splitPoint = newline;
            }
            if (splitPoint >= input.length()) {
                splitPoint = input.length();
            } else {
                while (splitPoint >= start) {
                    char c = input.charAt(splitPoint);
                    Matcher m = p.matcher("" + c);
                    if (m.matches()) {
                        ++splitPoint;
                        break;
                    }
                    --splitPoint;
                }
                if (splitPoint <= start) {
                    splitPoint = start + width;
                }
            }
            lines.add(StringTools.trimTrailingBlanks(newline == splitPoint - 1 ? input.substring(start, splitPoint - 1) : input.substring(start, splitPoint)));
            start = splitPoint;
        }
        return lines.toArray(new String[0]);
    }

    private static final String trimTrailingBlanks(String theString) {
        int len;
        if (theString.length() == 0 || theString.charAt(theString.length() - 1) != ' ') {
            return theString;
        }
        char[] val = theString.toCharArray();
        for (len = theString.length(); len > 0 && val[len - 1] <= ' '; --len) {
        }
        return len < theString.length() ? theString.substring(0, len) : theString;
    }

    public static void writeKeyValueLine(String key, String text, int keyWidth, int lineWidth, PrintStream os) {
        StringTools.writeKeyValueLine(key, text, keyWidth, lineWidth, null, null, os);
    }

    public static void writeKeyValueLine(String key, String text, int keyWidth, int lineWidth, String sep, PrintStream os) {
        StringTools.writeKeyValueLine(key, text, keyWidth, lineWidth, sep, null, os);
    }

    public static void writeKeyValueLine(String key, String text, int keyWidth, int lineWidth, String sep, String wrappedKey, PrintStream os) {
        String[] lines;
        if (key == null || text == null) {
            return;
        }
        if (wrappedKey == null) {
            wrappedKey = "";
        }
        if (sep == null) {
            sep = "\\s+";
        }
        if ((lines = StringTools.wordWrap(text, sep, lineWidth - keyWidth)).length == 0) {
            os.println(StringTools.rightPad(key, keyWidth));
        } else {
            lines[0] = StringTools.rightPad(key, keyWidth) + lines[0];
            os.println(lines[0]);
            for (int i = 1; i < lines.length; ++i) {
                os.println(StringTools.rightPad(wrappedKey, keyWidth) + lines[i]);
            }
        }
    }
}

