/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.meshGeneration.ruppert;

import java.io.Serializable;

public class Delaunay
implements Serializable {
    private static final long serialVersionUID = 1L;
    static double MIN_LINE_COS_ANGLE = 0.99862953;
    int maximalNumberOfPoints = 1000;
    int maximalNumberOfFaces = 1000;
    double[] point = new double[3 * this.maximalNumberOfPoints];
    int[] face = new int[3 * this.maximalNumberOfFaces];
    int[] neighbor = new int[3 * this.maximalNumberOfFaces];
    boolean[] segment = new boolean[3 * this.maximalNumberOfFaces];
    int numberOfPoints;
    int numberOfFaces;
    double xyBound;
    boolean[] obsolete;
    boolean hasExteriorPoints = true;
    int[] newFace = new int[4];
    int[] newEdge = new int[4];
    int pointOnEdge;
    final double EPS = 1.0E-12;
    double circleX;
    double circleY;
    double circleR;
    public int maxDepth = 10000;

    public Delaunay(double[] dArray) {
        this.init(dArray);
        this.eatExterior();
    }

    public Delaunay(double[][] dArray) {
        this.init(Delaunay.makePointArray(dArray));
        this.checkBoundary(dArray);
        this.makeSegments(dArray);
        this.eatExterior(dArray);
    }

    public static int[] triangulate(double[] dArray) {
        return new Delaunay(dArray).getIndices();
    }

    public double getBound() {
        return this.xyBound;
    }

    public int[] getIndices() {
        int[] nArray = new int[3 * this.numberOfFaces];
        System.arraycopy(this.face, 0, nArray, 0, 3 * this.numberOfFaces);
        return nArray;
    }

    public int getIndex(int n, int n2) {
        return this.face[n * 3 + n2];
    }

    public void getPoint(int n, double[] dArray) {
        if (dArray == null) {
            throw new RuntimeException("no array submitted");
        }
        if (dArray.length < 2) {
            throw new RuntimeException("submitted array is to small");
        }
        dArray[0] = this.point[2 * n];
        dArray[1] = this.point[2 * n + 1];
    }

    public double x(int n) {
        return this.point[2 * n];
    }

    public double y(int n) {
        return this.point[2 * n + 1];
    }

    public void getPoints(double[] dArray, int n) {
        if (dArray == null) {
            throw new RuntimeException("no array submitted");
        }
        if (this.point.length < 2 * this.numberOfPoints + n) {
            throw new RuntimeException("submitted array is to small");
        }
        System.arraycopy(this.point, 0, dArray, n, 2 * this.numberOfPoints);
    }

    public double[] getPoints() {
        double[] dArray = new double[2 * this.numberOfPoints];
        this.getPoints(dArray, 0);
        return dArray;
    }

    public int getNumFaces() {
        return this.numberOfFaces;
    }

    public int getNumPoints() {
        return this.numberOfPoints;
    }

    void init(double[] dArray) {
        int n;
        int n2 = dArray.length / 2;
        this.xyBound = Math.abs(dArray[0]);
        for (n = 1; n < 2 * n2; ++n) {
            double d;
            double d2 = Math.abs(dArray[n]);
            if (!(d > this.xyBound)) continue;
            this.xyBound = d2;
        }
        if (this.xyBound == 0.0) {
            this.xyBound = 1.0;
        }
        this.numberOfPoints = 3;
        this.point[0] = 3.0 * this.xyBound;
        this.point[1] = 0.0;
        this.point[2] = 0.0;
        this.point[3] = 3.0 * this.xyBound;
        this.point[4] = -3.0 * this.xyBound;
        this.point[5] = -3.0 * this.xyBound;
        this.numberOfFaces = 1;
        this.face[0] = 0;
        this.face[1] = 1;
        this.face[2] = 2;
        this.neighbor[0] = -1;
        this.neighbor[1] = -1;
        this.neighbor[2] = -1;
        n = 0;
        int n3 = 0;
        while (n < n2) {
            this.addPoint(dArray[n3], dArray[n3 + 1]);
            ++n;
            n3 += 2;
        }
    }

    public void addPoint(double d, double d2) {
        int n = this.findTriangle(d, d2);
        if (n < 0) {
            throw new RuntimeException("point in no face");
        }
        if (this.pointOnEdge < 0) {
            this.addPoint(d, d2, n);
        } else {
            this.addPoint(d, d2, n, this.pointOnEdge);
        }
    }

    void addPoint(double d, double d2, int n) {
        this.checkPointArray();
        this.point[2 * this.numberOfPoints] = d;
        this.point[2 * this.numberOfPoints + 1] = d2;
        ++this.numberOfPoints;
        this.splitTriangle(n);
        this.legalizeNewFaces();
    }

    void addPoint(double d, double d2, int n, int n2) {
        this.checkPointArray();
        this.point[2 * this.numberOfPoints] = d;
        this.point[2 * this.numberOfPoints + 1] = d2;
        ++this.numberOfPoints;
        this.splitEdge(n, n2);
        this.legalizeNewFaces();
    }

    void legalizeNewFaces() {
        int n = this.newFace[0];
        int n2 = this.newFace[1];
        int n3 = this.newFace[2];
        int n4 = this.newFace[3];
        int n5 = this.newEdge[0];
        int n6 = this.newEdge[1];
        int n7 = this.newEdge[2];
        int n8 = this.newEdge[3];
        this.legalizeEdge(n, n5);
        this.legalizeEdge(n2, n6);
        if (n3 >= 0) {
            this.legalizeEdge(n3, n7);
        }
        if (n4 >= 0) {
            this.legalizeEdge(n4, n8);
        }
    }

    int flipEdge(int n, int n2) {
        int n3 = 3 * n;
        int n4 = n3 + (n2 + 2) % 3;
        int n5 = this.neighbor[n3 + n2];
        int n6 = 3 * n5;
        int n7 = this.getNeighbor(n5, n);
        int n8 = n6 + (n7 + 2) % 3;
        this.face[n3 + (n2 + 1) % 3] = this.face[n6 + n7];
        this.face[n6 + (n7 + 1) % 3] = this.face[n3 + n2];
        int n9 = this.neighbor[n8];
        if (n9 >= 0) {
            this.replaceNeighbor(n9, n5, n);
        }
        this.neighbor[n3 + n2] = n9;
        n9 = this.neighbor[n4];
        if (n9 >= 0) {
            this.replaceNeighbor(n9, n, n5);
        }
        this.neighbor[n6 + n7] = n9;
        this.neighbor[n4] = n5;
        this.neighbor[n8] = n;
        return (n7 + 1) % 3;
    }

    int findTriangle(double d, double d2) {
        int n = 0;
        int n2 = 0;
        while (n < this.numberOfFaces) {
            if (this.checkTriangle(n, d, d2)) {
                return n;
            }
            ++n;
            n2 += 3;
        }
        return -1;
    }

    boolean checkTriangle(int n, double d, double d2) {
        int n2 = 3 * n;
        int n3 = 2 * this.face[n2++];
        int n4 = 2 * this.face[n2++];
        int n5 = 2 * this.face[n2];
        double d3 = this.point[n3++];
        double d4 = this.point[n3];
        double d5 = this.point[n4++];
        double d6 = this.point[n4];
        double d7 = this.point[n5++];
        double d8 = this.point[n5];
        double d9 = d7 - d5;
        double d10 = d8 - d6;
        double d11 = d3 - d7;
        double d12 = d4 - d8;
        double d13 = d5 - d3;
        double d14 = d6 - d4;
        double d15 = d - d5;
        double d16 = d2 - d6;
        double d17 = d - d7;
        double d18 = d2 - d8;
        double d19 = d - d3;
        double d20 = d2 - d4;
        double d21 = d9 * d16 - d10 * d15;
        double d22 = d11 * d18 - d12 * d17;
        double d23 = d13 * d20 - d14 * d19;
        if (d21 < -1.0E-12 || d22 < -1.0E-12 || d23 < -1.0E-12) {
            return false;
        }
        this.pointOnEdge = -1;
        double d24 = d15 * d15 + d16 * d16;
        double d25 = d17 * d17 + d18 * d18;
        double d26 = d19 * d19 + d20 * d20;
        double d27 = d9 * d9 + d10 * d10;
        double d28 = d11 * d11 + d12 * d12;
        double d29 = d13 * d13 + d14 * d14;
        double d30 = d9 * d15 + d10 * d16;
        double d31 = d11 * d17 + d12 * d18;
        double d32 = d13 * d19 + d14 * d20;
        double d33 = d30 / Math.sqrt(d27 * d24);
        double d34 = d31 / Math.sqrt(d28 * d25);
        double d35 = d32 / Math.sqrt(d29 * d26);
        if (d33 > d34) {
            if (d33 > d35) {
                if (d33 >= MIN_LINE_COS_ANGLE) {
                    this.pointOnEdge = this.checkForNewEdges(d5, d6, d7, d8, d, d2, n, 0);
                }
            } else if (d35 >= MIN_LINE_COS_ANGLE) {
                this.pointOnEdge = this.checkForNewEdges(d3, d4, d5, d6, d, d2, n, 2);
            }
        } else if (d34 > d35) {
            if (d34 > MIN_LINE_COS_ANGLE) {
                this.pointOnEdge = this.checkForNewEdges(d7, d8, d3, d4, d, d2, n, 1);
            }
        } else if (d35 >= MIN_LINE_COS_ANGLE) {
            this.pointOnEdge = this.checkForNewEdges(d3, d4, d5, d6, d, d2, n, 2);
        }
        return true;
    }

    int checkForNewEdges(double d, double d2, double d3, double d4, double d5, double d6, int n, int n2) {
        int n3 = this.neighbor[3 * n + n2];
        if (n3 < 0) {
            return n2;
        }
        int n4 = 2 * this.face[this.getNeighborPtr(n3, n)];
        double d7 = this.point[n4++];
        double d8 = this.point[n4];
        double d9 = d5 - d7;
        double d10 = d6 - d8;
        double d11 = d - d7;
        double d12 = d2 - d8;
        double d13 = d3 - d7;
        double d14 = d4 - d8;
        if (d9 * d12 - d10 * d11 > 0.0 && d13 * d10 - d14 * d9 > 0.0) {
            return n2;
        }
        return -1;
    }

    void splitTriangle(int n) {
        this.checkFaceArray();
        int n2 = 3 * n;
        int n3 = 3 * this.numberOfFaces;
        int n4 = this.neighbor[n2];
        int n5 = this.face[n2++];
        int n6 = this.neighbor[n2];
        int n7 = this.face[n2++];
        int n8 = this.neighbor[n2];
        int n9 = this.face[n2];
        if (n4 >= 0) {
            this.replaceNeighbor(n4, n, this.numberOfFaces + 1);
        }
        if (n8 >= 0) {
            this.replaceNeighbor(n8, n, this.numberOfFaces);
        }
        n2 = 3 * n;
        this.neighbor[n2++] = this.numberOfFaces + 1;
        this.face[n2++] = this.numberOfPoints - 1;
        this.neighbor[n2] = this.numberOfFaces;
        this.neighbor[n3] = this.numberOfFaces + 1;
        this.face[n3++] = n5;
        this.neighbor[n3] = n;
        this.face[n3++] = n7;
        this.neighbor[n3] = n8;
        this.face[n3++] = this.numberOfPoints - 1;
        this.neighbor[n3] = n;
        this.face[n3++] = n7;
        this.neighbor[n3] = this.numberOfFaces;
        this.face[n3++] = n9;
        this.neighbor[n3] = n4;
        this.face[n3++] = this.numberOfPoints - 1;
        this.newFace[0] = n;
        this.newFace[1] = this.numberOfFaces;
        this.newFace[2] = this.numberOfFaces + 1;
        this.newFace[3] = -1;
        this.newEdge[0] = 1;
        this.newEdge[1] = 2;
        this.newEdge[2] = 2;
        this.numberOfFaces += 2;
    }

    void splitEdge(int n, int n2) {
        this.checkFaceArray();
        int n3 = 3 * n;
        int n4 = 3 * this.numberOfFaces;
        int n5 = n3 + n2;
        int n6 = n3 + (n2 + 1) % 3;
        int n7 = n3 + (n2 + 2) % 3;
        int n8 = this.neighbor[n5];
        int n9 = this.face[n5];
        int n10 = this.face[n6];
        int n11 = this.neighbor[n7];
        if (n11 >= 0) {
            this.replaceNeighbor(n11, n, this.numberOfFaces);
        }
        this.face[n6] = this.numberOfPoints - 1;
        this.neighbor[n7] = this.numberOfFaces;
        this.face[n4++] = n9;
        this.neighbor[n4] = n;
        this.face[n4++] = n10;
        this.neighbor[n4] = n11;
        this.face[n4++] = this.numberOfPoints - 1;
        this.newFace[0] = n;
        this.newEdge[0] = (n2 + 1) % 3;
        this.newFace[1] = this.numberOfFaces;
        this.newEdge[1] = 2;
        if (n8 >= 0) {
            this.neighbor[3 * this.numberOfFaces] = this.numberOfFaces + 1;
            int n12 = 3 * n8;
            int n13 = this.getNeighbor(n8, n);
            int n14 = n12 + n13;
            int n15 = n12 + (n13 + 1) % 3;
            int n16 = n12 + (n13 + 2) % 3;
            int n17 = this.neighbor[n15];
            int n18 = this.face[n14];
            if (n17 >= 0) {
                this.replaceNeighbor(n17, n8, this.numberOfFaces + 1);
            }
            this.face[n16] = this.numberOfPoints - 1;
            this.neighbor[n15] = this.numberOfFaces + 1;
            this.neighbor[n4] = n8;
            this.face[n4++] = n10;
            this.neighbor[n4] = this.numberOfFaces;
            this.face[n4++] = n18;
            this.neighbor[n4] = n17;
            this.face[n4] = this.numberOfPoints - 1;
            this.newFace[2] = n8;
            this.newEdge[2] = (n13 + 2) % 3;
            this.newFace[3] = this.numberOfFaces + 1;
            this.newEdge[3] = 2;
            this.numberOfFaces += 2;
        } else {
            this.neighbor[3 * this.numberOfFaces] = -1;
            this.newFace[2] = -1;
            this.newFace[3] = -1;
            ++this.numberOfFaces;
        }
    }

    void replaceNeighbor(int n, int n2, int n3) {
        this.neighbor[this.getNeighborPtr((int)n, (int)n2)] = n3;
    }

    int getNeighborPtr(int n, int n2) {
        int n3 = 3 * n - 1;
        for (int i = 0; i < 3; ++i) {
            if (this.neighbor[++n3] != n2) continue;
            return n3;
        }
        throw new IllegalArgumentException(n2 + " is not a neighbor of " + n);
    }

    int getNeighbor(int n, int n2) {
        int n3 = 3 * n;
        for (int i = 0; i < 3; ++i) {
            if (this.neighbor[n3++] != n2) continue;
            return i;
        }
        throw new IllegalArgumentException(n2 + " is not a neighbor of " + n);
    }

    boolean edgeIllegal(int n, int n2) {
        int n3;
        if (this.hasExteriorPoints) {
            int n4 = 3 * n;
            int n5 = this.neighbor[n4 + n2];
            if (n5 < 0) {
                return false;
            }
            int n6 = this.face[n4 + n2];
            int n7 = this.face[n4 + (n2 + 1) % 3];
            int n8 = this.face[n4 + (n2 + 2) % 3];
            int n9 = this.face[this.getNeighborPtr(n5, n)];
            if (n6 == 0 || n9 == 0) {
                return false;
            }
            if (n6 == 1 || n9 == 1) {
                return false;
            }
            if (n6 == 2 || n9 == 2) {
                return false;
            }
            n3 = 2 * n9;
        } else {
            int n10 = 3 * n + 3;
            if (this.segment[n10]) {
                return false;
            }
            int n11 = this.neighbor[n10];
            if (n11 < 0) {
                return false;
            }
            n3 = 2 * this.face[this.getNeighborPtr(n11, n)];
        }
        return this.pointInCircle(this.point[n3++], this.point[n3], n);
    }

    void computeCircumCircle(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d3 - d;
        double d8 = d4 - d2;
        double d9 = d6 - d4;
        double d10 = d3 - d5;
        this.circleX = (d3 + d5) * 0.5;
        this.circleY = (d4 + d6) * 0.5;
        double d11 = (d - d5) * 0.5;
        double d12 = (d2 - d6) * 0.5;
        double d13 = (d7 * d11 + d8 * d12) / (d7 * d9 + d8 * d10);
        this.circleX += d13 * d9;
        this.circleY += d13 * d10;
        double d14 = d - this.circleX;
        double d15 = d2 - this.circleY;
        this.circleR = d14 * d14 + d15 * d15;
    }

    void computeCircumCircle(int n) {
        int n2 = 3 * n;
        int n3 = 2 * this.face[n2++];
        int n4 = 2 * this.face[n2++];
        int n5 = 2 * this.face[n2];
        this.computeCircumCircle(this.point[n3++], this.point[n3], this.point[n4++], this.point[n4], this.point[n5++], this.point[n5]);
    }

    boolean pointInCircle(double d, double d2, int n) {
        this.computeCircumCircle(n);
        double d3 = d - this.circleX;
        double d4 = d2 - this.circleY;
        return d3 * d3 + d4 * d4 < this.circleR;
    }

    void legalizeEdge(int n, int n2) {
        if (this.edgeIllegal(n, n2)) {
            int n3 = this.neighbor[3 * n + n2];
            int n4 = this.flipEdge(n, n2);
            this.legalizeEdge(n, n2);
            this.legalizeEdge(n3, n4);
        }
    }

    void checkPointArray() {
        if (this.numberOfPoints >= this.maximalNumberOfPoints - 1) {
            this.point = this.doubleSize(this.point);
            this.maximalNumberOfPoints *= 2;
        }
    }

    void checkFaceArray() {
        if (this.numberOfFaces >= this.maximalNumberOfFaces - 4) {
            this.face = this.doubleSize(this.face);
            this.neighbor = this.doubleSize(this.neighbor);
            this.segment = this.doubleSize(this.segment);
            this.maximalNumberOfFaces *= 2;
        }
    }

    double[] doubleSize(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[2 * n];
        System.arraycopy(dArray, 0, dArray2, 0, n);
        return dArray2;
    }

    int[] doubleSize(int[] nArray) {
        int n = nArray.length;
        int[] nArray2 = new int[2 * n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    boolean[] doubleSize(boolean[] blArray) {
        int n = blArray.length;
        boolean[] blArray2 = new boolean[2 * n];
        System.arraycopy(blArray, 0, blArray2, 0, n);
        return blArray2;
    }

    int pointInFace(int n, int n2) {
        int n3 = 3 * n;
        for (int i = 0; i < 3; ++i) {
            if (this.face[n3++] != n2) continue;
            return i;
        }
        return -1;
    }

    int edgeInFace(int n, int n2, int n3) {
        int n4 = this.pointInFace(n, n2);
        int n5 = this.pointInFace(n, n3);
        if (n4 < 0 || n5 < 0) {
            return -1;
        }
        return 3 - n4 - n5;
    }

    void eatExterior() {
        this.obsolete = new boolean[this.numberOfFaces];
        int n = 0;
        while (n < this.numberOfFaces) {
            this.obsolete[n++] = false;
        }
        int n2 = 0;
        for (n = 0; n < this.numberOfFaces; ++n) {
            int n3 = 0;
            while (n3 < 3) {
                int n4 = this.face[n2];
                if (n4 == 0 || n4 == 1 || n4 == 2) {
                    this.obsolete[n] = true;
                }
                ++n3;
                ++n2;
            }
        }
        this.deleteObsoleteFaces();
        this.hasExteriorPoints = false;
    }

    void deleteObsoleteFaces() {
        int n;
        int[] nArray = new int[this.numberOfFaces];
        int n2 = 0;
        for (n = 0; n < this.numberOfFaces; ++n) {
            nArray[n] = this.obsolete[n] ? -1 : n2++;
        }
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < this.numberOfFaces; ++n) {
            if (this.obsolete[n]) {
                n3 += 3;
                continue;
            }
            System.arraycopy(this.face, n3, this.face, n4, 3);
            System.arraycopy(this.segment, n3, this.segment, n4, 3);
            int n5 = 0;
            while (n5 < 3) {
                int n6;
                this.neighbor[n4] = (n6 = this.neighbor[n3++]) < 0 ? -1 : nArray[n6];
                ++n5;
                ++n4;
            }
        }
        this.numberOfFaces = n2;
    }

    void shiftPoints() {
        int n = 3 * this.numberOfFaces;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            this.face[n3] = this.face[n3] - 3;
        }
        n2 = 3 * this.numberOfPoints - 6;
        System.arraycopy(this.point, 6, this.point, 0, n2);
        this.numberOfPoints -= 3;
    }

    static double[] makePointArray(double[][] dArray) {
        int n = 0;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            n += dArray[i].length;
        }
        double[] dArray2 = new double[n];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = dArray[i].length;
            if (n4 % 2 == 1) {
                throw new RuntimeException("points need to be 2-dimensional");
            }
            System.arraycopy(dArray[i], 0, dArray2, n3, n4);
            n3 += n4;
        }
        return dArray2;
    }

    void makeSegments(double[][] dArray) {
        int n = dArray.length;
        int n2 = 3;
        for (int i = 0; i < n; ++i) {
            int n3 = dArray[i].length / 2;
            for (int j = 0; j < n3 - 1; ++j) {
                this.seekSegment(n2 + j, n2 + j + 1, 0);
            }
            if (n3 > 1) {
                this.seekSegment(n2, n2 + n3 - 1, 0);
            }
            n2 += n3;
        }
    }

    boolean markSegment(int n, int n2) {
        int n3 = 3 * n + n2;
        int n4 = this.neighbor[n3];
        if (n4 >= 0) {
            this.segment[this.getNeighborPtr((int)n4, (int)n)] = true;
        }
        this.segment[n3] = true;
        return true;
    }

    boolean seekAndMarkSegment(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.numberOfFaces) {
            if (this.face[n4] == n) {
                if (this.face[n4 + 1] == n2) {
                    return this.markSegment(n3, 2);
                }
                if (this.face[n4 + 2] == n2) {
                    return this.markSegment(n3, 1);
                }
            }
            if (this.face[n4 + 1] == n) {
                if (this.face[n4] == n2) {
                    return this.markSegment(n3, 2);
                }
                if (this.face[n4 + 2] == n2) {
                    return this.markSegment(n3, 0);
                }
            }
            if (this.face[n4 + 2] == n) {
                if (this.face[n4] == n2) {
                    return this.markSegment(n3, 1);
                }
                if (this.face[n4 + 1] == n2) {
                    return this.markSegment(n3, 0);
                }
            }
            ++n3;
            n4 += 3;
        }
        return false;
    }

    void seekSegment(int n, int n2, int n3) {
        if (!this.seekAndMarkSegment(n, n2)) {
            if (n3 >= this.maxDepth) {
                System.out.println("hit max recursion!");
                return;
            }
            int n4 = this.numberOfPoints;
            int n5 = 2 * n;
            int n6 = 2 * n2;
            this.addPoint(0.5 * (this.point[n5++] + this.point[n6++]), 0.5 * (this.point[n5] + this.point[n6]));
            this.seekSegment(n, n4, n3 + 1);
            this.seekSegment(n2, n4, n3 + 1);
        }
    }

    void eatExterior(double[][] dArray) {
        int n;
        this.obsolete = new boolean[this.numberOfFaces];
        int n2 = 0;
        while (n2 < this.numberOfFaces) {
            this.obsolete[n2++] = false;
        }
        for (n = 0; n < 3; ++n) {
            n2 = 0;
            int n3 = 0;
            while (this.face[n3++] != n && this.face[n3++] != n && this.face[n3++] != n) {
                ++n2;
            }
            if (n2 >= this.numberOfFaces) continue;
            this.eatFace(n2, 0);
        }
        n = dArray.length;
        for (int i = 1; i < n; ++i) {
            if (!this.computeInteriorPoint(dArray[i])) continue;
            this.eatFace(this.findTriangle(this.circleX, this.circleY), 0);
        }
        this.deleteObsoleteFaces();
        this.shiftPoints();
        this.hasExteriorPoints = false;
    }

    boolean computeInteriorPoint(double[] dArray) {
        double d;
        double d2 = dArray[0];
        int n = 0;
        int n2 = dArray.length / 2;
        int n3 = 1;
        int n4 = 2;
        while (n3 < n2) {
            double d3;
            d = dArray[n4];
            if (d3 > d2) {
                d2 = d;
                n = n3;
            }
            ++n3;
            n4 += 2;
        }
        int n5 = 2 * ((n + 1) % n2);
        double d4 = dArray[2 * n + 1];
        double d5 = dArray[n5 + 1] - d4;
        int n6 = 2 * ((n - 1 + n2) % n2);
        double d6 = dArray[n6 + 1] - d4;
        if (d5 * d6 >= 0.0) {
            double d7;
            double d8;
            if (d5 == 0.0 && d6 == 0.0) {
                return false;
            }
            d = 1.0;
            int n7 = 0;
            for (int i = 0; i < n2; ++i) {
                if (i != n) {
                    d8 = dArray[n7++] - d2;
                    int n8 = n7++;
                    d7 = dArray[n8] - d4;
                    double d9 = d8 * d8 + d7 * d7;
                    if (!(d9 < d)) continue;
                    d = d9;
                    continue;
                }
                n7 += 2;
            }
            double d10 = dArray[n5++] + dArray[n6++] - 2.0 * d2;
            d8 = dArray[n5] + dArray[n6] - 2.0 * d4;
            d7 = 0.5 * Math.sqrt(d / (d10 * d10 + d8 * d8));
            this.circleX = d2 + d7 * d10;
            this.circleY = d4 + d7 * d8;
            return true;
        }
        d = d2 - 1.0;
        for (int i = 0; i < n2; ++i) {
            double d11;
            if (n == i || n == (i + 1) % n2) continue;
            n5 = 2 * i;
            n6 = 2 * ((i + 1) % n2);
            double d12 = dArray[n5++];
            double d13 = dArray[n5];
            double d14 = dArray[n6++];
            double d15 = dArray[n6];
            if (!((d15 - d4) * (d13 - d4) <= 0.0) || !((d11 = d13 == d15 ? (d12 > d14 ? d12 : d14) : d14 - (d14 - d12) * (d15 - d4) / (d15 - d13)) > d)) continue;
            d = d11;
        }
        if (d == d2) {
            return false;
        }
        this.circleX = 0.5 * (d + d2);
        this.circleY = d4;
        return true;
    }

    void eatFace(int n, int n2) {
        this.obsolete[n] = true;
        if (n2 > this.maxDepth) {
            System.out.println("warnging: reached max depth in eatFace!");
            return;
        }
        int n3 = 3 * n;
        int n4 = this.neighbor[n3];
        int n5 = this.neighbor[n3 + 1];
        int n6 = this.neighbor[n3 + 2];
        boolean bl = this.segment[n3++];
        boolean bl2 = this.segment[n3++];
        boolean bl3 = this.segment[n3++];
        if (!bl && n4 >= 0 && !this.obsolete[n4]) {
            this.eatFace(n4, n2 + 1);
        }
        if (!bl2 && n5 >= 0 && !this.obsolete[n5]) {
            this.eatFace(n5, n2 + 1);
        }
        if (!bl3 && n6 >= 0 && !this.obsolete[n6]) {
            this.eatFace(n6, n2 + 1);
        }
    }

    void checkBoundary(double[][] dArray) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = dArray[i].length / 2;
            for (int j = 0; j < n2; ++j) {
                int n3;
                int n4 = i;
                int n5 = j;
                double d = dArray[i][2 * j];
                double d2 = dArray[i][2 * j + 1];
                double d3 = dArray[i][2 * ((j + 1) % n2)];
                double d4 = dArray[i][2 * ((j + 1) % n2) + 1];
                if (j < n2 - 2) {
                    for (n3 = j + 2; n3 < n2 && (n3 != n2 || j != 0); ++n3) {
                        if (!this.edgesCross(d, d2, d3, d4, dArray[i][2 * n3], dArray[i][2 * n3 + 1], dArray[i][2 * ((n3 + 1) % n2)], dArray[i][2 * ((n3 + 1) % n2) + 1])) continue;
                        throw new RuntimeException("boundary semengts must not intersect !\n " + n5 + "th and " + n3 + "th segment of " + n4 + "th component");
                    }
                }
                if (i >= n - 1) continue;
                n3 = dArray[i + 1].length / 2;
                for (int k = 0; k < n3; ++k) {
                    if (!this.edgesCross(d, d2, d3, d4, dArray[i + 1][2 * k], dArray[i + 1][2 * k + 1], dArray[i + 1][2 * ((k + 1) % n3)], dArray[i + 1][2 * ((k + 1) % n3) + 1])) continue;
                    throw new RuntimeException("boundary semengts must not intersect !\n " + n5 + "th segment of " + n4 + "th component and " + k + "th segment of " + i + "th component");
                }
            }
        }
    }

    boolean edgesCross(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = d3 - d;
        double d10 = d4 - d2;
        double d11 = d7 - d5;
        double d12 = d8 - d6;
        double d13 = d5 - d;
        double d14 = d6 - d2;
        double d15 = d7 - d;
        double d16 = d8 - d2;
        double d17 = d - d5;
        double d18 = d2 - d6;
        double d19 = d3 - d5;
        double d20 = d4 - d6;
        if ((d9 * d14 - d10 * d13) * (d9 * d16 - d10 * d15) > -1.0E-12) {
            return false;
        }
        return !((d11 * d18 - d12 * d17) * (d11 * d20 - d12 * d19) >= -1.0E-12);
    }
}

