/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.results;

import de.jstacs.DataType;
import de.jstacs.Storable;
import de.jstacs.classifiers.AbstractClassifier;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.Result;
import de.jstacs.sequenceScores.SequenceScore;

public class StorableResult
extends Result {
    public static final byte NA = -1;
    public static final byte FALSE = 0;
    public static final byte TRUE = 1;
    private Storable object;

    public StorableResult(String name, String comment, Storable object) {
        super(name, comment, DataType.STORABLE);
        this.object = object;
    }

    public StorableResult(StringBuffer buf) throws NonParsableException {
        super(buf);
    }

    public byte isInitialized() {
        if (this.object instanceof SequenceScore) {
            return ((SequenceScore)this.object).isInitialized() ? (byte)1 : 0;
        }
        if (this.object instanceof AbstractClassifier) {
            return ((AbstractClassifier)this.object).isInitialized() ? (byte)1 : 0;
        }
        return -1;
    }

    public String getClassName() {
        return this.object.getClass().getName();
    }

    @Override
    public String getValue() {
        return this.object.toXML().toString();
    }

    public Storable getResultInstance() {
        return this.object;
    }

    @Override
    public String getXMLTag() {
        return "objectResult";
    }

    @Override
    protected void appendFurtherInfos(StringBuffer buf) {
        XMLParser.appendObjectWithTags(buf, this.object, "object");
    }

    @Override
    protected void extractFurtherInfos(StringBuffer representation) throws NonParsableException {
        this.object = XMLParser.extractObjectForTags(representation, "object", Storable.class);
    }

    public String toString() {
        return this.name + ":\n" + this.object.toXML() + "\n";
    }
}

