/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.tools.ui.cli;

import de.jstacs.DataType;
import de.jstacs.io.FileManager;
import de.jstacs.parameters.AbstractSelectionParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.results.savers.ResultSaver;
import de.jstacs.results.savers.ResultSaverLibrary;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolResult;
import de.jstacs.utils.Pair;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CLI {
    private JstacsTool[] tools;
    private boolean[] configureThreads;
    private ParameterSet[] toolParameters;
    private HashMap<Parameter, String>[] keyMap;

    public CLI(JstacsTool ... tools) {
        this((boolean[])null, tools);
    }

    public CLI(boolean[] configureThreads, JstacsTool ... tools) {
        this.configureThreads = configureThreads == null ? new boolean[tools.length] : configureThreads;
        this.tools = tools;
        this.toolParameters = new ParameterSet[tools.length];
        this.keyMap = new HashMap[tools.length];
        for (int i = 0; i < tools.length; ++i) {
            this.toolParameters[i] = tools[i].getToolParameters();
            this.keyMap[i] = new HashMap();
            this.addToKeyMap(this.keyMap[i], this.toolParameters[i]);
        }
    }

    private void addToKeyMap(HashMap<Parameter, String> hashMap, ParameterSet parameterSet) {
        for (int i = 0; i < parameterSet.getNumberOfParameters(); ++i) {
            String key;
            Parameter par = parameterSet.getParameterAt(i);
            if (par.getDatatype() != DataType.PARAMETERSET) {
                key = this.getKey(hashMap, par);
                hashMap.put(par, key);
                continue;
            }
            if (par instanceof AbstractSelectionParameter) {
                key = this.getKey(hashMap, par);
                hashMap.put(par, key);
                ParameterSet incoll = ((AbstractSelectionParameter)par).getParametersInCollection();
                for (int j = 0; j < incoll.getNumberOfParameters(); ++j) {
                    ParameterSetContainer cont = (ParameterSetContainer)incoll.getParameterAt(j);
                    this.addToKeyMap(hashMap, cont.getValue());
                }
                continue;
            }
            ParameterSet ps = (ParameterSet)par.getValue();
            this.addToKeyMap(hashMap, ps);
        }
    }

    private String getKey(HashMap<Parameter, String> hashMap, Parameter par) {
        Collection<String> valueSet2 = hashMap.values();
        LinkedList<String> valueSet = new LinkedList<String>(valueSet2);
        valueSet.add("outdir");
        valueSet.add("info");
        valueSet.add("threads");
        String parName = par.getName();
        String key = (parName.charAt(0) + "").toLowerCase();
        if (!valueSet.contains(key)) {
            return key;
        }
        String[] temp = parName.split("\\s");
        key = "";
        for (int i = 0; i < temp.length; ++i) {
            key = key + temp[i].charAt(0);
        }
        if (!valueSet.contains(key = key.toLowerCase())) {
            return key;
        }
        key = parName.replaceAll("[\\s=]", "");
        int k = 1;
        String temp2 = key;
        while (valueSet.contains(temp2)) {
            temp2 = key + k;
            ++k;
        }
        return key;
    }

    private int getToolIndex(String shortName) {
        for (int i = 0; i < this.tools.length; ++i) {
            if (!shortName.equals(this.tools[i].getShortName())) continue;
            return i;
        }
        return -1;
    }

    public void run(String[] args) throws Exception {
        SysProtocol protocol = new SysProtocol();
        String jar = "<name>.jar";
        try {
            File jarfile = new File(CLI.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            jar = jarfile.getName();
        }
        catch (Exception e) {
            // empty catch block
        }
        String outdir = ".";
        if (args.length == 0 && (this.tools.length > 1 || !this.tools[0].getToolParameters().hasDefaultOrIsSet()) || this.tools.length > 1 && this.getToolIndex(args[0]) < 0) {
            if (this.tools.length > 1) {
                System.err.println("Available tools:\n");
                for (int i = 0; i < this.tools.length; ++i) {
                    System.err.println("\t" + this.tools[i].getShortName() + " - " + this.tools[i].getToolName());
                }
                System.err.println();
                System.err.println("Syntax: java -jar " + jar + " <toolname> [<parameter=value> ...]\n");
                System.err.println("Further info about the tools is given with\n\tjava -jar " + jar + " <toolname> info\n");
                System.err.println("Tool parameters are listed with\n\tjava -jar " + jar + " <toolname>\n");
            } else {
                this.printToolParameters(0, protocol, outdir, 1);
            }
            return;
        }
        if (args.length > 1 && args[1].equals("info")) {
            int toolIndex = this.getToolIndex(args[0]);
            System.err.println("\n" + CLI.parse(this.tools[toolIndex].getHelpText()));
        } else {
            int toolIndex = this.tools.length == 1 ? 0 : this.getToolIndex(args[0]);
            Pair<String, Integer> pair = this.setToolParameters(this.configureThreads[toolIndex], this.tools.length == 1 ? 0 : 1, this.toolParameters[toolIndex], this.keyMap[toolIndex], args, protocol);
            outdir = pair.getFirstElement();
            int threads = pair.getSecondElement();
            if (!this.toolParameters[toolIndex].hasDefaultOrIsSet()) {
                System.err.println("At least one parameter has not been set (correctly):\n");
                this.printToolParameters(toolIndex, protocol, outdir, threads);
                return;
            }
            this.printToolParameters(toolIndex, protocol, outdir, threads);
            protocol.flush();
            ToolResult results = this.tools[toolIndex].run(this.toolParameters[toolIndex], protocol, new ProgressUpdater(), threads);
            ResultSaver<?> saver = ResultSaverLibrary.getSaver(results.getClass());
            saver.writeOutput(results, new File(outdir));
            String prefix = outdir + File.separator + "protocol_" + this.tools[toolIndex].getShortName();
            File protout = new File(prefix + ".txt");
            int k = 1;
            while (protout.exists()) {
                protout = new File(prefix + "_" + k + ".txt");
                ++k;
            }
            FileManager.writeFile(protout, (CharSequence)protocol.getLog());
        }
    }

    private Pair<String, Integer> setToolParameters(boolean configureThreads, int off, ParameterSet parameterSet, HashMap<Parameter, String> hashMap, String[] args, Protocol protocol) throws SimpleParameter.IllegalValueException {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        String outdir = ".";
        int threads = 1;
        boolean newLine = false;
        for (int i = off; i < args.length; ++i) {
            int idx = args[i].indexOf("=");
            if (idx < 0) {
                throw new SimpleParameter.IllegalValueException("Parameter mis-specified in: " + args[i]);
            }
            String[] temp = new String[]{args[i].substring(0, idx), args[i].substring(idx + 1)};
            if ("outdir".equals(temp[0])) {
                outdir = temp[1];
                continue;
            }
            if (configureThreads && "threads".equals(temp[0])) {
                threads = Integer.parseInt(temp[1]);
                continue;
            }
            String v = valueMap.get(temp[0]);
            if (v != null) {
                protocol.appendWarning("Overwriting parameter: " + temp[0] + "=" + v + "\n");
                newLine = true;
            }
            valueMap.put(temp[0], temp[1]);
        }
        if (newLine) {
            protocol.append("\n");
        }
        this.set(parameterSet, hashMap, valueMap);
        if (valueMap.size() > 0) {
            throw new SimpleParameter.IllegalValueException("Unknown parameters: " + valueMap);
        }
        return new Pair<String, Integer>(outdir, threads);
    }

    private void set(ParameterSet parameters, HashMap<Parameter, String> hashMap, HashMap<String, String> valueMap) throws SimpleParameter.IllegalValueException {
        for (int i = 0; i < parameters.getNumberOfParameters(); ++i) {
            String value;
            String key;
            Parameter par = parameters.getParameterAt(i);
            if (par.getDatatype() != DataType.PARAMETERSET) {
                key = hashMap.get(par);
                value = valueMap.remove(key);
                if (value == null) continue;
                par.setValue(value);
                continue;
            }
            if (par instanceof AbstractSelectionParameter) {
                key = hashMap.get(par);
                value = valueMap.remove(key);
                if (value == null) continue;
                par.setValue(value);
                ParameterSet set = (ParameterSet)par.getValue();
                this.set(set, hashMap, valueMap);
                continue;
            }
            ParameterSet ps = (ParameterSet)par.getValue();
            this.set(ps, hashMap, valueMap);
        }
    }

    private void print(HashMap<Parameter, String> keyMap, ParameterSet parameters, String tabPrefix, Protocol protocol) {
        for (int i = 0; i < parameters.getNumberOfParameters(); ++i) {
            Parameter par = parameters.getParameterAt(i);
            if (par.getDatatype() != DataType.PARAMETERSET) {
                protocol.appendWarning(tabPrefix + keyMap.get(par) + " - " + par.toString() + "\n");
                continue;
            }
            if (par instanceof AbstractSelectionParameter) {
                protocol.appendWarning(tabPrefix + keyMap.get(par) + " - " + par.toString() + "\n");
                ParameterSet incoll = ((AbstractSelectionParameter)par).getParametersInCollection();
                char[] array = new char[keyMap.get(par).length() + 3];
                Arrays.fill(array, ' ');
                String off = tabPrefix + new String(array);
                for (int j = 0; j < incoll.getNumberOfParameters(); ++j) {
                    ParameterSetContainer cont = (ParameterSetContainer)incoll.getParameterAt(j);
                    if (cont.getValue().getNumberOfParameters() > 0) {
                        protocol.appendWarning(off + "Parameters for selection \"" + cont.getName() + "\":\n");
                        this.print(keyMap, cont.getValue(), off + "\t", protocol);
                        continue;
                    }
                    protocol.appendWarning(off + "No parameters for selection \"" + cont.getName() + "\"\n");
                }
                continue;
            }
            ParameterSet ps = (ParameterSet)par.getValue();
            this.print(keyMap, ps, tabPrefix + "\t", protocol);
        }
    }

    private void printTable(HashMap<Parameter, String> keyMap, ParameterSet parameters, PrintStream out) {
        for (int i = 0; i < parameters.getNumberOfParameters(); ++i) {
            Parameter par = parameters.getParameterAt(i);
            if (par.getDatatype() == DataType.PARAMETERSET && !(par instanceof AbstractSelectionParameter)) {
                ParameterSet ps = (ParameterSet)par.getValue();
                this.printTable(keyMap, ps, out);
                continue;
            }
            out.append("<tr style=\"vertical-align:top\">\n<td><font color=\"green\">" + keyMap.get(par) + "</font></td>\n");
            String s = par.toString();
            out.append("<td>" + s.substring(0, s.lastIndexOf(")\t= ") + 1));
            if (par.getDatatype() != DataType.PARAMETERSET) {
                out.append("</td>\n<td>" + (Object)((Object)par.getDatatype()) + "</td>\n</tr>\n");
                continue;
            }
            out.append("<table border=0 cellpadding=10 align=\"center\">\n");
            ParameterSet incoll = ((AbstractSelectionParameter)par).getParametersInCollection();
            for (int j = 0; j < incoll.getNumberOfParameters(); ++j) {
                ParameterSetContainer cont = (ParameterSetContainer)incoll.getParameterAt(j);
                if (cont.getValue().getNumberOfParameters() > 0) {
                    out.append("Parameters for selection &quot;" + cont.getName() + "&quot;:<br/>\n");
                    this.printTable(keyMap, cont.getValue(), out);
                    continue;
                }
                out.append("No parameters for selection &quot;" + cont.getName() + "&quot;<br/>\n");
            }
            out.append("</table></td><td></td>\n</tr>\n");
        }
    }

    private void printToolParameters(int toolIndex, Protocol protocol, String outdir, int threads) {
        ParameterSet ps = this.toolParameters[toolIndex];
        if (this.tools.length > 1) {
            protocol.appendWarning("Parameters of tool \"" + this.tools[toolIndex].getToolName() + "\" (" + this.tools[toolIndex].getShortName() + ", version: " + this.tools[toolIndex].getToolVersion() + "):\n");
        } else {
            protocol.appendWarning("Parameters of " + this.tools[toolIndex].getToolName() + ":\n");
        }
        this.print(this.keyMap[toolIndex], ps, "", protocol);
        protocol.appendWarning("outdir - The output directory, defaults to the current working directory (.)\t= " + outdir + "\n");
        if (this.configureThreads[toolIndex]) {
            protocol.appendWarning("threads - The number of threads used for the tool, defaults to 1\t= " + threads + "\n");
        }
    }

    private static String parse(String restruct) {
        int i;
        String[] lines = restruct.split("\n");
        Pattern bold = Pattern.compile("\\*\\*(.+?)\\*\\*");
        Pattern italics = Pattern.compile("\\*(.+?)\\*");
        Pattern tt = Pattern.compile("\\`\\`(.+?)\\`\\`");
        Pattern link = Pattern.compile("^\\.\\.\\s+\\_(.*?)\\s*\\:\\s*(.*)$");
        HashMap<Pattern, String> linkTargets = new HashMap<Pattern, String>();
        for (i = 0; i < lines.length; ++i) {
            Matcher m = bold.matcher(lines[i]);
            lines[i] = m.replaceAll("\u00a7$1\u00a7");
            m = italics.matcher(lines[i]);
            lines[i] = m.replaceAll("'$1'");
            lines[i] = lines[i].replaceAll("\u00a7", "*");
            m = tt.matcher(lines[i]);
            lines[i] = m.replaceAll("$1");
            m = link.matcher(lines[i]);
            if (!m.matches()) continue;
            String key = m.group(1);
            String target = m.group(2);
            linkTargets.put(Pattern.compile("\\`?(" + key + ")\\`?\\_"), target);
            lines[i] = "";
        }
        for (i = 0; i < lines.length; ++i) {
            Set pats = linkTargets.keySet();
            for (Pattern pat : pats) {
                Matcher m = pat.matcher(lines[i]);
                lines[i] = m.replaceAll("$1 (" + (String)linkTargets.get(pat) + ")");
            }
        }
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < lines.length; ++i2) {
            sb.append(lines[i2]);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static class SysProtocol
    implements Protocol {
        private StringBuffer log = new StringBuffer();

        @Override
        public void append(String str) {
            System.out.print(str);
            this.log.append(str);
        }

        @Override
        public void appendHeading(String heading) {
            System.out.print("* " + heading);
            this.log.append("* " + heading);
        }

        @Override
        public void appendWarning(String warning) {
            System.err.print(warning);
            this.log.append(warning);
        }

        public StringBuffer getLog() {
            return this.log;
        }

        @Override
        public void appendThrowable(Throwable th) {
            StringWriter str = new StringWriter();
            th.printStackTrace(new PrintWriter(str));
            String strstr = str.toString();
            System.err.println(strstr);
            this.log.append(strstr);
        }

        @Override
        public void appendVerbatim(String verbatim) {
            this.append(verbatim);
        }

        @Override
        public void flush() {
            System.err.flush();
            System.out.flush();
        }
    }
}

