/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.tools.ui.galaxy;

import de.jstacs.parameters.ParameterSet;
import de.jstacs.results.DataSetResult;
import de.jstacs.results.ListResult;
import de.jstacs.results.PlotGeneratorResult;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.results.ResultSetResult;
import de.jstacs.results.StorableResult;
import de.jstacs.results.TextResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.ui.galaxy.GalaxyAdaptor;
import de.jstacs.utils.Pair;
import de.jstacs.utils.graphics.PDFAdaptor;
import de.jstacs.utils.graphics.RasterizedAdaptor;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;

public class Galaxy {
    private JstacsTool[] tools;
    private ParameterSet[] toolParameters;
    private JstacsTool.ResultEntry[][] defaultResults;
    private boolean[][] addLine;
    private String vmargs;
    private boolean configThreads;

    public Galaxy(String vmargs, boolean configThreads, JstacsTool ... tools) {
        this.tools = tools;
        this.vmargs = vmargs;
        if (this.vmargs == null) {
            this.vmargs = "";
        } else if (this.vmargs.length() != 0) {
            this.vmargs = " " + this.vmargs;
        }
        this.configThreads = configThreads;
        this.toolParameters = new ParameterSet[tools.length];
        this.addLine = new boolean[tools.length][];
        this.defaultResults = new JstacsTool.ResultEntry[tools.length][];
        for (int i = 0; i < tools.length; ++i) {
            this.toolParameters[i] = tools[i].getToolParameters();
            this.defaultResults[i] = tools[i].getDefaultResultInfos();
            this.addLine[i] = new boolean[this.toolParameters[i].getNumberOfParameters()];
        }
    }

    private int getToolIndex(String shortName) {
        for (int i = 0; i < this.tools.length; ++i) {
            if (!shortName.equals(this.tools[i].getShortName())) continue;
            return i;
        }
        return -1;
    }

    public void run(String[] args) throws Exception {
        File jarfile = new File(Galaxy.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
        String jar = jarfile.getAbsolutePath();
        if ("--create".equals(args[0])) {
            for (int i = 0; i < this.tools.length; ++i) {
                String name = this.tools[i].getShortName();
                String command = "java" + this.vmargs + " -jar " + jar + " " + name;
                GalaxyAdaptor ga = new GalaxyAdaptor(this.toolParameters[i], this.defaultResults[i], this.addLine[i], this.tools[i].getToolName(), this.tools[i].getDescription(), this.tools[i].getToolVersion(), command, "jobname");
                ga.setHelp(this.tools[i].getHelpText());
                ga.parse(new String[]{"--create", name + ".xml"}, this.configThreads);
            }
        } else {
            String toolname = args[0];
            int idx = this.getToolIndex(toolname);
            String[] args2 = new String[args.length - 1];
            System.arraycopy(args, 1, args2, 0, args2.length);
            String name = this.tools[idx].getShortName();
            String command = "java" + this.vmargs + " -jar " + jar + " " + name;
            GalaxyAdaptor ga = new GalaxyAdaptor(this.toolParameters[idx], this.defaultResults[idx], this.addLine[idx], this.tools[idx].getToolName(), this.tools[idx].getDescription(), this.tools[idx].getToolVersion(), command, "jobname");
            ga.setHelp(this.tools[idx].getHelpText());
            ga.parse(args2, this.configThreads);
            GalaxyAdaptor.Protocol protocol = ga.getProtocol(false);
            ProgressUpdater progress = new ProgressUpdater();
            ResultSet ress = this.tools[idx].run(this.toolParameters[idx], protocol, progress, ga.getThreads()).getRawResult()[0];
            Pair<Result, boolean[]>[] temp = Galaxy.flatten(ress);
            HashSet<String> names = new HashSet<String>();
            for (int i = 0; i < temp.length; ++i) {
                String mime;
                Result res = temp[i].getFirstElement();
                boolean export = temp[i].getSecondElement()[0];
                boolean includeInSummary = temp[i].getSecondElement()[1];
                String exportExtension = null;
                if (res instanceof TextResult && (mime = ((TextResult)res).getMime()) != null) {
                    String[] exts = mime.split("\\,");
                    exportExtension = exts[0];
                }
                if (res instanceof PlotGeneratorResult) {
                    String filename;
                    PlotGeneratorResult.PlotGenerator pg = ((PlotGeneratorResult)res).getValue();
                    RasterizedAdaptor rast = new RasterizedAdaptor("png");
                    pg.generatePlot(rast);
                    BufferedImage bi = rast.getImage();
                    PDFAdaptor pdf = new PDFAdaptor();
                    pg.generatePlot(pdf);
                    String temp2 = filename = res.getName().replaceAll("[\\s\\:\\/]", "_");
                    int j = 1;
                    while (names.contains(temp2)) {
                        temp2 = filename + "_" + j;
                        ++j;
                    }
                    filename = temp2;
                    names.add(filename);
                    filename = "./" + filename + ".pdf";
                    pdf.generateOutput(filename);
                    GalaxyAdaptor.FileResult link = new GalaxyAdaptor.FileResult(res.getName(), "PDF", filename);
                    GalaxyAdaptor.LinkedImageResult lir = new GalaxyAdaptor.LinkedImageResult(res.getName(), res.getComment(), bi, link);
                    res = lir;
                }
                ga.addResult(res, export, includeInSummary, exportExtension);
            }
            ga.writeOutput();
        }
    }

    private static Pair<Result, boolean[]>[] flatten(ResultSet ress) {
        LinkedList<Pair<Result, boolean[]>> all = new LinkedList<Pair<Result, boolean[]>>();
        for (int i = 0; i < ress.getNumberOfResults(); ++i) {
            boolean includeInSummary;
            boolean export;
            Result res = ress.getResultAt(i);
            boolean bl = export = res instanceof GalaxyAdaptor.FileResult || res instanceof DataSetResult || res instanceof StorableResult;
            if (res instanceof TextResult) {
                export = ((TextResult)res).getExport();
            }
            if (res instanceof ListResult) {
                export = ((ListResult)res).getExport();
            }
            boolean bl2 = includeInSummary = !export;
            if (res instanceof ResultSetResult) {
                Pair<Result, boolean[]>[] temp = Galaxy.flatten(((ResultSetResult)res).getRawResult()[0]);
                all.add(new Pair<GalaxyAdaptor.HeadResult, boolean[]>(new GalaxyAdaptor.HeadResult(res.getName(), res.getComment()), new boolean[]{false, true}));
                Collections.addAll(all, temp);
                continue;
            }
            all.add(new Pair<Result, boolean[]>(res, new boolean[]{export, includeInSummary}));
        }
        return all.toArray(new Pair[0]);
    }
}

