/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.math;

import org.biojava.bio.BioException;
import org.biojava.utils.math.ComputeObject;

public class BinarySearch {
    public static double solve(double min, double max, double tolerance, ComputeObject obj) throws BioException {
        double x1 = min;
        double y1 = obj.compute(min);
        double x2 = max;
        double y2 = obj.compute(max);
        if (y1 < 0.0 && y2 < 0.0) {
            throw new BioException("Illegal initial range limits.");
        }
        if (y1 > 0.0 && y2 > 0.0) {
            throw new BioException("Illegal initial range limits.");
        }
        while (Math.abs(x1 - x2) > tolerance) {
            double newX = 0.5 * (x1 + x2);
            double newY = obj.compute(newX);
            if (newY >= 0.0) {
                if (y1 >= 0.0) {
                    y1 = newY;
                    x1 = newX;
                    continue;
                }
                y2 = newY;
                x2 = newX;
                continue;
            }
            if (!(newY < 0.0)) continue;
            if (y1 >= 0.0) {
                y2 = newY;
                x2 = newX;
                continue;
            }
            y1 = newY;
            x1 = newX;
        }
        return 0.5 * (x1 + x2);
    }
}

