/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.biosql;

import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.db.biosql.BioSQLEntryChangeHub;
import org.biojava.bio.seq.db.biosql.BioSQLFeature;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceDB;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.IndexedChangeHub;

class BioSQLFeatureChangeHub
extends IndexedChangeHub {
    BioSQLSequenceDB seqDB;
    BioSQLEntryChangeHub entryHub;

    public BioSQLFeatureChangeHub(BioSQLSequenceDB seqDB, BioSQLEntryChangeHub entryHub) {
        this.seqDB = seqDB;
        this.entryHub = entryHub;
    }

    protected final boolean isMyChangeEvent(ChangeEvent cev, IndexedChangeHub.ListenerMemento lm) {
        ChangeType ct = cev.getType();
        return ct.isMatchingType(lm.type);
    }

    void firePreChange(ChangeEvent cev) throws ChangeVetoException {
        BioSQLFeature source = (BioSQLFeature)cev.getSource();
        Integer bioentry_id = new Integer(source._getInternalID());
        super.firePreChange(bioentry_id, cev);
        FeatureHolder parent = source.getParent();
        ChangeEvent pcev = new ChangeEvent(parent, FeatureHolder.FEATURES, null, null, cev);
        if (parent instanceof Feature) {
            this.firePreChange(pcev);
        } else {
            this.entryHub.firePreChange(pcev);
        }
    }

    void firePostChange(ChangeEvent cev) {
        BioSQLFeature source = (BioSQLFeature)cev.getSource();
        Integer bioentry_id = new Integer(source._getInternalID());
        super.firePostChange(bioentry_id, cev);
        FeatureHolder parent = source.getParent();
        ChangeEvent pcev = new ChangeEvent(parent, FeatureHolder.FEATURES, null, null, cev);
        if (parent instanceof Feature) {
            this.firePostChange(pcev);
        } else {
            this.entryHub.firePostChange(pcev);
        }
    }
}

