/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.bio.Annotation;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.structure.AminoAcid;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.Compound;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.symbol.IllegalSymbolException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainImpl
implements Chain {
    public static String DEFAULT_CHAIN_ID = " ";
    String swissprot_id;
    String name = DEFAULT_CHAIN_ID;
    List<Group> groups = new ArrayList<Group>();
    Annotation annotation = Annotation.EMPTY_ANNOTATION;
    List<Group> seqResGroups = new ArrayList<Group>();
    private Long id;
    Compound mol;
    Structure parent;
    Map<String, Integer> pdbResnumMap = new HashMap<String, Integer>();

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public void setParent(Structure parent) {
        this.parent = parent;
    }

    @Override
    public Structure getParent() {
        return this.parent;
    }

    @Override
    public Object clone() {
        ChainImpl n = new ChainImpl();
        n.setName(this.getName());
        n.setSwissprotId(this.getSwissprotId());
        for (int i = 0; i < this.groups.size(); ++i) {
            Group g = this.groups.get(i);
            n.addGroup((Group)g.clone());
        }
        n.setHeader(this.getHeader());
        return n;
    }

    @Override
    public void setAnnotation(Annotation anno) {
        this.annotation = anno;
    }

    @Override
    public Annotation getAnnotation() {
        return this.annotation;
    }

    @Override
    public void setHeader(Compound mol) {
        this.mol = mol;
    }

    @Override
    public Compound getHeader() {
        return this.mol;
    }

    @Override
    public void setSwissprotId(String sp_id) {
        this.swissprot_id = sp_id;
    }

    @Override
    public String getSwissprotId() {
        return this.swissprot_id;
    }

    @Override
    public void addGroup(Group group) {
        group.setParent(this);
        this.groups.add(group);
        String pdbResnum = group.getPDBCode();
        if (pdbResnum != null) {
            Integer pos = new Integer(this.groups.size() - 1);
            if (this.pdbResnumMap.containsKey(pdbResnum)) {
                if (group instanceof AminoAcid) {
                    this.pdbResnumMap.put(pdbResnum, pos);
                }
            } else {
                this.pdbResnumMap.put(pdbResnum, pos);
            }
        }
    }

    @Override
    public Group getGroup(int position) {
        return this.groups.get(position);
    }

    @Override
    public Group getAtomGroup(int position) {
        return this.groups.get(position);
    }

    @Override
    public List<Group> getGroups(String type) {
        return this.getAtomGroups(type);
    }

    @Override
    public List<Group> getAtomGroups(String type) {
        ArrayList<Group> tmp = new ArrayList<Group>();
        for (int i = 0; i < this.groups.size(); ++i) {
            Group g = this.groups.get(i);
            if (!g.getType().equals(type)) continue;
            tmp.add(g);
        }
        return tmp;
    }

    @Override
    public List<Group> getGroups() {
        return this.groups;
    }

    @Override
    public List<Group> getAtomGroups() {
        return this.groups;
    }

    public void setAtomGroups(List<Group> groups) {
        for (Group g : groups) {
            g.setParent(this);
        }
        this.groups = groups;
    }

    @Override
    public Group[] getGroupsByPDB(String pdbresnumStart, String pdbresnumEnd, boolean ignoreMissing) throws StructureException {
        if (!ignoreMissing) {
            return this.getGroupsByPDB(pdbresnumStart, pdbresnumEnd);
        }
        ArrayList<Group> retlst = new ArrayList<Group>();
        int startPos = Integer.MIN_VALUE;
        int endPos = Integer.MAX_VALUE;
        boolean doIntCheck = true;
        try {
            startPos = Integer.parseInt(pdbresnumStart);
            endPos = Integer.parseInt(pdbresnumEnd);
        }
        catch (Exception e) {
            doIntCheck = false;
        }
        boolean adding = false;
        boolean foundStart = false;
        for (Group g : this.groups) {
            int pos;
            if (g.getPDBCode().equals(pdbresnumStart)) {
                adding = true;
                foundStart = true;
            }
            if (!(foundStart && adding || !doIntCheck)) {
                try {
                    pos = Integer.parseInt(g.getPDBCode());
                    if (pos >= startPos) {
                        foundStart = true;
                        adding = true;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (adding) {
                retlst.add(g);
            }
            if (g.getPDBCode().equals(pdbresnumEnd)) {
                if (!adding) {
                    throw new StructureException("did not find start PDB residue number " + pdbresnumStart + " in chain " + this.name);
                }
                adding = false;
                break;
            }
            if (!doIntCheck || !adding) continue;
            try {
                pos = Integer.parseInt(g.getPDBCode());
                if (pos < endPos) continue;
                adding = false;
                break;
            }
            catch (Exception e) {
            }
        }
        if (!foundStart) {
            throw new StructureException("did not find start PDB residue number " + pdbresnumStart + " in chain " + this.name);
        }
        return retlst.toArray(new Group[retlst.size()]);
    }

    @Override
    public Group getGroupByPDB(String pdbresnum) throws StructureException {
        if (this.pdbResnumMap.containsKey(pdbresnum)) {
            Integer pos = this.pdbResnumMap.get(pdbresnum);
            return this.groups.get(pos);
        }
        throw new StructureException("unknown PDB residue number " + pdbresnum + " in chain " + this.name);
    }

    @Override
    public Group[] getGroupsByPDB(String pdbresnumStart, String pdbresnumEnd) throws StructureException {
        ArrayList<Group> retlst = new ArrayList<Group>();
        Iterator<Group> iter = this.groups.iterator();
        boolean adding = false;
        boolean foundStart = false;
        while (iter.hasNext()) {
            Group g = iter.next();
            if (g.getPDBCode().equals(pdbresnumStart)) {
                adding = true;
                foundStart = true;
            }
            if (adding) {
                retlst.add(g);
            }
            if (!g.getPDBCode().equals(pdbresnumEnd)) continue;
            if (!adding) {
                throw new StructureException("did not find start PDB residue number " + pdbresnumStart + " in chain " + this.name);
            }
            adding = false;
            break;
        }
        if (!foundStart) {
            throw new StructureException("did not find start PDB residue number " + pdbresnumStart + " in chain " + this.name);
        }
        if (adding) {
            throw new StructureException("did not find end PDB residue number " + pdbresnumEnd + " in chain " + this.name);
        }
        return retlst.toArray(new Group[retlst.size()]);
    }

    @Override
    public int getLength() {
        return this.getAtomLength();
    }

    @Override
    public int getLengthAminos() {
        List<Group> g = this.getAtomGroups("amino");
        return g.size();
    }

    @Override
    public int getSeqResLength() {
        return this.seqResGroups.size();
    }

    @Override
    public void setName(String nam) {
        this.name = nam;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        String newline = System.getProperty("line.separator");
        StringBuffer str = new StringBuffer();
        str.append("Chain >" + this.getName() + "<" + newline);
        if (this.mol != null && this.mol.getMolName() != null) {
            str.append(this.mol.getMolName() + newline);
        }
        str.append("total SEQRES length: " + this.getSeqResGroups().size() + " total ATOM length:" + this.getAtomLength() + " residues " + newline);
        for (int i = 0; i < this.seqResGroups.size(); ++i) {
            Group gr = this.seqResGroups.get(i);
            str.append(gr.toString() + newline);
        }
        return str.toString();
    }

    @Override
    public Sequence getBJSequence() throws IllegalSymbolException {
        String seq = this.getSeqResSequence();
        String name = "";
        if (this.getParent() != null) {
            name = this.getParent().getPDBCode();
        }
        name = name + "." + this.getName();
        return ProteinTools.createProteinSequence(seq, name);
    }

    @Override
    public String getSequence() {
        return this.getAtomSequence();
    }

    @Override
    public String getAtomSequence() {
        List<Group> aminos = this.getAtomGroups("amino");
        StringBuffer sequence = new StringBuffer();
        for (int i = 0; i < aminos.size(); ++i) {
            AminoAcid a = (AminoAcid)aminos.get(i);
            sequence.append(a.getAminoType());
        }
        return sequence.toString();
    }

    @Override
    public String getSeqResSequence() {
        StringBuffer str = new StringBuffer();
        for (Group group : this.seqResGroups) {
            if (!(group instanceof AminoAcid)) continue;
            AminoAcid aa = (AminoAcid)group;
            str.append(aa.getAminoType());
        }
        return str.toString();
    }

    @Override
    public Group getSeqResGroup(int position) {
        return this.seqResGroups.get(position);
    }

    @Override
    public List<Group> getSeqResGroups(String type) {
        return this.seqResGroups;
    }

    @Override
    public List<Group> getSeqResGroups() {
        return this.seqResGroups;
    }

    @Override
    public void setSeqResGroups(List<Group> groups) {
        for (Group g : groups) {
            g.setParent(this);
        }
        this.seqResGroups = groups;
    }

    @Override
    public int getAtomLength() {
        return this.groups.size();
    }
}

