/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.phylo.io.nexus;

import java.util.HashMap;
import java.util.Map;
import org.biojava.bio.seq.io.ParseException;
import org.biojavax.bio.phylo.io.nexus.NexusBlockListener;
import org.biojavax.bio.phylo.io.nexus.NexusBlockParser;

public interface NexusFileListener {
    public void startFile();

    public void endFile();

    public void beginComment();

    public void commentText(String var1) throws ParseException;

    public void endComment();

    public void endTokenGroup();

    public void setDefaultBlockParsers();

    public void setBlockParser(String var1, NexusBlockParser var2);

    public NexusBlockParser getBlockParser(String var1);

    public void startBlock(String var1);

    public void endBlock();

    public void parseToken(String var1) throws ParseException;

    public boolean wantsBracketsAndBraces();

    public static abstract class Abstract
    implements NexusFileListener {
        private static final NexusBlockParser ignoreUnknownBlocks = new NexusBlockParser.Abstract(new NexusBlockListener(){

            public void beginComment() {
            }

            public void commentText(String comment) throws ParseException {
            }

            public void endBlock() {
            }

            public void endComment() {
            }

            public void endTokenGroup() {
            }

            public void startBlock(String blockName) {
            }
        }){

            public void resetStatus() {
            }

            public void parseToken(String token) throws ParseException {
            }
        };
        private Map blockParsers = new HashMap();
        private NexusBlockParser blockParser;

        public Abstract() {
            this.setDefaultBlockParsers();
        }

        public void beginComment() {
            if (this.blockParser != null) {
                this.blockParser.beginComment();
            } else {
                this.beginFileComment();
            }
        }

        protected abstract void beginFileComment();

        public void commentText(String comment) throws ParseException {
            if (this.blockParser != null) {
                this.blockParser.commentText(comment);
            } else {
                this.fileCommentText(comment);
            }
        }

        protected abstract void fileCommentText(String var1);

        public void endComment() {
            if (this.blockParser != null) {
                this.blockParser.endComment();
            } else {
                this.endFileComment();
            }
        }

        protected abstract void endFileComment();

        public void endBlock() {
            this.blockParser.endBlock();
            this.blockEnded(this.blockParser);
            this.blockParser = null;
        }

        protected abstract void blockEnded(NexusBlockParser var1);

        public boolean wantsBracketsAndBraces() {
            return this.blockParser != null && this.blockParser.wantsBracketsAndBraces();
        }

        public void setDefaultBlockParsers() {
            this.setBlockParser("__UNKNOWN", ignoreUnknownBlocks);
        }

        public NexusBlockParser getBlockParser(String blockName) {
            this.blockParser = this.blockParsers.containsKey(blockName = blockName.toUpperCase()) ? (NexusBlockParser)this.blockParsers.get(blockName) : (NexusBlockParser)this.blockParsers.get("__UNKNOWN");
            return this.blockParser;
        }

        public void endTokenGroup() {
            if (this.blockParser != null) {
                this.blockParser.endTokenGroup();
            }
        }

        public void parseToken(String token) throws ParseException {
            if (this.blockParser != null) {
                this.blockParser.parseToken(token);
            }
        }

        public void setBlockParser(String blockName, NexusBlockParser parser) {
            this.blockParsers.put(blockName.toUpperCase(), parser);
        }

        public void startBlock(String blockName) {
            this.blockParser = this.getBlockParser(blockName);
            this.blockParser.startBlock(blockName);
        }
    }
}

