/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.impl.SimpleSequenceFactory;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.ReversibleTranslationTable;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolListViews;

public final class NucleotideTools {
    private static final ReversibleTranslationTable complementTable;
    private static final FiniteAlphabet nucleotide;
    private static final SymbolTokenization nucleotideTokens;
    private static final AtomicSymbol a;
    private static final AtomicSymbol g;
    private static final AtomicSymbol c;
    private static final AtomicSymbol t;
    private static final AtomicSymbol u;
    private static final Symbol r;
    private static final Symbol y;
    private static final Symbol m;
    private static final Symbol k;
    private static final Symbol s;
    private static final Symbol w;
    private static final Symbol b;
    private static final Symbol d;
    private static final Symbol h;
    private static final Symbol v;
    private static final Symbol n;
    private static Map symbolToComplement;

    public static AtomicSymbol a() {
        return a;
    }

    public static AtomicSymbol g() {
        return g;
    }

    public static AtomicSymbol c() {
        return c;
    }

    public static AtomicSymbol t() {
        return t;
    }

    public static AtomicSymbol u() {
        return u;
    }

    public static Symbol r() {
        return r;
    }

    public static Symbol y() {
        return y;
    }

    public static Symbol m() {
        return m;
    }

    public static Symbol k() {
        return k;
    }

    public static Symbol s() {
        return s;
    }

    public static Symbol w() {
        return w;
    }

    public static Symbol b() {
        return b;
    }

    public static Symbol d() {
        return d;
    }

    public static Symbol h() {
        return h;
    }

    public static Symbol v() {
        return v;
    }

    public static Symbol n() {
        return n;
    }

    private NucleotideTools() {
    }

    public static FiniteAlphabet getNucleotide() {
        return nucleotide;
    }

    public static SymbolList createNucleotide(String nucleotide) throws IllegalSymbolException {
        try {
            SymbolTokenization p = NucleotideTools.getNucleotide().getTokenization("token");
            return new SimpleSymbolList(p, nucleotide);
        }
        catch (BioException se) {
            throw new BioError("Something has gone badly wrong with Nucleotide", se);
        }
    }

    public static Sequence createNucleotideSequence(String nucleotide, String name) throws IllegalSymbolException {
        try {
            return new SimpleSequenceFactory().createSequence(NucleotideTools.createNucleotide(nucleotide), "", name, new SimpleAnnotation());
        }
        catch (BioException se) {
            throw new BioError("Something has gone badly wrong with Nucleotide", se);
        }
    }

    public static int index(Symbol sym) throws IllegalSymbolException {
        if (sym == a) {
            return 0;
        }
        if (sym == g) {
            return 1;
        }
        if (sym == c) {
            return 2;
        }
        if (sym == t) {
            return 3;
        }
        if (sym == u) {
            return 4;
        }
        NucleotideTools.getNucleotide().validate(sym);
        throw new IllegalSymbolException("Really confused. Can't find index for " + sym.getName());
    }

    public static Symbol forIndex(int index) throws IndexOutOfBoundsException {
        if (index == 0) {
            return a;
        }
        if (index == 1) {
            return g;
        }
        if (index == 2) {
            return c;
        }
        if (index == 3) {
            return t;
        }
        if (index == 4) {
            return u;
        }
        throw new IndexOutOfBoundsException("No symbol for index " + index);
    }

    public static Symbol complement(Symbol sym) throws IllegalSymbolException {
        if (sym == a) {
            return t;
        }
        if (sym == g) {
            return c;
        }
        if (sym == c) {
            return g;
        }
        if (sym == t) {
            return a;
        }
        if (sym == u) {
            return a;
        }
        Symbol s = (Symbol)symbolToComplement.get(sym);
        if (s != null) {
            return s;
        }
        NucleotideTools.getNucleotide().validate(sym);
        throw new BioError("Really confused. Can't find symbol " + sym.getName());
    }

    public static Symbol forSymbol(char token) throws IllegalSymbolException {
        if (token == 'a') {
            return a;
        }
        if (token == 'g') {
            return g;
        }
        if (token == 'c') {
            return c;
        }
        if (token == 't') {
            return t;
        }
        if (token == 'u') {
            return u;
        }
        throw new IllegalSymbolException("Unable to find symbol for token " + token);
    }

    public static SymbolList complement(SymbolList list) throws IllegalAlphabetException {
        return SymbolListViews.translate(list, NucleotideTools.complementTable());
    }

    public static SymbolList reverseComplement(SymbolList list) throws IllegalAlphabetException {
        return SymbolListViews.translate(SymbolListViews.reverse(list), NucleotideTools.complementTable());
    }

    public static ReversibleTranslationTable complementTable() {
        return complementTable;
    }

    public static char nucleotideToken(Symbol sym) throws IllegalSymbolException {
        return nucleotideTokens.tokenizeSymbol(sym).charAt(0);
    }

    static {
        try {
            nucleotide = (FiniteAlphabet)AlphabetManager.alphabetForName("NUCLEOTIDE");
            nucleotideTokens = nucleotide.getTokenization("token");
            SimpleSymbolList syms = new SimpleSymbolList(nucleotideTokens, "agcturymkswbdhvn");
            a = (AtomicSymbol)syms.symbolAt(1);
            g = (AtomicSymbol)syms.symbolAt(2);
            c = (AtomicSymbol)syms.symbolAt(3);
            t = (AtomicSymbol)syms.symbolAt(4);
            u = (AtomicSymbol)syms.symbolAt(5);
            r = syms.symbolAt(6);
            y = syms.symbolAt(7);
            m = syms.symbolAt(8);
            k = syms.symbolAt(9);
            s = syms.symbolAt(10);
            w = syms.symbolAt(11);
            b = syms.symbolAt(12);
            d = syms.symbolAt(13);
            h = syms.symbolAt(14);
            v = syms.symbolAt(15);
            n = syms.symbolAt(16);
            symbolToComplement = new HashMap();
            Symbol gap = nucleotide.getGapSymbol();
            symbolToComplement.put(gap, gap);
            for (Symbol as : AlphabetManager.getAllSymbols(nucleotide)) {
                FiniteAlphabet matches = (FiniteAlphabet)as.getMatches();
                if (matches.size() <= 1) continue;
                HashSet<Symbol> l = new HashSet<Symbol>();
                Iterator<Symbol> j = matches.iterator();
                while (j.hasNext()) {
                    l.add(NucleotideTools.complement(j.next()));
                }
                symbolToComplement.put(as, nucleotide.getAmbiguity(l));
            }
            complementTable = new NucleotideComplementTranslationTable();
        }
        catch (Throwable t) {
            throw new BioError("Unable to initialize NucleotideTools", t);
        }
    }

    private static class NucleotideComplementTranslationTable
    implements ReversibleTranslationTable {
        private NucleotideComplementTranslationTable() {
        }

        public Symbol translate(Symbol s) throws IllegalSymbolException {
            return NucleotideTools.complement(s);
        }

        public Symbol untranslate(Symbol s) throws IllegalSymbolException {
            return NucleotideTools.complement(s);
        }

        public Alphabet getSourceAlphabet() {
            return NucleotideTools.getNucleotide();
        }

        public Alphabet getTargetAlphabet() {
            return NucleotideTools.getNucleotide();
        }
    }
}

