/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq.io;

import java.io.BufferedInputStream;
import java.util.NoSuchElementException;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.io.SeqIOTools;
import org.biojava.bio.symbol.Alphabet;
import org.biojavax.Namespace;
import org.biojavax.bio.BioEntry;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.RichSequenceIterator;
import org.biojavax.bio.seq.io.FastaFormat;
import org.biojavax.bio.seq.io.MyRichSeqIOListener;

public class HashedFastaIterator
implements RichSequenceIterator {
    Alphabet alpha;
    Namespace ns;
    SequenceDB db;
    FastaFormat format;
    SequenceIterator iterator;
    MyRichSeqIOListener listener;

    public HashedFastaIterator(BufferedInputStream is, Alphabet alpha, Namespace ns) throws BioException {
        this.db = SeqIOTools.readFasta(is, alpha);
        this.iterator = this.db.sequenceIterator();
        this.ns = ns;
        this.format = new FastaFormat();
        this.listener = new MyRichSeqIOListener();
        this.alpha = alpha;
    }

    public RichSequence nextRichSequence() throws NoSuchElementException, BioException {
        this.listener.startSequence();
        Sequence s = this.iterator.nextSequence();
        Annotation a = s.getAnnotation();
        if (a.containsProperty("description_line")) {
            try {
                this.format.processHeader(">" + a.getProperty("description_line"), this.listener, this.ns);
            }
            catch (Exception e) {
                throw new BioException(e);
            }
        }
        this.listener.setSymbolList(s);
        this.listener.endSequence();
        return this.listener.getCurrentSequence();
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public BioEntry nextBioEntry() throws NoSuchElementException, BioException {
        return this.nextRichSequence();
    }

    public Sequence nextSequence() throws NoSuchElementException, BioException {
        return this.iterator.nextSequence();
    }
}

