/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.ontology;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.biojava.ontology.AlreadyExistsException;
import org.biojava.ontology.DefaultOps;
import org.biojava.ontology.Ontology;
import org.biojava.ontology.OntologyOps;
import org.biojava.ontology.Term;
import org.biojava.ontology.Triple;
import org.biojava.ontology.Variable;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.ontology.ComparableOntology;
import org.biojavax.ontology.ComparableTerm;
import org.biojavax.ontology.ComparableTriple;
import org.biojavax.ontology.SimpleComparableTerm;
import org.biojavax.ontology.SimpleComparableTriple;

public class SimpleComparableOntology
extends AbstractChangeable
implements ComparableOntology {
    private String name;
    private String description;
    private Set terms = new TreeSet();
    private Map termsMap = new TreeMap();
    private Set triples = new TreeSet();
    private OntologyOps ops;
    private Integer id;

    public SimpleComparableOntology(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.name = name;
        this.description = null;
        this.ops = new DefaultOps(){

            public Set getRemoteTerms() {
                return Collections.EMPTY_SET;
            }
        };
    }

    protected SimpleComparableOntology() {
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        if (this.name == null) {
            return -1;
        }
        Ontology them = (Ontology)o;
        return this.name.compareTo(them.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Ontology)) {
            return false;
        }
        if (this.name == null) {
            return false;
        }
        Ontology them = (Ontology)obj;
        return this.name.equals(them.getName());
    }

    public int hashCode() {
        int hash = 17;
        if (this.name == null) {
            return hash;
        }
        return 31 * hash + this.name.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    public boolean containsTerm(String name) {
        return this.termsMap.containsKey(name);
    }

    public Term getTerm(String s) throws NoSuchElementException {
        if (!this.termsMap.containsKey(s)) {
            throw new NoSuchElementException("Ontology does not have term with name " + s);
        }
        return (ComparableTerm)this.termsMap.get(s);
    }

    public ComparableTerm getOrCreateTerm(String name) {
        try {
            if (!this.termsMap.containsKey(name)) {
                return (ComparableTerm)this.createTerm(name, "auto-generated by biojavax", null);
            }
            return (ComparableTerm)this.getTerm(name);
        }
        catch (ChangeVetoException e) {
            return null;
        }
        catch (AlreadyExistsException e) {
            return (ComparableTerm)this.getTerm(name);
        }
    }

    public ComparableTriple getOrCreateTriple(Term subject, Term object, Term predicate) {
        try {
            if (this.getTriples(subject, object, predicate).size() == 0) {
                return (ComparableTriple)this.createTriple(subject, object, predicate, predicate.getName() + "(" + subject.getName() + ", " + object.getName() + ")", null);
            }
            return (ComparableTriple)this.getTriples(subject, object, predicate).iterator().next();
        }
        catch (ChangeVetoException e) {
            return null;
        }
        catch (AlreadyExistsException e) {
            return (ComparableTriple)this.getTriples(subject, object, predicate).iterator().next();
        }
    }

    public ComparableTerm getOrImportTerm(Term term) {
        try {
            if (!this.termsMap.containsKey(term.getName())) {
                return (ComparableTerm)this.importTerm(term, term.getName());
            }
            return (ComparableTerm)this.getTerm(term.getName());
        }
        catch (ChangeVetoException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Term createTerm(String name, String description, Object[] synonyms) throws AlreadyExistsException, ChangeVetoException, IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (this.termsMap.containsKey(name)) {
            throw new AlreadyExistsException("Ontology already has term with this name");
        }
        SimpleComparableTerm ct = new SimpleComparableTerm(this, name, synonyms);
        ct.setDescription(description);
        if (!this.hasListeners(ComparableOntology.TERM)) {
            this.termsMap.put(name, ct);
            this.terms.add(ct);
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, ComparableOntology.TERM, ct, this.termsMap.get(name));
            ChangeSupport changeSupport = cs = this.getChangeSupport(ComparableOntology.TERM);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.termsMap.put(name, ct);
                this.terms.add(ct);
                cs.firePostChangeEvent(ce);
            }
        }
        return ct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Term importTerm(Term t, String localName) throws ChangeVetoException, IllegalArgumentException {
        if (localName == null) {
            localName = t.getName();
        }
        if (localName == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (this.termsMap.containsKey(localName)) {
            return (ComparableTerm)this.termsMap.get(localName);
        }
        SimpleComparableTerm ct = new SimpleComparableTerm(this, localName, t.getSynonyms());
        ct.setDescription(t.getDescription());
        if (!this.hasListeners(ComparableOntology.TERM)) {
            this.termsMap.put(localName, ct);
            this.terms.add(ct);
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, ComparableOntology.TERM, ct, this.termsMap.get(localName));
            ChangeSupport changeSupport = cs = this.getChangeSupport(ComparableOntology.TERM);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.termsMap.put(localName, ct);
                this.terms.add(ct);
                cs.firePostChangeEvent(ce);
            }
        }
        return ct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Triple createTriple(Term subject, Term object, Term predicate, String name, String description) throws AlreadyExistsException, ChangeVetoException {
        if (!(subject instanceof ComparableTerm)) {
            subject = this.getOrImportTerm(subject);
        }
        if (!(object instanceof ComparableTerm)) {
            object = this.getOrImportTerm(object);
        }
        if (!(predicate instanceof ComparableTerm)) {
            predicate = this.getOrImportTerm(predicate);
        }
        if (this.containsTriple(subject, object, predicate)) {
            throw new AlreadyExistsException("Ontology already has triple with this subject/object/predicate combination");
        }
        SimpleComparableTriple ct = new SimpleComparableTriple(this, (ComparableTerm)subject, (ComparableTerm)object, (ComparableTerm)predicate);
        if (!this.triples.contains(ct)) {
            if (!this.hasListeners(ComparableOntology.TRIPLE)) {
                this.triples.add(ct);
            } else {
                ChangeSupport cs;
                ChangeEvent ce = new ChangeEvent(this, ComparableOntology.TRIPLE, ct, null);
                ChangeSupport changeSupport = cs = this.getChangeSupport(ComparableOntology.TRIPLE);
                synchronized (changeSupport) {
                    cs.firePreChangeEvent(ce);
                    this.triples.add(ct);
                    cs.firePostChangeEvent(ce);
                }
            }
        }
        return ct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTerm(Term t) throws ChangeVetoException {
        Iterator i = this.triples.iterator();
        while (i.hasNext()) {
            ChangeSupport cs;
            ComparableTriple ct = (ComparableTriple)i.next();
            if (!ct.equals(t) && !ct.getSubject().equals(t) && !ct.getObject().equals(t) && !ct.getPredicate().equals(t)) continue;
            if (!this.hasListeners(ComparableOntology.TRIPLE)) {
                i.remove();
                continue;
            }
            ChangeEvent ce = new ChangeEvent(this, ComparableOntology.TRIPLE, null, ct);
            ChangeSupport changeSupport = cs = this.getChangeSupport(ComparableOntology.TRIPLE);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                i.remove();
                cs.firePostChangeEvent(ce);
            }
        }
        if (!this.hasListeners(ComparableOntology.TERM)) {
            if (t instanceof Triple) {
                this.triples.remove(t);
            } else {
                this.termsMap.remove(t.getName());
                this.terms.remove(t);
            }
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, ComparableOntology.TERM, null, t);
            ChangeSupport changeSupport = cs = this.getChangeSupport(ComparableOntology.TERM);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                if (t instanceof Triple) {
                    this.triples.remove(t);
                } else {
                    this.termsMap.remove(t.getName());
                    this.terms.remove(t);
                }
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public Set getTriples(Term subject, Term object, Term predicate) {
        TreeSet<ComparableTriple> results = new TreeSet<ComparableTriple>();
        for (ComparableTriple ct : this.triples) {
            if (subject != null && !ct.getSubject().equals(subject) || object != null && !ct.getObject().equals(object) || predicate != null && !ct.getPredicate().equals(predicate)) continue;
            results.add(ct);
        }
        return results;
    }

    public void setTripleSet(Set triples) throws ChangeVetoException {
        this.triples = triples;
    }

    public Set getTripleSet() {
        return this.triples;
    }

    public Set getTerms() {
        return new TreeSet(this.termsMap.values());
    }

    public void setTermSet(Set terms) throws ChangeVetoException {
        this.terms = terms;
        this.termsMap.clear();
        for (ComparableTerm t : this.terms) {
            this.termsMap.put(t.getName(), t);
        }
    }

    public Set getTermSet() {
        return this.terms;
    }

    public boolean containsTriple(Term subject, Term object, Term predicate) {
        for (ComparableTriple ct : this.triples) {
            if (!ct.getSubject().equals(subject) || !ct.getObject().equals(object) || !ct.getPredicate().equals(predicate)) continue;
            return true;
        }
        return false;
    }

    public Term createTerm(String name) throws AlreadyExistsException, ChangeVetoException, IllegalArgumentException {
        return this.createTerm(name, null, null);
    }

    public Term createTerm(String name, String description) throws AlreadyExistsException, ChangeVetoException, IllegalArgumentException {
        return this.createTerm(name, description, null);
    }

    public Variable createVariable(String name, String description) throws AlreadyExistsException, ChangeVetoException, IllegalArgumentException {
        throw new ChangeVetoException("BioSQL doesn't know what these are so we cowardly refuse to know too.");
    }

    public String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDescription(String description) throws ChangeVetoException {
        if (!this.hasListeners(ComparableOntology.DESCRIPTION)) {
            this.description = description;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, ComparableOntology.DESCRIPTION, description, this.description);
            ChangeSupport changeSupport = cs = this.getChangeSupport(ComparableOntology.DESCRIPTION);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.description = description;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OntologyOps getOps() {
        return this.ops;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }
}

