/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax;

import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.CrossRef;
import org.biojavax.RankedCrossRef;

public class SimpleRankedCrossRef
extends AbstractChangeable
implements RankedCrossRef {
    private CrossRef crossref;
    private int rank;

    public SimpleRankedCrossRef(CrossRef crossref, int rank) {
        if (crossref == null) {
            throw new IllegalArgumentException("Cross reference cannot be null");
        }
        this.crossref = crossref;
        this.rank = rank;
    }

    protected SimpleRankedCrossRef() {
    }

    void setCrossRef(CrossRef crossref) {
        this.crossref = crossref;
    }

    public CrossRef getCrossRef() {
        return this.crossref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRank(int rank) throws ChangeVetoException {
        if (rank == this.rank) {
            return;
        }
        if (!this.hasListeners(RankedCrossRef.RANK)) {
            this.rank = rank;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, RankedCrossRef.RANK, new Integer(rank), new Integer(this.rank));
            ChangeSupport changeSupport = cs = this.getChangeSupport(RankedCrossRef.RANK);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.rank = rank;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public int getRank() {
        return this.rank;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof RankedCrossRef)) {
            return false;
        }
        if (this.crossref == null) {
            return false;
        }
        RankedCrossRef them = (RankedCrossRef)obj;
        return this.rank == them.getRank() && this.crossref.equals(them.getCrossRef());
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        if (this.crossref == null) {
            return -1;
        }
        RankedCrossRef them = (RankedCrossRef)o;
        if (this.rank != them.getRank()) {
            return this.rank - them.getRank();
        }
        return this.crossref.compareTo(them.getCrossRef());
    }

    public int hashCode() {
        int code = 17;
        if (this.crossref == null) {
            return code;
        }
        code = 37 * code + this.crossref.hashCode();
        code = 37 * code + this.rank;
        return code;
    }

    public String toString() {
        return "(#" + this.rank + ") " + this.crossref;
    }
}

