/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.charts;

import java.awt.Color;
import javax.swing.JFrame;
import umontreal.iro.lecuyer.charts.XYLineChart;
import umontreal.iro.lecuyer.charts.XYListSeriesCollection;
import umontreal.iro.lecuyer.probdist.DiscreteDistributionInt;

public class DiscreteDistIntChart {
    protected DiscreteDistributionInt dist;
    protected int a;
    protected int b;
    protected XYLineChart cdfChart;
    protected XYLineChart probChart;

    public DiscreteDistIntChart(DiscreteDistributionInt dist) {
        this.dist = dist;
        this.a = 0;
        this.b = 0;
    }

    public DiscreteDistIntChart(DiscreteDistributionInt dist, int a, int b) {
        this.dist = dist;
        if (a >= b) {
            throw new IllegalArgumentException("a is bigger than b");
        }
        this.a = a;
        this.b = b;
        this.init();
    }

    private void init() {
        int m = this.b - this.a + 1;
        double[][] cdf = new double[2][m];
        double[][] probability = new double[2][m];
        for (int i = 0; i < m; ++i) {
            cdf[0][i] = i + this.a;
            cdf[1][i] = this.dist.cdf(i + this.a);
            probability[0][i] = i + this.a;
            probability[1][i] = this.dist.prob(i + this.a);
        }
        double[][] cdfFinal = new double[2][2 * (m - 1)];
        for (int i = 0; i < m - 1; ++i) {
            cdfFinal[0][2 * i] = cdf[0][i];
            cdfFinal[0][2 * i + 1] = cdf[0][i + 1];
            cdfFinal[1][2 * i] = cdf[1][i];
            cdfFinal[1][2 * i + 1] = cdf[1][i];
        }
        this.cdfChart = new XYLineChart("cdf:  " + this.dist.toString(), "", "", new double[][][]{cdfFinal});
        this.probChart = new XYLineChart("Probability:  " + this.dist.toString(), "", "", new double[][][]{probability});
        XYListSeriesCollection collec = this.cdfChart.getSeriesCollection();
        collec.setColor(0, Color.BLUE);
        collec.setPlotStyle(0, "thick");
        collec.setMarksType(0, "only marks");
        collec = this.probChart.getSeriesCollection();
        collec.setColor(0, Color.ORANGE);
        collec.setPlotStyle(0, "ycomb");
        collec.setMarksType(0, "*");
        collec.setDashPattern(0, "solid");
    }

    private void testParam() {
        if (this.a == 0 && this.b == 0) {
            double MEAN = this.dist.getMean();
            double SD = this.dist.getStandardDeviation();
            this.setParam((int)Math.round(MEAN - 3.0 * SD), (int)Math.round(MEAN + 3.0 * SD));
        }
    }

    public JFrame viewCdf(int width, int height) {
        this.testParam();
        return this.cdfChart.view(width, height);
    }

    public JFrame viewCdf(int width, int height, int a, int b) {
        this.setParam(a, b);
        return this.cdfChart.view(width, height);
    }

    public JFrame viewProb(int width, int height) {
        this.testParam();
        return this.probChart.viewBar(width, height);
    }

    public JFrame viewProb(int width, int height, int a, int b) {
        this.setParam(a, b);
        return this.probChart.viewBar(width, height);
    }

    public String toLatexCdf(int width, int height) {
        this.testParam();
        return this.cdfChart.toLatex(width, height);
    }

    public String toLatexProb(int width, int height) {
        this.testParam();
        return this.probChart.toLatex(width, height);
    }

    public void setParam(int a, int b) {
        if (a >= b) {
            throw new IllegalArgumentException("a is bigger than b" + a + "  " + b);
        }
        this.a = a;
        this.b = b;
        this.init();
    }

    public XYLineChart getCdf() {
        return this.cdfChart;
    }

    public XYLineChart getProb() {
        return this.probChart;
    }
}

