/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.assessment;

import de.jstacs.classifiers.AbstractClassifier;
import de.jstacs.classifiers.ClassDimensionException;
import de.jstacs.classifiers.assessment.ClassifierAssessment;
import de.jstacs.classifiers.assessment.RepeatedSubSamplingAssessParameterSet;
import de.jstacs.classifiers.performanceMeasures.NumericalPerformanceMeasureParameterSet;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.sequenceScores.statisticalModels.trainable.TrainableStatisticalModel;
import de.jstacs.utils.Pair;
import de.jstacs.utils.ProgressUpdater;

public class RepeatedSubSamplingExperiment
extends ClassifierAssessment<RepeatedSubSamplingAssessParameterSet> {
    protected RepeatedSubSamplingExperiment(AbstractClassifier[] aCs, TrainableStatisticalModel[][] aMs, boolean buildClassifiersByCrossProduct, boolean checkAlphabetConsistencyAndLength) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        super(aCs, aMs, buildClassifiersByCrossProduct, checkAlphabetConsistencyAndLength);
    }

    public RepeatedSubSamplingExperiment(AbstractClassifier ... aCs) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        super(aCs);
    }

    public RepeatedSubSamplingExperiment(boolean buildClassifiersByCrossProduct, TrainableStatisticalModel[] ... aMs) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        super(buildClassifiersByCrossProduct, aMs);
    }

    public RepeatedSubSamplingExperiment(AbstractClassifier[] aCs, boolean buildClassifiersByCrossProduct, TrainableStatisticalModel[] ... aMs) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        super(aCs, buildClassifiersByCrossProduct, aMs);
    }

    @Override
    protected void evaluateClassifier(NumericalPerformanceMeasureParameterSet mp, RepeatedSubSamplingAssessParameterSet assessPS, DataSet[] s, double[][] weights, ProgressUpdater pU) throws IllegalArgumentException, Exception {
        int eL = assessPS.getElementLength();
        boolean exceptionIfMPNotComputable = assessPS.getExceptionIfMPNotComputable();
        int repeats = assessPS.getRepeats();
        double[] trainN = assessPS.getTrain_TestNumbers(true);
        double[] testN = assessPS.getTrain_TestNumbers(false);
        int subSeqL = assessPS.getElementLength();
        if (trainN.length != this.myAbstractClassifier[0].getNumberOfClasses()) {
            throw new IllegalArgumentException("Given RepeatedSubSamlpingAssessParameterSet contains a invalid parameter trainDataNumbers. trainDataNumbers (int[], number of train-data items that should be subsampled for each class) must contain as much entries as classes the local classifers are able to distinguish.");
        }
        if (testN.length != this.myAbstractClassifier[0].getNumberOfClasses()) {
            throw new IllegalArgumentException("Given RepeatedSubSamlpingAssessParameterSet contains a invalid parameter testDataNumbers. testDataNumbers (int[], number of test-data items that should be subsampled for each class) must contain as much entries as classes the local classifers are able to distinguish.");
        }
        DataSet[][] sTrainTestClassWise = new DataSet[2][s.length];
        double[][][] weightsTrainTestClassWise = new double[2][s.length][];
        pU.setMax(repeats);
        for (int iteration = 0; iteration < repeats; ++iteration) {
            for (int classes = 0; classes < s.length; ++classes) {
                Pair<DataSet, double[]> p = s[classes].subSampling(trainN[classes], weights[classes]);
                sTrainTestClassWise[0][classes] = p.getFirstElement();
                weightsTrainTestClassWise[0][classes] = p.getSecondElement();
                p = s[classes].subSampling(testN[classes], weights[classes]);
                p = p.getFirstElement().resize(p.getSecondElement(), subSeqL);
                sTrainTestClassWise[1][classes] = p.getFirstElement();
                weightsTrainTestClassWise[1][classes] = p.getSecondElement();
            }
            this.train(sTrainTestClassWise[0], weightsTrainTestClassWise[0]);
            this.test(mp, exceptionIfMPNotComputable, sTrainTestClassWise[1], weightsTrainTestClassWise[1]);
            pU.setValue(iteration + 1);
            if (pU.isCancelled()) break;
        }
    }

    @Override
    public RepeatedSubSamplingAssessParameterSet getAssessParameterSet() throws Exception {
        return new RepeatedSubSamplingAssessParameterSet();
    }
}

