/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.performanceMeasures;

import de.jstacs.classifiers.performanceMeasures.AbstractPerformanceMeasure;
import de.jstacs.classifiers.performanceMeasures.AucPR;
import de.jstacs.classifiers.performanceMeasures.AucROC;
import de.jstacs.classifiers.performanceMeasures.ClassificationRate;
import de.jstacs.classifiers.performanceMeasures.FalsePositiveRateForFixedSensitivity;
import de.jstacs.classifiers.performanceMeasures.MaximumCorrelationCoefficient;
import de.jstacs.classifiers.performanceMeasures.MaximumFMeasure;
import de.jstacs.classifiers.performanceMeasures.NumericalPerformanceMeasureParameterSet;
import de.jstacs.classifiers.performanceMeasures.PRCurve;
import de.jstacs.classifiers.performanceMeasures.PerformanceMeasure;
import de.jstacs.classifiers.performanceMeasures.PerformanceMeasureParameterSet;
import de.jstacs.classifiers.performanceMeasures.PositivePredictiveValueForFixedSensitivity;
import de.jstacs.classifiers.performanceMeasures.ROCCurve;
import de.jstacs.classifiers.performanceMeasures.SensitivityForFixedSpecificity;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import java.util.LinkedList;

public class AbstractPerformanceMeasureParameterSet<T extends PerformanceMeasure>
extends ExpandableParameterSet {
    public AbstractPerformanceMeasureParameterSet(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    protected static int getNumberOfClasses(PerformanceMeasure[] measures) {
        int res = 0;
        for (int i = 0; i < measures.length; ++i) {
            int n = measures[i].getAllowedNumberOfClasses();
            if (res == 0) {
                if (n == 0) continue;
                res = n;
                continue;
            }
            if (n == res) continue;
            throw new IllegalArgumentException("The performance measures are defined for different number of classes.");
        }
        return res == 0 ? 2 : res;
    }

    protected AbstractPerformanceMeasureParameterSet(int numClasses, boolean numerical, T[] measures) throws Exception {
        this(numClasses, AbstractPerformanceMeasure.getCollectionOfAllMeasures(numClasses, numerical), (PerformanceMeasure[])measures);
    }

    private static ParameterSet[] getParameterSets(int numClasses, SelectionParameter selection, PerformanceMeasure ... measures) throws Exception {
        SimpleParameterSet template = new SimpleParameterSet(selection);
        int n = measures == null || measures.length == 0 ? 0 : measures.length;
        ParameterSet[] pars = new ParameterSet[Math.max(1, n)];
        pars[0] = template;
        for (int i = 0; i < n; ++i) {
            if (measures[i].getAllowedNumberOfClasses() != 0 && measures[i].getAllowedNumberOfClasses() != numClasses) {
                throw new Exception("Provided measure " + measures[i].getName() + " not allowed for " + numClasses + " classes.");
            }
            if (i != 0) {
                pars[i] = ((ParameterSet)template).clone();
            }
            ((SelectionParameter)pars[i].getParameterAt(0)).setValue(measures[i]);
        }
        return pars;
    }

    protected AbstractPerformanceMeasureParameterSet(int numClasses, SelectionParameter selection, T ... measures) throws Exception {
        super(AbstractPerformanceMeasureParameterSet.getParameterSets(numClasses, selection, measures), "Performance measures", "Performance measures for evaluating a classifier of " + numClasses + " classes");
    }

    public static NumericalPerformanceMeasureParameterSet createFilledParameters() throws Exception {
        return (NumericalPerformanceMeasureParameterSet)AbstractPerformanceMeasureParameterSet.createFilledParameters(true, 0.999, 0.95, 0.95, 1.0);
    }

    public static AbstractPerformanceMeasureParameterSet createFilledParameters(boolean numerical, double spForSn, double snForFPR, double snForPPV, double beta) throws Exception {
        AbstractPerformanceMeasureParameterSet res = numerical ? new NumericalPerformanceMeasureParameterSet(2) : new PerformanceMeasureParameterSet(2);
        res.setMeasure(new ClassificationRate());
        res.addMeasure(new SensitivityForFixedSpecificity(spForSn));
        res.addMeasure(new FalsePositiveRateForFixedSensitivity(snForFPR));
        res.addMeasure(new PositivePredictiveValueForFixedSensitivity(snForPPV));
        if (numerical) {
            res.addMeasure(new AucROC());
            res.addMeasure(new AucPR());
        } else {
            res.addMeasure(new ROCCurve());
            res.addMeasure(new PRCurve());
        }
        res.addMeasure(new MaximumCorrelationCoefficient());
        res.addMeasure(new MaximumFMeasure(beta));
        return res;
    }

    private void addMeasure(T measure) throws CloneNotSupportedException, SimpleParameter.IllegalValueException {
        this.addParameterToSet();
        this.setMeasure(measure);
    }

    protected void setMeasure(T measure) throws SimpleParameter.IllegalValueException {
        ParameterSetContainer cont = (ParameterSetContainer)this.parameters.get(this.parameters.size() - 1);
        SelectionParameter sel = (SelectionParameter)cont.getValue().getParameterAt(0);
        sel.setValue(measure);
    }

    public AbstractPerformanceMeasure removeMeasure(int index) {
        ParameterSetContainer cont = (ParameterSetContainer)this.parameters.remove(index);
        SelectionParameter cp = (SelectionParameter)cont.getValue().getParameterAt(0);
        return (AbstractPerformanceMeasure)cp.getValue();
    }

    public AbstractPerformanceMeasure[] removeMeasures(Class<? extends AbstractPerformanceMeasure> clazz) {
        LinkedList<AbstractPerformanceMeasure> list = new LinkedList<AbstractPerformanceMeasure>();
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (!((ParameterSet)((Parameter)this.parameters.get(i)).getValue()).getParameterAt(0).getValue().getClass().equals(clazz)) continue;
            list.add(this.removeMeasure(i));
            --i;
        }
        return list.toArray(new AbstractPerformanceMeasure[0]);
    }

    public AbstractPerformanceMeasure[] removeMeasures(String name) {
        LinkedList<AbstractPerformanceMeasure> list = new LinkedList<AbstractPerformanceMeasure>();
        for (int i = 0; i < this.parameters.size(); ++i) {
            AbstractPerformanceMeasure meas = (AbstractPerformanceMeasure)((ParameterSet)((Parameter)this.parameters.get(i)).getValue()).getParameterAt(0).getValue();
            if (!meas.getName().equals(name)) continue;
            list.add(this.removeMeasure(i));
            --i;
        }
        return list.toArray(new AbstractPerformanceMeasure[0]);
    }

    public AbstractPerformanceMeasure[] getAllMeasures() {
        AbstractPerformanceMeasure[] measures = new AbstractPerformanceMeasure[this.parameters.size()];
        for (int i = 0; i < measures.length; ++i) {
            ParameterSetContainer cont = (ParameterSetContainer)this.parameters.get(i);
            SelectionParameter cp = (SelectionParameter)cont.getValue().getParameterAt(0);
            measures[i] = (AbstractPerformanceMeasure)cp.getValue();
        }
        return measures;
    }
}

