/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DiscreteSequenceEnumerator;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.CyclicSequenceAdaptor;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Random;

public class DeBruijnGraphSequenceGenerator {
    public static CyclicSequenceAdaptor[] generate(DiscreteAlphabet alphabet, int n) throws WrongAlphabetException, WrongSequenceTypeException {
        return new CyclicSequenceAdaptor[]{DeBruijnGraphSequenceGenerator.generate(alphabet, n, 0)};
    }

    public static CyclicSequenceAdaptor generate(DiscreteAlphabet alphabet, int n, int alphabetShift) throws IllegalArgumentException, WrongAlphabetException {
        Random r = new Random(117L);
        DiscreteSequenceEnumerator en = new DiscreteSequenceEnumerator(new AlphabetContainer((Alphabet)alphabet), n, false);
        HashMap<String, Node> nodes = new HashMap<String, Node>();
        String first = null;
        while (en.hasMoreElements()) {
            String seq = ((Sequence)en.nextElement()).toString();
            String s1 = seq.substring(0, seq.length() - 1);
            if (first == null) {
                first = s1;
            }
            String s2 = seq.substring(1);
            if (!nodes.containsKey(s1)) {
                nodes.put(s1, new Node(s1));
            }
            if (!nodes.containsKey(s2)) {
                nodes.put(s2, new Node(s2));
            }
            Node n1 = (Node)nodes.get(s1);
            Node n2 = (Node)nodes.get(s2);
            n1.addChild(n2);
        }
        String str = DeBruijnGraphSequenceGenerator.findEulerPath(r, (Node)nodes.get(first));
        return new CyclicSequenceAdaptor(Sequence.create(new AlphabetContainer((Alphabet)alphabet), str));
    }

    private static String findEulerPath(Random r, Node start) {
        LinkedList<Node> stack = new LinkedList<Node>();
        stack.addFirst(start);
        StringBuffer sb = new StringBuffer();
        while (stack.size() > 0) {
            Node curr = (Node)stack.peek();
            Node next = null;
            next = curr.getUnvisitedEdge(r);
            if (next != null) {
                curr.setVisited(next);
                stack.addFirst(next);
                continue;
            }
            Node removed = (Node)stack.pop();
            sb.append(removed.getLabel().charAt(0));
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    private static class Node {
        private String label;
        private ArrayList<Node> children;
        private ArrayList<Integer> edgeVisited;
        private int nIncoming;

        public Node(String label) {
            this.label = label;
            this.children = new ArrayList();
            this.edgeVisited = new ArrayList();
            this.nIncoming = 0;
        }

        public String toString() {
            return this.label;
        }

        public boolean addChild(Node end) {
            if (this.children.contains(end)) {
                return false;
            }
            this.children.add(end);
            this.edgeVisited.add(0);
            ++end.nIncoming;
            return true;
        }

        public int getNOutgoing() {
            return this.children.size();
        }

        public int getNIncoming() {
            return this.nIncoming;
        }

        public String getLabel() {
            return this.label;
        }

        public LinkedList<Node> getUnvisitedEdges() {
            LinkedList<Node> edges = new LinkedList<Node>();
            for (int i = 0; i < this.children.size(); ++i) {
                if (this.edgeVisited.get(i) != 0) continue;
                edges.add(this.children.get(i));
            }
            return edges;
        }

        public Node getUnvisitedEdge(Random r) {
            LinkedList<Node> edges = this.getUnvisitedEdges();
            if (edges.size() == 0) {
                return null;
            }
            return edges.get(r.nextInt(edges.size()));
        }

        public void setVisited(Node node) {
            int i = this.children.indexOf(node);
            this.edgeVisited.set(i, this.edgeVisited.get(i) + 1);
        }
    }
}

