/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.alphabets;

import de.jstacs.Storable;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;

public class DiscreteAlphabetMapping
implements Storable {
    private int[] newValues;
    private double[] logNumSimilarSymbols;
    private DiscreteAlphabet newAlphabet;
    private static final String XML_TAG = "DiscreteAlphabetMapping";

    public DiscreteAlphabetMapping(int[] newValues, DiscreteAlphabet newAlphabet) {
        this.newValues = (int[])newValues.clone();
        this.newAlphabet = newAlphabet;
        this.precompute();
    }

    public DiscreteAlphabetMapping(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, XML_TAG);
        this.newAlphabet = (DiscreteAlphabet)XMLParser.extractObjectForTags(xml, "newAlphabet");
        this.newValues = XMLParser.extractObjectForTags(xml, "newValues", int[].class);
        this.precompute();
    }

    private void precompute() {
        int i;
        int max = 0;
        for (int i2 = 0; i2 < this.newValues.length; ++i2) {
            max = Math.max(max, this.newValues[i2]);
        }
        if ((double)(max + 1) != this.newAlphabet.length()) {
            throw new IllegalArgumentException("Please check the assignment from the original symbol/values to the new symbols/values.");
        }
        double[] originalSymbols = new double[max + 1];
        for (i = 0; i < this.newValues.length; ++i) {
            int n = this.newValues[i];
            originalSymbols[n] = originalSymbols[n] + 1.0;
        }
        this.logNumSimilarSymbols = new double[this.newValues.length];
        for (i = 0; i < this.newValues.length; ++i) {
            this.logNumSimilarSymbols[i] = Math.log(originalSymbols[this.newValues[i]]);
        }
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer sb = new StringBuffer();
        XMLParser.appendObjectWithTags(sb, this.newAlphabet, "newAlphabet");
        XMLParser.appendObjectWithTags(sb, this.newValues, "newValues");
        XMLParser.addTags(sb, XML_TAG);
        return sb;
    }

    public DiscreteAlphabet getNewAlphabet() {
        return this.newAlphabet;
    }

    public int getNewDiscreteValue(int oldValue) {
        return this.newValues[oldValue];
    }

    public double getLogNumberOfSimilarSymbols(int oldValue) {
        return this.logNumSimilarSymbols[oldValue];
    }
}

