/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

public class RegExFilenameFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter,
FilenameFilter {
    private String desc;
    private Pattern[] regex;
    private Directory dir;
    private boolean ignoreCase;

    public RegExFilenameFilter(String desc, Directory dir, boolean ignoreCase, String ... regex) {
        this.desc = desc;
        this.dir = dir;
        this.ignoreCase = ignoreCase;
        this.regex = new Pattern[regex.length];
        for (int i = 0; i < regex.length; ++i) {
            this.regex[i] = Pattern.compile(ignoreCase ? regex[i].toLowerCase() : regex[i]);
        }
    }

    @Override
    public boolean accept(File arg0) {
        int i;
        boolean isDir = arg0.isDirectory();
        if (isDir) {
            return this.dir != Directory.FORBIDDEN;
        }
        if (this.dir == Directory.REQUIRED) {
            return false;
        }
        String name = arg0.getName();
        if (this.ignoreCase) {
            name = name.toLowerCase();
        }
        for (i = 0; i < this.regex.length && !this.regex[i].matcher(name).matches(); ++i) {
        }
        return i < this.regex.length;
    }

    @Override
    public boolean accept(File dir, String name) {
        return this.accept(new File(dir, name));
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    public String getRegEx() {
        StringBuffer sb = new StringBuffer();
        for (Pattern s : this.regex) {
            sb.append(s.pattern() + "\n");
        }
        return sb.toString();
    }

    public String toString() {
        return this.getRegEx();
    }

    public static enum Directory {
        FORBIDDEN,
        ALLOWED,
        REQUIRED;

    }
}

