/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.io;

import de.jstacs.Singleton;
import de.jstacs.Storable;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.io.NonParsableException;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class XMLParser {
    private static final Class<StringBuffer> stringBufferClass = StringBuffer.class;
    private static final String ARRAY_TAG = "pos";
    private static final HashSet<Class<?>> simpleParsable = new HashSet();
    private static final String CLASS_NAME = "className";
    private static final String LENGTH = "length";
    private static final String VALUE = "val";
    private static final String NULL = "null";
    private static final String ENUM = "name";
    private static String[][] table;

    public static void addTags(StringBuffer source, String tag) {
        XMLParser.addTagsAndAttributes(source, tag, null);
    }

    public static void addTagsAndAttributes(StringBuffer source, String tag, String attributes) {
        source.insert(0, "<" + tag + (attributes == null ? "" : " " + attributes) + ">\n");
        source.insert(source.length(), "</" + tag + ">\n");
    }

    public static void appendObjectWithTags(StringBuffer xml, Object s, String tag) {
        XMLParser.appendObjectWithTagsAndAttributes(xml, s, tag, null);
    }

    public static void appendObjectWithTagsAndAttributes(StringBuffer xml, Object s, String tag, String attributes) {
        XMLParser.appendObjectWithTagsAndAttributes(xml, s, tag, attributes, true);
    }

    public static void appendObjectWithTagsAndAttributes(StringBuffer xml, Object s, String tag, String attributes, boolean writeClassInfo) {
        xml.append("<" + tag + (attributes == null ? "" : " " + attributes) + ">");
        if (s == null) {
            xml.append(NULL);
        } else {
            Class<?> k = s.getClass();
            if (writeClassInfo) {
                XMLParser.appendObjectWithTagsAndAttributes(xml, k.getName(), CLASS_NAME, null, false);
            }
            if (k.isArray()) {
                int l = Array.getLength(s);
                XMLParser.appendObjectWithTagsAndAttributes(xml, l, LENGTH, null, false);
                Class<?> c = k.getComponentType();
                if (simpleParsable.contains(c)) {
                    writeClassInfo = false;
                }
                for (int i = 0; i < l; ++i) {
                    XMLParser.appendObjectWithTagsAndAttributes(xml, Array.get(s, i), ARRAY_TAG, "val=\"" + i + "\"", writeClassInfo);
                }
            } else if (k.isEnum()) {
                XMLParser.appendObjectWithTagsAndAttributes(xml, ((Enum)s).name(), ENUM, null, false);
            } else if (s instanceof Class) {
                XMLParser.appendObjectWithTagsAndAttributes(xml, ((Class)s).getName(), ENUM, null, false);
            } else if (!(s instanceof Singleton)) {
                if (simpleParsable.contains(k)) {
                    xml.append(s instanceof String ? XMLParser.escape((String)s) : s);
                } else if (Storable.class.isInstance(s)) {
                    xml.append(((Storable)s).toXML());
                } else {
                    throw new RuntimeException("Instance of " + k + " can not be parsed to XML.");
                }
            }
        }
        xml.append("</" + tag + ">");
    }

    private static String[] split(String attrib) {
        int idx;
        ArrayList<String> res = new ArrayList<String>();
        int start = -1;
        while ((idx = attrib.indexOf(61, start + 1)) >= 0) {
            char c = attrib.charAt(idx + 1);
            int next = idx + 1;
            do {
                if ((next = attrib.indexOf(c, next + 1)) >= 0) continue;
                next = attrib.length() - 1;
            } while (next + 1 < attrib.length() && attrib.charAt(next + 1) != ' ');
            res.add(attrib.substring(start + 1, next + 1));
            start = next + 1;
        }
        return res.toArray(new String[0]);
    }

    private static Map<String, String> parseAttributes(String attrs) throws NonParsableException {
        TreeMap<String, String> map = new TreeMap<String, String>();
        String[] parts = XMLParser.split(attrs);
        int vallength = 0;
        for (String part : parts) {
            if ((part = part.trim()).length() <= 0) continue;
            String[] keyVal = part.split("=");
            if (keyVal.length != 2) {
                throw new NonParsableException("Malformed attributes: " + attrs);
            }
            keyVal[0] = keyVal[0].trim();
            keyVal[1] = keyVal[1].trim();
            vallength = keyVal[1].length();
            char c = keyVal[1].charAt(0);
            if ((c == '\"' || c == '\'') && keyVal[1].charAt(vallength - 1) == c) {
                keyVal[1] = keyVal[1].substring(1, vallength - 1);
            }
            map.put(keyVal[0], keyVal[1]);
        }
        return map;
    }

    public static String parseAttributes(Map<String, String> map) {
        Iterator<Map.Entry<String, String>> it = map.entrySet().iterator();
        StringBuffer res = new StringBuffer();
        while (it.hasNext()) {
            Map.Entry<String, String> e = it.next();
            res.append(e.getKey() + "=\"" + e.getValue() + "\" ");
        }
        int l = res.length();
        if (l > 0) {
            --l;
        }
        return res.substring(0, l);
    }

    private static boolean testFilter(Map<String, String> myAttrs, Map<String, String> filterAttributes) {
        Set<String> keys = filterAttributes.keySet();
        String myVal = null;
        String filterVal = null;
        for (String key : keys) {
            myVal = myAttrs.get(key);
            filterVal = filterAttributes.get(key);
            if (myVal == null && filterVal == null) continue;
            if (myVal == null) {
                return false;
            }
            if ((myVal = myVal.trim()).equals(filterVal = filterVal.trim())) continue;
            return false;
        }
        return true;
    }

    public static StringBuffer extractForTag(StringBuffer source, String tag) throws NonParsableException {
        return XMLParser.extractForTag(source, tag, null, null);
    }

    public static StringBuffer extractForTag(StringBuffer source, String tag, Map<String, String> attributes, Map<String, String> filterAttributes) throws NonParsableException {
        return XMLParser.extractForTag(source, tag, attributes, filterAttributes, null);
    }

    private static StringBuffer extractForTag(StringBuffer source, String tag, Map<String, String> attributes, Map<String, String> filterAttributes, int[] index) throws NonParsableException {
        int start = XMLParser.findOpeningTag(source, tag, attributes, filterAttributes, index == null ? 0 : index[1]);
        if (start < 0) {
            return null;
        }
        int endOfStart = source.indexOf(">", start + tag.length()) + 1;
        int pos = XMLParser.findClosingTag(source, tag, endOfStart);
        int closepos = source.indexOf(">", pos + 1);
        StringBuffer result = new StringBuffer(source.substring(endOfStart, pos));
        if (index == null) {
            source.delete(start, closepos + 1);
        } else {
            index[0] = start;
            index[1] = closepos + 1;
        }
        return result;
    }

    public static boolean hasTag(StringBuffer source, String tag, Map<String, String> attributes, Map<String, String> filterAttributes) throws NonParsableException {
        int start = XMLParser.findOpeningTag(source, tag, attributes, filterAttributes, 0);
        if (start < 0) {
            return false;
        }
        int endOfStart = source.indexOf(">", start + tag.length()) + 1;
        XMLParser.findClosingTag(source, tag, endOfStart);
        return true;
    }

    private static int skipTag(StringBuffer source, String tag, Map<String, String> attributes, Map<String, String> filterAttributes) throws NonParsableException {
        int start = XMLParser.findOpeningTag(source, tag, attributes, filterAttributes, 0);
        if (start < 0) {
            return -1;
        }
        int endOfStart = source.indexOf(">", start + tag.length()) + 1;
        int pos = XMLParser.findClosingTag(source, tag, endOfStart);
        int closepos = source.indexOf(">", pos + 1);
        return closepos + 1;
    }

    private static int findOpeningTag(StringBuffer source, String tag, Map<String, String> attributes, Map<String, String> filterAttributes, int offset) throws NonParsableException {
        if (source == null || source.length() == 0) {
            return -1;
        }
        int taglength = tag.length();
        int endOfStart = offset;
        Map<String, String> myMap = null;
        boolean found = false;
        String startTag = "<";
        String endTag = ">";
        int start;
        while ((start = source.indexOf(startTag, endOfStart)) >= 0) {
            if (source.charAt(start + 1) == '/') {
                throw new NonParsableException("Malformed XML: Found unexpected end tag: " + source.substring(start, source.indexOf(endTag, start + 1) + 1) + ".");
            }
            endOfStart = source.indexOf(endTag, start);
            int idx = source.indexOf(" ", start);
            if (idx < 0 || idx > endOfStart) {
                idx = endOfStart;
            }
            ++endOfStart;
            String currentTag = source.substring(start + 1, idx);
            if (currentTag.equals(tag)) {
                if (filterAttributes != null || attributes != null) {
                    myMap = XMLParser.parseAttributes(source.substring(start + taglength + 2, endOfStart - 1));
                }
                if ((found = filterAttributes != null ? XMLParser.testFilter(myMap, filterAttributes) : true) && attributes != null) {
                    attributes.putAll(myMap);
                }
                if (found) {
                    return start;
                }
            }
            endOfStart = XMLParser.findClosingTag(source, currentTag, endOfStart);
            endOfStart += 3 + currentTag.length();
        }
        return -1;
    }

    private static int findClosingTag(StringBuffer source, String tag, int offset) throws NonParsableException {
        int idx;
        int counter = 1;
        String endTag = "</" + tag + ">";
        String startPrefix = "<" + tag;
        do {
            int h;
            if ((idx = source.indexOf(endTag, offset)) < 0) {
                throw new NonParsableException("Malformed XML: No end tag found for " + tag + ".");
            }
            --counter;
            while ((h = source.indexOf(startPrefix, offset)) >= offset && h < idx) {
                offset = h + startPrefix.length();
                char c = source.charAt(offset);
                if (c != ' ' && c != '>') continue;
                ++counter;
            }
            offset = idx + endTag.length();
        } while (counter != 0);
        return idx;
    }

    public static Object extractObjectForTags(StringBuffer xml, String tag) throws NonParsableException {
        return XMLParser.extractObjectAndAttributesForTags(xml, tag, null, null);
    }

    public static <T> T extractObjectForTags(StringBuffer xml, String tag, Class<T> k) throws NonParsableException {
        return XMLParser.extractObjectAndAttributesForTags(xml, tag, null, null, k);
    }

    public static Object extractObjectAndAttributesForTags(StringBuffer xml, String tag, Map<String, String> attributes, Map<String, String> filterAttributes) throws NonParsableException {
        return XMLParser.extractObjectAndAttributesForTags(xml, tag, attributes, filterAttributes, null);
    }

    public static <T> T extractObjectAndAttributesForTags(StringBuffer xml, String tag, Map<String, String> attributes, Map<String, String> filterAttributes, Class<T> k) throws NonParsableException {
        return XMLParser.extractObjectAndAttributesForTags(xml, tag, attributes, filterAttributes, k, null, null);
    }

    public static <T, S> T extractObjectAndAttributesForTags(StringBuffer xml, String tag, Map<String, String> attributes, Map<String, String> filterAttributes, Class<T> k, Class<S> outerClass, S outerInstance) throws NonParsableException {
        return XMLParser.extractObjectAndAttributesForTags(xml, tag, attributes, filterAttributes, k, outerClass, outerInstance, null);
    }

    private static <T, S> T extractObjectAndAttributesForTags(StringBuffer xml, String tag, Map<String, String> attributes, Map<String, String> filterAttributes, Class<T> k, Class<S> outerClass, S outerInstance, int[] index) throws NonParsableException {
        Object erg;
        boolean infer;
        StringBuffer ex = XMLParser.extractForTag(xml, tag, attributes, filterAttributes, index);
        if (ex == null) {
            throw new NonParsableException("Could not find \"" + tag + "\".");
        }
        if (ex.toString().trim().equals(NULL)) {
            return null;
        }
        String className = null;
        int mod = k != null ? k.getModifiers() : 0;
        boolean bl = infer = k == null || !k.isArray() && !simpleParsable.contains(k) && !Modifier.isFinal(mod) && (Modifier.isAbstract(mod) || Modifier.isInterface(mod) || k == Object.class);
        if (infer) {
            className = XMLParser.extractObjectAndAttributesForTags(ex, CLASS_NAME, null, null, String.class, null, null, null);
            try {
                k = Class.forName(className);
            }
            catch (Exception e) {
                throw XMLParser.getNonParsableException("Class \"" + className + "\" not found.", e);
            }
        }
        if (k.isArray()) {
            index = new int[2];
            Class<?> c = k.getComponentType();
            int l = XMLParser.extractObjectAndAttributesForTags(ex, LENGTH, null, null, Integer.TYPE, null, null, index);
            erg = Array.newInstance(c, l);
            if (!simpleParsable.contains(c)) {
                c = infer ? null : c;
            }
            TreeMap<String, String> myFilterAttributes = new TreeMap<String, String>();
            for (int i = 0; i < l; ++i) {
                myFilterAttributes.clear();
                myFilterAttributes.put(VALUE, "" + i);
                Object o = XMLParser.extractObjectAndAttributesForTags(ex, ARRAY_TAG, null, myFilterAttributes, c, outerClass, outerInstance, index);
                Array.set(erg, i, o);
            }
        } else if (k.isEnum()) {
            erg = Enum.valueOf(k, XMLParser.extractObjectAndAttributesForTags(ex, ENUM, null, null, String.class, null, null, null));
        } else if (simpleParsable.contains(k)) {
            int offset = 0;
            if (!infer) {
                try {
                    offset = XMLParser.skipTag(ex, CLASS_NAME, null, null);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            erg = XMLParser.cast(k, offset <= 0 ? ex.toString() : ex.substring(offset));
        } else if (Singleton.class.isAssignableFrom(k)) {
            try {
                erg = Singleton.SingletonHandler.getSingelton(k);
            }
            catch (Exception e) {
                throw XMLParser.getNonParsableException("You must provide a static field SINGELTON.", e);
            }
        } else if (Storable.class.isAssignableFrom(k)) {
            try {
                if (outerClass != null) {
                    erg = k.getConstructor(outerClass, stringBufferClass).newInstance(outerInstance, ex);
                }
                erg = k.getConstructor(stringBufferClass).newInstance(ex);
            }
            catch (NoSuchMethodException e) {
                throw XMLParser.getNonParsableException("You must provide a constructor " + k.getName() + "(StringBuffer).", e);
            }
            catch (Exception e) {
                throw XMLParser.getNonParsableException("problem at " + k.getName() + ": " + e.getClass().getSimpleName() + ": " + e.getCause().toString() + "\n" + Arrays.toString(e.getCause().getStackTrace()).replaceAll("(,|\\[|\\])", "\n-- ") + "]]", e);
            }
        } else if (k == Class.class) {
            String str = null;
            String temp = ex.toString();
            try {
                str = XMLParser.extractObjectAndAttributesForTags(ex, ENUM, null, null, String.class, null, null, null);
                erg = Class.forName(str);
            }
            catch (ClassNotFoundException e) {
                throw XMLParser.getNonParsableException("Could not find the specified class: " + str + " (" + k + ": " + temp + ").", e);
            }
        } else {
            throw new NonParsableException("Could not parse the object with tag \"" + tag + "\" and class \"" + k + "\".");
        }
        return (T)erg;
    }

    public static void appendSequencesWithTags(StringBuffer xml, String tag, Sequence ... seqs) {
        String[] temp = null;
        if (seqs != null) {
            temp = new String[seqs.length];
            for (int i = 0; i < seqs.length; ++i) {
                if (seqs[i] == null) continue;
                SequenceAnnotation[] anns = seqs[i].getAnnotation();
                AlphabetContainer alphabet = seqs[i].getAlphabetContainer();
                String seqstr = seqs[i].toString(alphabet.getDelim(), 0, seqs[i].getLength());
                StringBuffer tb = new StringBuffer();
                XMLParser.appendObjectWithTags(tb, anns, "anns");
                XMLParser.appendObjectWithTags(tb, alphabet, "alphabet");
                XMLParser.appendObjectWithTags(tb, seqstr, "seqstr");
                temp[i] = tb.toString();
            }
        }
        XMLParser.appendObjectWithTags(xml, temp, tag);
    }

    public static Sequence[] extractSequencesWithTags(StringBuffer xml, String tag) throws NonParsableException, WrongAlphabetException {
        String[] temp = (String[])XMLParser.extractObjectForTags(xml, tag);
        if (temp != null) {
            Sequence[] seqs = new Sequence[temp.length];
            for (int i = 0; i < seqs.length; ++i) {
                if (temp[i] == null) continue;
                StringBuffer tb = new StringBuffer(temp[i]);
                SequenceAnnotation[] anns = (SequenceAnnotation[])XMLParser.extractObjectForTags(tb, "anns");
                AlphabetContainer alphabet = (AlphabetContainer)XMLParser.extractObjectForTags(tb, "alphabet");
                String seqstr = (String)XMLParser.extractObjectForTags(tb, "seqstr");
                seqs[i] = Sequence.create(alphabet, seqstr, alphabet.getDelim());
            }
            return seqs;
        }
        return null;
    }

    private static <T> Object cast(Class<T> c, String value) throws NonParsableException {
        if (c == String.class) {
            return XMLParser.unescape(value);
        }
        if (c == Character.TYPE) {
            return Character.valueOf(value.charAt(0));
        }
        if (c == Boolean.TYPE || c == Boolean.class) {
            return Boolean.parseBoolean(value);
        }
        if (c == Byte.TYPE || c == Byte.class) {
            return Byte.parseByte(value);
        }
        if (c == Short.TYPE || c == Short.class) {
            return Short.parseShort(value);
        }
        if (c == Integer.TYPE || c == Integer.class) {
            return Integer.parseInt(value);
        }
        if (c == Long.TYPE || c == Long.class) {
            return Long.parseLong(value);
        }
        if (c == Float.TYPE || c == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (c == Double.TYPE || c == Double.class) {
            return Double.parseDouble(value);
        }
        throw new NonParsableException("Could not parse \"" + value + "\" to " + c + ".");
    }

    private static final NonParsableException getNonParsableException(String s, Exception e) {
        NonParsableException n = new NonParsableException(s);
        n.setStackTrace(e.getStackTrace());
        return n;
    }

    public static String parseString(String original) {
        return original != null && original.equals(NULL) ? null : original;
    }

    private static String escape(String original) {
        if (original != null) {
            for (int i = 0; i < table.length; ++i) {
                original = original.replaceAll(table[i][0], table[i][1]);
            }
        }
        return original;
    }

    private static String unescape(String original) {
        if (original != null) {
            for (int i = 0; i < table.length; ++i) {
                original = original.replaceAll(table[i][1], table[i][0]);
            }
        }
        return original;
    }

    static {
        simpleParsable.add(Boolean.TYPE);
        simpleParsable.add(Byte.TYPE);
        simpleParsable.add(Character.TYPE);
        simpleParsable.add(Double.TYPE);
        simpleParsable.add(Float.TYPE);
        simpleParsable.add(Integer.TYPE);
        simpleParsable.add(Long.TYPE);
        simpleParsable.add(Short.TYPE);
        simpleParsable.add(Boolean.class);
        simpleParsable.add(Byte.class);
        simpleParsable.add(Character.class);
        simpleParsable.add(Double.class);
        simpleParsable.add(Float.class);
        simpleParsable.add(Integer.class);
        simpleParsable.add(Long.class);
        simpleParsable.add(Short.class);
        simpleParsable.add(String.class);
        table = new String[][]{{"&", "&amp;"}, {"\"", "&quot;"}, {"'", "&apos;"}, {">", "&gt;"}, {"<", "&lt;"}};
    }
}

