/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters;

import de.jstacs.DataType;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.GalaxyConvertible;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.RangeParameter;
import de.jstacs.parameters.Rangeable;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.parameters.validation.ParameterValidator;
import de.jstacs.tools.ui.galaxy.GalaxyAdaptor;

public class SimpleParameter
extends Parameter
implements Rangeable,
GalaxyConvertible {
    protected boolean required;
    protected Object value;
    protected Object defaultValue;
    protected ParameterValidator validator;
    private boolean isSet;
    private String errorMessage;
    private boolean isRangeable;

    public SimpleParameter(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    public SimpleParameter(DataType datatype, String name, String comment, boolean required) throws DatatypeNotValidException {
        super(name, comment, datatype);
        if (datatype != DataType.BOOLEAN && datatype != DataType.BYTE && datatype != DataType.CHAR && datatype != DataType.DOUBLE && datatype != DataType.FLOAT && datatype != DataType.INT && datatype != DataType.LONG && datatype != DataType.SHORT && datatype != DataType.STRING) {
            throw new DatatypeNotValidException("Only primitive datatypes and Strings are allowed as datatypes of a SimpleParameter!");
        }
        this.required = required;
        this.validator = null;
        this.isSet = false;
        this.isRangeable = datatype != DataType.STRING && datatype != DataType.CHAR;
    }

    public SimpleParameter(DataType datatype, String name, String comment, boolean required, Object defaultVal) throws DatatypeNotValidException, IllegalValueException {
        this(datatype, name, comment, required);
        if (!this.checkValue(defaultVal)) {
            throw new IllegalValueException("Value not valid");
        }
        this.setDefault(defaultVal);
    }

    public SimpleParameter(DataType datatype, String name, String comment, boolean required, ParameterValidator validator) throws DatatypeNotValidException {
        this(datatype, name, comment, required);
        this.validator = validator;
    }

    public SimpleParameter(DataType datatype, String name, String comment, boolean required, ParameterValidator validator, Object defaultVal) throws ParameterException {
        this(datatype, name, comment, required, validator);
        if (!this.checkValue(defaultVal)) {
            throw new IllegalValueException("Value not valid");
        }
        this.setDefault(defaultVal);
    }

    @Override
    public SimpleParameter clone() throws CloneNotSupportedException {
        SimpleParameter clone = (SimpleParameter)super.clone();
        if (this.validator != null) {
            clone.validator = this.validator.clone();
        }
        return clone;
    }

    @Override
    public boolean hasDefaultOrIsSet() {
        if (this.isSet) {
            return true;
        }
        return this.getValue() != null;
    }

    @Override
    public boolean isSet() {
        return this.isSet;
    }

    @Override
    public boolean isRangeable() {
        return this.isRangeable;
    }

    public void setRangeable(boolean rangeable) {
        this.isRangeable = rangeable;
    }

    @Override
    public Parameter getRangedInstance() throws Exception {
        if (this.isRangeable()) {
            return new RangeParameter(this);
        }
        throw new Exception("Parameter " + this.name + " is not rangeable!");
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public boolean checkValue(Object value) {
        if (value == null) {
            return true;
        }
        if (this.validator == null) {
            boolean res;
            try {
                switch (this.datatype) {
                    case BOOLEAN: {
                        res = value instanceof Boolean || value instanceof String;
                        break;
                    }
                    case CHAR: {
                        res = value instanceof Character || value instanceof String && ((String)value).length() == 1;
                        break;
                    }
                    case BYTE: {
                        res = value instanceof Byte || value instanceof String && new Byte((String)value) != null;
                        break;
                    }
                    case SHORT: {
                        res = value instanceof Short || value instanceof String && new Short((String)value) != null;
                        break;
                    }
                    case INT: {
                        res = value instanceof Integer || value instanceof String && new Integer((String)value) != null;
                        break;
                    }
                    case LONG: {
                        res = value instanceof Long || value instanceof String && new Long((String)value) != null;
                        break;
                    }
                    case FLOAT: {
                        res = value instanceof Float || value instanceof String && new Float((String)value) != null;
                        break;
                    }
                    case DOUBLE: {
                        res = value instanceof Double || value instanceof String && new Double((String)value) != null;
                        break;
                    }
                    case STRING: {
                        res = value instanceof String;
                        break;
                    }
                    default: {
                        res = false;
                        break;
                    }
                }
            }
            catch (Exception e) {
                res = false;
            }
            this.errorMessage = res ? "" : "The specified value is no " + (Object)((Object)this.datatype) + ".";
            return res;
        }
        Object value2 = value;
        if (value instanceof String) {
            try {
                switch (this.datatype) {
                    case BYTE: {
                        value2 = new Byte((String)value);
                        break;
                    }
                    case SHORT: {
                        value2 = new Short((String)value);
                        break;
                    }
                    case INT: {
                        value2 = new Integer((String)value);
                        break;
                    }
                    case LONG: {
                        value2 = new Long((String)value);
                        break;
                    }
                    case FLOAT: {
                        value2 = new Float((String)value);
                        break;
                    }
                    case DOUBLE: {
                        value2 = new Double((String)value);
                    }
                }
            }
            catch (NumberFormatException e) {
                this.errorMessage = "Value is not of the expected format.";
                return false;
            }
        }
        if (this.validator.checkValue(value2)) {
            this.errorMessage = this.validator.getErrorMessage();
            return true;
        }
        this.errorMessage = this.validator.getErrorMessage();
        return false;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void setDefault(Object defaultValue) throws IllegalValueException {
        if (!this.checkValue(defaultValue)) {
            throw new IllegalValueException("default value not valid");
        }
        this.defaultValue = defaultValue;
        this.setValue(defaultValue);
        this.isSet = false;
    }

    @Override
    public void reset() {
        if (this.defaultValue != null) {
            try {
                this.setDefault(this.defaultValue);
            }
            catch (Exception e) {
                this.value = null;
            }
        } else {
            this.value = null;
        }
    }

    @Override
    public void setValue(Object value2) throws IllegalValueException {
        if (this.checkValue(value2)) {
            this.isSet = true;
            if (value2 == null) {
                this.value = null;
                this.isSet = false;
            } else if (value2 instanceof String && this.datatype != DataType.STRING) {
                String s = (String)value2;
                try {
                    switch (this.datatype) {
                        case BOOLEAN: {
                            this.value = new Boolean(s);
                            break;
                        }
                        case CHAR: {
                            this.value = Character.valueOf(s.toCharArray()[0]);
                            break;
                        }
                        case BYTE: {
                            this.value = new Byte(s);
                            break;
                        }
                        case SHORT: {
                            this.value = new Short(s);
                            break;
                        }
                        case INT: {
                            this.value = new Integer(s);
                            break;
                        }
                        case LONG: {
                            this.value = new Long(s);
                            break;
                        }
                        case FLOAT: {
                            this.value = new Float(s);
                            break;
                        }
                        case DOUBLE: {
                            this.value = new Double(s);
                            break;
                        }
                        default: {
                            this.errorMessage = "Parameter value not of the expected type!";
                            throw new IllegalValueException(this.errorMessage);
                        }
                    }
                }
                catch (Exception e) {
                    this.value = null;
                    this.isSet = false;
                    this.errorMessage = "Value not valid\n" + e.getMessage();
                    throw new IllegalValueException("Value not valid\n" + e.getMessage());
                }
            } else {
                this.value = value2;
            }
        } else {
            this.value = null;
            this.isSet = false;
            throw new IllegalValueException("value of " + this.getName() + " not valid: " + value2);
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getXMLTag() {
        return "simpleParameter";
    }

    @Override
    protected void appendFurtherInfos(StringBuffer buf) {
        super.appendFurtherInfos(buf);
        XMLParser.appendObjectWithTags(buf, this.required, "required");
        XMLParser.appendObjectWithTags(buf, this.isSet, "isSet");
        XMLParser.appendObjectWithTags(buf, this.errorMessage, "errorMessage");
        XMLParser.appendObjectWithTags(buf, this.isRangeable, "isRangeable");
        XMLParser.appendObjectWithTags(buf, this.validator, "validator");
        XMLParser.appendObjectWithTags(buf, this.defaultValue, "defaultValue");
        XMLParser.appendObjectWithTags(buf, this.value, "value");
    }

    @Override
    protected void extractFurtherInfos(StringBuffer representation) throws NonParsableException {
        super.extractFurtherInfos(representation);
        this.required = XMLParser.extractObjectForTags(representation, "required", Boolean.TYPE);
        this.isSet = XMLParser.extractObjectForTags(representation, "isSet", Boolean.TYPE);
        this.errorMessage = XMLParser.parseString(XMLParser.extractObjectForTags(representation, "errorMessage", String.class));
        StringBuffer help = XMLParser.extractForTag(representation, "isRangeable");
        this.isRangeable = help == null ? false : Boolean.parseBoolean(help.toString());
        this.validator = XMLParser.extractObjectForTags(representation, "validator", ParameterValidator.class);
        if (!XMLParser.hasTag(representation, "defaultValue", null, null)) {
            this.defaultValue = null;
        } else {
            this.defaultValue = XMLParser.extractObjectForTags(representation, "defaultValue");
            if (this.defaultValue != null) {
                try {
                    this.setDefault(this.defaultValue);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new NonParsableException(e.getMessage());
                }
            }
        }
        String val = XMLParser.extractObjectForTags(representation, "value", String.class);
        if (val != null) {
            try {
                this.setValue(val);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NonParsableException(e.getMessage());
            }
        }
    }

    public boolean equals(Object o2) {
        if (o2 instanceof SimpleParameter) {
            SimpleParameter par2 = (SimpleParameter)o2;
            return par2.comment.equals(this.comment) && par2.name.equals(this.name) && par2.required == this.required && par2.datatype == this.datatype;
        }
        return false;
    }

    public ParameterValidator getValidator() {
        return this.validator;
    }

    public void setValidator(ParameterValidator validator) {
        this.validator = validator;
    }

    public String toString() {
        return this.name + " (" + this.comment + (this.validator != null && this.validator instanceof NumberValidator ? ", " + this.validator.toString() : "") + (this.defaultValue != null ? ", default = " + this.defaultValue.toString() : "") + (this.required ? "" : ", OPTIONAL") + ")\t= " + this.value;
    }

    @Override
    public void toGalaxy(String namePrefix, String configPrefix, int depth, StringBuffer descBuffer, StringBuffer configBuffer, boolean addLine) throws Exception {
        namePrefix = namePrefix + "_" + GalaxyAdaptor.getLegalName(this.getName());
        StringBuffer buf = new StringBuffer();
        if (this.validator != null && this.validator instanceof GalaxyConvertible) {
            ((GalaxyConvertible)((Object)this.validator)).toGalaxy(namePrefix + "_valid", null, depth, buf, null, false);
        }
        String line = "";
        if (addLine) {
            line = "&lt;hr /&gt;";
        }
        XMLParser.addTagsAndAttributes(buf, "param", "type=\"" + this.dataTypeToGalaxy() + "\"" + (this.datatype == DataType.STRING ? " size=\"40\"" : "") + " name=\"" + namePrefix + "\" label=\"" + line + this.getName() + "\" help=\"" + this.getComment() + "\" " + (this.datatype == DataType.BOOLEAN ? "checked" : "value") + "=\"" + (this.defaultValue == null ? "" : (this.datatype == DataType.BOOLEAN ? (this.defaultValue.equals(true) ? "True" : "False") : this.defaultValue)) + "\" optional=\"" + !this.isRequired() + "\"");
        descBuffer.append(buf);
        buf = new StringBuffer();
        buf.append("${" + configPrefix + namePrefix + "}");
        XMLParser.addTags(buf, namePrefix);
        configBuffer.append(buf);
    }

    protected String dataTypeToGalaxy() {
        switch (this.datatype) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return "integer";
            }
            case FLOAT: 
            case DOUBLE: {
                return "float";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case CHAR: 
            case STRING: {
                return "text";
            }
        }
        return "text";
    }

    @Override
    public void fromGalaxy(String namePrefix, StringBuffer command) throws Exception {
        namePrefix = namePrefix + "_" + GalaxyAdaptor.getLegalName(this.getName());
        try {
            String val = XMLParser.extractForTag(command, namePrefix).toString();
            this.setValue(val);
        }
        catch (NullPointerException e) {
            throw new NullPointerException(this.getName() + " " + command + " " + namePrefix);
        }
    }

    public static class IllegalValueException
    extends ParameterException {
        private static final long serialVersionUID = 1L;

        public IllegalValueException(String reason) {
            super("Parameter not permitted: " + reason);
        }
    }

    public static class DatatypeNotValidException
    extends ParameterException {
        private static final long serialVersionUID = 1L;

        public DatatypeNotValidException(String reason) {
            super("The datatype is not valid for this type of parameter: " + reason);
        }
    }
}

