/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.differentiable.mixture;

import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.sequenceScores.statisticalModels.differentiable.VariableLengthDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.MixtureDiffSM;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;

public class VariableLengthMixtureDiffSM
extends MixtureDiffSM
implements VariableLengthDiffSM {
    public VariableLengthMixtureDiffSM(int starts, boolean plugIn, VariableLengthDiffSM ... component) throws CloneNotSupportedException {
        super(starts, plugIn, component);
    }

    public VariableLengthMixtureDiffSM(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public double getLogScoreFor(Sequence seq, int start, int end) {
        for (int i = 0; i < this.function.length; ++i) {
            this.componentScore[i] = this.logHiddenPotential[i] + ((VariableLengthDiffSM)this.function[i]).getLogScoreFor(seq, start, end);
        }
        return Normalisation.getLogSum(this.componentScore);
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, int end, IntList indices, DoubleList partialDer) {
        int i;
        int j = 0;
        int k = this.paramRef.length - 1;
        k = this.paramRef[k] - this.paramRef[k - 1];
        for (i = 0; i < this.function.length; ++i) {
            this.iList[i].clear();
            this.dList[i].clear();
            this.componentScore[i] = this.logHiddenPotential[i] + ((VariableLengthDiffSM)this.function[i]).getLogScoreAndPartialDerivation(seq, start, end, this.iList[i], this.dList[i]);
        }
        double logScore = Normalisation.logSumNormalisation(this.componentScore, 0, this.function.length, this.componentScore, 0);
        for (i = 0; i < this.function.length; ++i) {
            for (j = 0; j < this.iList[i].length(); ++j) {
                indices.add(this.paramRef[i] + this.iList[i].get(j));
                partialDer.add(this.componentScore[i] * this.dList[i].get(j));
            }
        }
        for (j = 0; j < k; ++j) {
            indices.add(this.paramRef[i] + j);
            partialDer.add(this.componentScore[j] - (this.isNormalized() ? this.hiddenPotential[j] : 0.0));
        }
        return logScore;
    }

    @Override
    public double getLogNormalizationConstant(int length) {
        double n = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.logHiddenPotential.length; ++i) {
            n = Normalisation.getLogSum(n, this.logHiddenPotential[i] + ((VariableLengthDiffSM)this.function[i]).getLogNormalizationConstant(length));
        }
        return n;
    }

    @Override
    public double getLogPartialNormalizationConstant(int parameterIndex, int length) throws Exception {
        if (this.isNormalized()) {
            return Double.NEGATIVE_INFINITY;
        }
        int[] ind = this.getIndices(parameterIndex);
        if (ind[0] == this.function.length) {
            return this.logHiddenPotential[ind[1]] + ((VariableLengthDiffSM)this.function[ind[1]]).getLogNormalizationConstant(length);
        }
        return this.logHiddenPotential[ind[0]] + ((VariableLengthDiffSM)this.function[ind[0]]).getLogPartialNormalizationConstant(ind[1], length);
    }

    @Override
    public void setStatisticForHyperparameters(int[] length, double[] weight) throws Exception {
        double[] w = new double[this.getNumberOfComponents()];
        for (int i = 0; i < w.length; ++i) {
            w[i] = this.getHyperparameterForHiddenParameter(i);
        }
        Normalisation.sumNormalisation(w);
        double[] nw = new double[weight.length];
        for (int i = 0; i < this.function.length; ++i) {
            for (int j = 0; j < nw.length; ++j) {
                nw[j] = weight[j] * w[i];
            }
            ((VariableLengthDiffSM)this.function[i]).setStatisticForHyperparameters(length, nw);
        }
    }
}

