/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous;

import de.jstacs.algorithms.graphs.tensor.SymmetricTensor;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.StructureLearner;
import de.jstacs.utils.REnvironment;
import java.awt.image.BufferedImage;

public class TwoPointEvaluater {
    private static final byte order = 1;

    public static double[][] getMI(DataSet s, double[] weights) throws IllegalArgumentException {
        int i;
        int l = s.getElementLength();
        int[] j = new int[1];
        StructureLearner sl = new StructureLearner(s.getAlphabetContainer(), l);
        SymmetricTensor tensor = null;
        try {
            tensor = sl.getTensor(s, weights, (byte)1, StructureLearner.LearningType.ML_OR_MAP);
        }
        catch (WrongAlphabetException w) {
            throw new IllegalArgumentException();
        }
        double sum = 0.0;
        if (weights != null) {
            for (i = 0; i < weights.length; ++i) {
                sum += weights[i];
            }
        } else {
            sum = s.getNumberOfElements();
        }
        double[][] mi = new double[l][l];
        while (i < l) {
            j[0] = i + 1;
            while (j[0] < l) {
                double d = tensor.getValue((byte)1, i, j) / sum;
                mi[j[0]][i] = d;
                mi[i][j[0]] = d;
                j[0] = j[0] + 1;
            }
            ++i;
        }
        return mi;
    }

    public static double[][] getMIInBits(DataSet s, double[] weights) throws IllegalArgumentException {
        double[][] mi = TwoPointEvaluater.getMI(s, weights);
        for (int i = 0; i < mi.length; ++i) {
            for (int j = 0; j < mi[i].length; ++j) {
                mi[i][j] = mi[i][j] / Math.log(2.0);
            }
        }
        return mi;
    }

    public static BufferedImage getImage(double[][] mi, REnvironment r) throws Exception {
        r.createMatrix("mi", mi);
        r.eval("mini = min( mi ); maxi = max( mi );");
        r.eval("lim = c(mini, maxi);c = rev( gray((1:1000)/1000) ); l=1:dim(mi)[1];");
        r.eval("skala = seq( mini, maxi, length = 1000 ); m = matrix( skala, ncol = 1000 );");
        BufferedImage b = r.plot("layout( matrix( c(1,2), ncol=2 ), width=c(12,3) ); par( las=1 );image( l, l, mi, xlab = \"position\",  ylab = \"position\", zlim = lim, col = c, main = \"mutual information\" );par( mar = c(5, 0, 4, 6) + 0.1);image( 1, skala, m, col = c, xlab = \"\", ylab = \"\", main = \"scale\", axes = FALSE );axis( 4, seq(mini,maxi,length=5), round( seq(mini,maxi,length=5), digits = 4 ) )", 1080.0, 864.0);
        return b;
    }

    public static BufferedImage getImage(DataSet d, double[] weights, REnvironment r, double alpha, int ... borders) throws Exception {
        double[][] mi = TwoPointEvaluater.getMI(d, weights);
        r.createMatrix("mi", mi);
        r.createVector("borders", borders);
        r.eval("L=dim(mi)[1];l=1:L;");
        double sum = 0.0;
        if (weights != null) {
            for (int i = 0; i < weights.length; ++i) {
                sum += weights[i];
            }
        } else {
            sum = d.getNumberOfElements();
        }
        r.eval("f=2*" + sum);
        int[] a = new int[d.getElementLength()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = (int)d.getAlphabetContainer().getAlphabetLengthAt(i);
        }
        r.createVector("a", a);
        r.voidEval("p=matrix(NA,ncol=L,nrow=L);");
        r.voidEval("count=rep(0,L);");
        r.voidEval("correction=(L*(L-1)/2); alpha = " + alpha + ";");
        r.voidEval("for( i in l ) { for( j in i:L ) { mi[j,i]=NA;if( i != j ) { p[j,i]=pchisq(f*mi[i,j],df=(a[i]-1)*(a[j]-1),lower.tail=F)*correction;if( p[j,i] > alpha ) {p[j,i]=NA;} else {count[i] = count[i] + 1;count[j] = count[j] + 1;}\n}\n}\n }\n");
        r.voidEval("count[count==0]=NA;");
        r.eval("mini = min( mi, na.rm=T ); maxi = max( mi, na.rm=T ); lim = c(mini, maxi);c = rev( gray((1:1000)/1000) ); skala = seq( mini, maxi, length = length(c) ); m = matrix( skala, ncol = length(c) );");
        r.eval("miniP = min( p, na.rm=T ); maxiP = max( p, na.rm=T ); limP = c(miniP, maxiP);colP = rev( gray((800:1)/1000) ); skalaP = seq( miniP, maxiP, length = length(colP) ); mP = matrix( skalaP, ncol = length(colP) );");
        BufferedImage b = r.plot("layout( matrix( c(3,1,4,5,2,6), ncol=3, nrow=2, byrow=T ), width=c(2,11,2), height=c(4,1) ); par( las=1 );image( l, l, mi, xlab = \"position\",  ylab = \"position\", zlim = lim, col = c, main = \"\" );image( l, l, p, add=T, col=colP );abline(h=borders+0.5,col=2,lwd=3);abline(v=borders+0.5,col=2,lwd=3);par( mar = c(5, 4, 0, 2) + 0.1);plot(l,count,type=\"h\",xlim=c(1,L),lwd=10,xlab=\"position\",ylab=\"# significant MI\");abline(v=borders+0.5,col=2,lwd=3);par( mar = c(5, 6, 4, 0) + 0.1);image( 1, skala, m, col = c, xlab = \"\", ylab = \"\", main = \"MI\", axes = FALSE );axis( 2, seq(mini,maxi,length=5), round( seq(mini,maxi,length=5), digits = 4 ) );par( mar = c(5, 0, 4, 6) + 0.1);image( 1, skalaP, mP, col = colP, xlab = \"\", ylab = \"\", main = \"p-value\", axes = FALSE );axis( 4, seq(miniP,maxiP,length=5), signif( seq(miniP,maxiP,length=5), 2 ) );mtext(\"Bonferonie\", 1, 1);mtext(\"corrected\", 1, 2.5);", 1080.0, 1080.0);
        return b;
    }

    public static double getMax(double[][] mi) {
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < mi.length; ++i) {
            for (int j = 0; j < mi[i].length; ++j) {
                if (!(mi[i][j] > max)) continue;
                max = mi[i][j];
            }
        }
        return max;
    }
}

