/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.discrete;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.FileManager;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.DifferentiableEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.Emission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.SamplingEmission;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.ToolBox;
import de.jstacs.utils.random.DiMRGParams;
import de.jstacs.utils.random.DirichletMRG;
import de.jstacs.utils.random.DirichletMRGParams;
import de.jstacs.utils.random.FastDirichletMRGParams;
import de.jtem.numericalMethods.calculus.specialFunctions.Gamma;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.TreeMap;
import javax.naming.OperationNotSupportedException;

public abstract class AbstractConditionalDiscreteEmission
implements SamplingEmission,
DifferentiableEmission {
    private double[] colors;
    protected File[] paramsFile;
    protected int[] counter;
    protected int samplingIndex;
    protected BufferedWriter writer;
    protected BufferedReader reader;
    protected int offset;
    protected AlphabetContainer con;
    protected double[][] params;
    protected double[][] probs;
    protected double[][] hyperParams;
    protected double[][] statistic;
    protected double[][] grad;
    protected double[] logNorm;
    protected double[] ess;
    private double[][] initHyperParams;
    private String shape;
    private boolean linear;
    private static final String XML_TAG = "ConditionalDiscreteEmission";

    protected static double[][] getHyperParams(double ess, int numConditions, int numEmissions) {
        double[] ess2 = new double[numConditions];
        Arrays.fill(ess2, ess / (double)numConditions);
        return AbstractConditionalDiscreteEmission.getHyperParams(ess2, numEmissions);
    }

    private static double[][] getHyperParams(double[] ess, int number) {
        double[][] res = new double[ess.length][number];
        for (int i = 0; i < res.length; ++i) {
            Arrays.fill(res[i], ess[i] / (double)number);
        }
        return res;
    }

    protected AbstractConditionalDiscreteEmission(AlphabetContainer con, int numberOfConditions, double ess) {
        this(con, AbstractConditionalDiscreteEmission.getHyperParams(ess, numberOfConditions, (int)con.getAlphabetLengthAt(0)));
    }

    protected AbstractConditionalDiscreteEmission(AlphabetContainer con, double[][] hyperParams) {
        this(con, hyperParams, hyperParams);
    }

    protected AbstractConditionalDiscreteEmission(AlphabetContainer con, double[][] hyperParams, double[][] initHyperParams) {
        this.con = con;
        this.ess = new double[hyperParams.length];
        this.hyperParams = new double[hyperParams.length][hyperParams[0].length];
        this.initHyperParams = hyperParams == initHyperParams ? this.hyperParams : new double[initHyperParams.length][initHyperParams[0].length];
        for (int i = 0; i < hyperParams.length; ++i) {
            for (int j = 0; j < hyperParams[i].length; ++j) {
                if (hyperParams[i][j] < 0.0) {
                    throw new IllegalArgumentException("Please check the hyper-parameter (" + i + ", " + j + ").");
                }
                this.hyperParams[i][j] = hyperParams[i][j];
                if (this.hyperParams != this.initHyperParams) {
                    this.initHyperParams[i][j] = initHyperParams[i][j];
                }
                int n = i;
                this.ess[n] = this.ess[n] + hyperParams[i][j];
            }
        }
        this.params = new double[hyperParams.length][hyperParams[0].length];
        this.probs = new double[hyperParams.length][hyperParams[0].length];
        this.statistic = new double[hyperParams.length][hyperParams[0].length];
        this.grad = new double[hyperParams.length][hyperParams[0].length];
        this.logNorm = new double[hyperParams.length];
        this.precompute();
    }

    protected AbstractConditionalDiscreteEmission(StringBuffer xml) throws NonParsableException {
        this.fromXML(xml);
    }

    public AbstractConditionalDiscreteEmission clone() throws CloneNotSupportedException {
        AbstractConditionalDiscreteEmission clone = (AbstractConditionalDiscreteEmission)super.clone();
        double[] dArray = clone.colors = this.colors == null ? null : (double[])this.colors.clone();
        if (this.counter != null) {
            clone.counter = (int[])this.counter.clone();
        }
        if (this.ess != null) {
            clone.ess = (double[])this.ess.clone();
        }
        if (this.grad != null) {
            clone.grad = (double[][])this.grad.clone();
        }
        clone.hyperParams = (double[][])ArrayHandler.clone((Cloneable[])this.hyperParams);
        clone.initHyperParams = (double[][])ArrayHandler.clone((Cloneable[])this.initHyperParams);
        if (this.logNorm != null) {
            clone.logNorm = (double[])this.logNorm.clone();
        }
        clone.params = (double[][])ArrayHandler.clone((Cloneable[])this.params);
        if (this.paramsFile != null) {
            clone.paramsFile = new File[this.paramsFile.length];
            try {
                for (int i = 0; i < this.paramsFile.length; ++i) {
                    if (this.paramsFile[i] == null) continue;
                    clone.paramsFile[i] = this.createFile();
                    FileManager.copy(this.paramsFile[i].getAbsolutePath(), clone.paramsFile[i].getAbsolutePath());
                }
            }
            catch (IOException e) {
                CloneNotSupportedException c = new CloneNotSupportedException(e.getMessage());
                c.setStackTrace(e.getStackTrace());
                throw c;
            }
        }
        clone.probs = (double[][])ArrayHandler.clone((Cloneable[])this.probs);
        clone.reader = null;
        clone.statistic = (double[][])ArrayHandler.clone((Cloneable[])this.statistic);
        clone.writer = null;
        return clone;
    }

    public void setShape(String shape) {
        this.shape = shape;
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] gradient, int offset) {
        for (int i = 0; i < this.params.length; ++i) {
            int j = 0;
            while (j < this.params[i].length) {
                int n = offset + this.offset;
                gradient[n] = gradient[n] + (this.hyperParams[i][j] - this.ess[i] * this.probs[i][j]);
                ++j;
                ++offset;
            }
        }
    }

    @Override
    public double getLogPriorTerm() {
        double res = 0.0;
        for (int i = 0; i < this.params.length; ++i) {
            if (!(this.ess[i] > 0.0)) continue;
            res += -this.ess[i] * this.logNorm[i];
            for (int j = 0; j < this.params[i].length; ++j) {
                res += this.hyperParams[i][j] * this.params[i][j];
            }
        }
        return res;
    }

    @Override
    public double getLogProbAndPartialDerivationFor(boolean forward, int startPos, int endPos, IntList indices, DoubleList partDer, Sequence seq) throws OperationNotSupportedException {
        int i;
        int e;
        int s;
        Sequence current;
        if (forward) {
            current = seq;
            s = startPos;
            e = endPos;
        } else {
            current = seq.reverseComplement();
            int len = current.getLength();
            s = len - endPos - 1;
            e = len - startPos - 1;
        }
        int v = e - s + 1;
        double res = 0.0;
        for (int i2 = 0; i2 < this.grad.length; ++i2) {
            Arrays.fill(this.grad[i2], 0.0);
        }
        while (s <= e) {
            int condIdx = this.getConditionIndex(forward, s, seq);
            if (condIdx < 0) {
                return Double.NEGATIVE_INFINITY;
            }
            v = current.discreteVal(s++);
            res -= this.logNorm[condIdx];
            for (i = 0; i < this.grad[condIdx].length; ++i) {
                double[] dArray = this.grad[condIdx];
                int n = i;
                dArray[n] = dArray[n] - this.probs[condIdx][i];
            }
            res += this.params[condIdx][v];
            double[] dArray = this.grad[condIdx];
            int n = v;
            dArray[n] = dArray[n] + 1.0;
        }
        int myOff = 0;
        for (i = 0; i < this.grad.length; ++i) {
            int j = 0;
            while (j < this.grad[i].length) {
                indices.add(this.offset + myOff);
                partDer.add(this.grad[i][j]);
                ++j;
                ++myOff;
            }
        }
        return res;
    }

    @Override
    public double getLogProbFor(boolean forward, int startPos, int endPos, Sequence seq) throws OperationNotSupportedException {
        int e;
        int s;
        Sequence current;
        if (forward) {
            current = seq;
            s = startPos;
            e = endPos;
        } else {
            current = seq.reverseComplement();
            int len = current.getLength();
            s = len - endPos - 1;
            e = len - startPos - 1;
        }
        double res = 0.0;
        while (s <= e) {
            int condIdx = this.getConditionIndex(forward, s, seq);
            if (condIdx < 0) {
                return Double.NEGATIVE_INFINITY;
            }
            res -= this.logNorm[condIdx];
            res += this.params[condIdx][current.discreteVal(s++)];
        }
        return res;
    }

    @Override
    public void initializeFunctionRandomly() {
        this.drawParameters(this.initHyperParams, true);
    }

    protected void precompute() {
        Arrays.fill(this.logNorm, 0.0);
        for (int i = 0; i < this.params.length; ++i) {
            this.logNorm[i] = Normalisation.getLogSum(this.params[i]);
            for (int j = 0; j < this.params[i].length; ++j) {
                this.probs[i][j] = Math.exp(this.params[i][j] - this.logNorm[i]);
            }
        }
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.params, "params");
        XMLParser.appendObjectWithTags(xml, this.offset, "offset");
        XMLParser.appendObjectWithTags(xml, this.con, "alphabetContainer");
        XMLParser.appendObjectWithTags(xml, this.hyperParams, "hyperParams");
        XMLParser.appendObjectWithTags(xml, this.initHyperParams, "initHyperParams");
        XMLParser.appendObjectWithTags(xml, this.statistic, "statistic");
        XMLParser.appendObjectWithTags(xml, this.ess, "ess");
        XMLParser.appendObjectWithTags(xml, this.shape, "shape");
        XMLParser.appendObjectWithTags(xml, this.linear, "linear");
        if (this.writer != null) {
            throw new RuntimeException("could not parse SamplingHigherOrderTransition to XML while sampling");
        }
        XMLParser.appendObjectWithTags(xml, this.paramsFile != null, "hasParameters");
        if (this.paramsFile != null) {
            try {
                XMLParser.appendObjectWithTags(xml, this.counter, "counter");
                for (int i = 0; i < this.paramsFile.length; ++i) {
                    String content = this.paramsFile[i] != null ? FileManager.readFile(this.paramsFile[i]).toString() : "";
                    XMLParser.appendObjectWithTagsAndAttributes(xml, content, "fileContent", "pos=\"" + i + "\"");
                }
            }
            catch (IOException e) {
                RuntimeException r = new RuntimeException(e.getMessage());
                r.setStackTrace(e.getStackTrace());
                throw r;
            }
        }
        this.appendFurtherInformation(xml);
        XMLParser.addTags(xml, XML_TAG);
        return xml;
    }

    protected void appendFurtherInformation(StringBuffer xml) {
    }

    protected void fromXML(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, XML_TAG);
        this.params = (double[][])XMLParser.extractObjectForTags(xml, "params");
        this.probs = new double[this.params.length][this.params[0].length];
        this.grad = new double[this.params.length][this.params[0].length];
        this.logNorm = new double[this.params.length];
        this.precompute();
        this.offset = (Integer)XMLParser.extractObjectForTags(xml, "offset");
        this.con = (AlphabetContainer)XMLParser.extractObjectForTags(xml, "alphabetContainer");
        this.hyperParams = (double[][])XMLParser.extractObjectForTags(xml, "hyperParams");
        try {
            this.initHyperParams = (double[][])XMLParser.extractObjectForTags(xml, "initHyperParams");
        }
        catch (NonParsableException e) {
            try {
                this.initHyperParams = (double[][])ArrayHandler.clone((Cloneable[])this.hyperParams);
            }
            catch (CloneNotSupportedException ex) {
                // empty catch block
            }
        }
        this.statistic = (double[][])XMLParser.extractObjectForTags(xml, "statistic");
        this.ess = (double[])XMLParser.extractObjectForTags(xml, "ess");
        try {
            this.shape = XMLParser.extractObjectForTags(xml, "shape", String.class);
            this.linear = XMLParser.extractObjectForTags(xml, "linear", Boolean.TYPE);
        }
        catch (NonParsableException e) {
            this.shape = null;
            this.linear = false;
        }
        if (XMLParser.extractObjectForTags(xml, "hasParameters", Boolean.TYPE).booleanValue()) {
            this.counter = XMLParser.extractObjectForTags(xml, "counter", int[].class);
            this.paramsFile = new File[this.counter.length];
            try {
                TreeMap<String, String> filter = new TreeMap<String, String>();
                for (int i = 0; i < this.paramsFile.length; ++i) {
                    filter.clear();
                    filter.put("pos", "" + i);
                    String content = XMLParser.extractObjectAndAttributesForTags(xml, "fileContent", null, filter, String.class);
                    if (content.equalsIgnoreCase("")) continue;
                    this.paramsFile[i] = this.createFile();
                    FileManager.writeFile(this.paramsFile[i], (CharSequence)new StringBuffer(content));
                }
            }
            catch (IOException e) {
                NonParsableException n = new NonParsableException(e.getMessage());
                n.setStackTrace(e.getStackTrace());
                throw n;
            }
        } else {
            this.counter = null;
            this.paramsFile = null;
        }
        this.writer = null;
        this.reader = null;
        this.extractFurtherInformation(xml);
    }

    protected void extractFurtherInformation(StringBuffer xml) throws NonParsableException {
    }

    @Override
    public void joinStatistics(Emission ... emissions) {
        int j;
        int i;
        for (i = 0; i < emissions.length; ++i) {
            if (emissions[i] == this) continue;
            for (j = 0; j < this.statistic.length; ++j) {
                for (int k = 0; k < this.statistic[j].length; ++k) {
                    double[] dArray = this.statistic[j];
                    int n = k;
                    dArray[n] = dArray[n] + ((AbstractConditionalDiscreteEmission)emissions[i]).statistic[j][k];
                }
            }
        }
        for (i = 0; i < emissions.length; ++i) {
            if (emissions[i] == this) continue;
            for (j = 0; j < this.statistic.length; ++j) {
                System.arraycopy(this.statistic[j], 0, ((AbstractConditionalDiscreteEmission)emissions[i]).statistic[j], 0, this.statistic[j].length);
            }
        }
    }

    @Override
    public void addToStatistic(boolean forward, int startPos, int endPos, double weight, Sequence seq) throws OperationNotSupportedException {
        int e;
        int s;
        Sequence current;
        if (forward) {
            current = seq;
            s = startPos;
            e = endPos;
        } else {
            current = seq.reverseComplement();
            int len = current.getLength();
            s = len - endPos - 1;
            e = len - startPos - 1;
        }
        while (s <= e) {
            int condIdx = this.getConditionIndex(forward, s, seq);
            double[] dArray = this.statistic[condIdx];
            int n = current.discreteVal(s++);
            dArray[n] = dArray[n] + weight;
        }
    }

    protected abstract int getConditionIndex(boolean var1, int var2, Sequence var3);

    @Override
    public void estimateFromStatistic() {
        for (int j = 0; j < this.statistic.length; ++j) {
            int i;
            double sum = 0.0;
            for (i = 0; i < this.statistic[j].length; ++i) {
                double[] dArray = this.statistic[j];
                int n = i;
                dArray[n] = dArray[n] + this.hyperParams[j][i];
                sum += this.statistic[j][i];
            }
            if (sum == 0.0) {
                Arrays.fill(this.statistic[j], 1.0);
                sum = this.statistic[j].length;
            }
            for (i = 0; i < this.statistic[j].length; ++i) {
                this.probs[j][i] = this.statistic[j][i] / sum;
                this.params[j][i] = Math.log(this.probs[j][i]);
            }
        }
        Arrays.fill(this.logNorm, 0.0);
    }

    @Override
    public void resetStatistic() {
        for (int i = 0; i < this.hyperParams.length; ++i) {
            Arrays.fill(this.statistic[i], 0.0);
        }
    }

    @Override
    public void setParameter(double[] params, int offset) {
        for (int i = 0; i < this.params.length; ++i) {
            int j = 0;
            while (j < this.params[i].length) {
                this.params[i][j] = params[this.offset + offset];
                ++j;
                ++offset;
            }
        }
        this.precompute();
    }

    @Override
    public AlphabetContainer getAlphabetContainer() {
        return this.con;
    }

    @Override
    public void fillCurrentParameter(double[] params) {
        int myOffset = this.offset;
        for (int i = 0; i < this.params.length; ++i) {
            int j = 0;
            while (j < this.params[i].length) {
                params[myOffset] = this.params[i][j];
                ++j;
                ++myOffset;
            }
        }
    }

    @Override
    public int setParameterOffset(int offset) {
        this.offset = offset;
        for (int i = 0; i < this.params.length; ++i) {
            offset += this.params[i].length;
        }
        return offset;
    }

    protected void drawParameters(double[][] hyper, boolean uniformBackup) {
        for (int j = 0; j < this.probs.length; ++j) {
            double ess = 0.0;
            if (uniformBackup) {
                for (int i = 0; i < hyper[j].length; ++i) {
                    ess += hyper[j][i];
                }
            }
            DiMRGParams p = uniformBackup && ess == 0.0 ? new FastDirichletMRGParams(1.0) : new DirichletMRGParams(hyper[j]);
            DirichletMRG.DEFAULT_INSTANCE.generateLog(this.params[j], 0, hyper[j].length, p);
        }
        this.precompute();
    }

    @Override
    public void drawParametersFromStatistic() {
        for (int j = 0; j < this.probs.length; ++j) {
            for (int i = 0; i < this.statistic[j].length; ++i) {
                this.params[i][j] = this.statistic[i][j] + this.hyperParams[i][j];
            }
        }
        this.drawParameters(this.params, false);
    }

    @Override
    public double getLogGammaScoreFromStatistic() {
        double[][] hyper = AbstractConditionalDiscreteEmission.getHyperParams(this.ess, (int)this.con.getAlphabetLengthAt(0));
        double res = Double.NEGATIVE_INFINITY;
        for (int j = 0; j < this.ess.length; ++j) {
            double sum = 0.0;
            for (double i : hyper[j]) {
                sum += i;
            }
            res = Gamma.logOfGamma((double)sum);
            for (int i = 0; i < hyper.length; ++i) {
                res += Gamma.logOfGamma((double)this.statistic[j][i]) - Gamma.logOfGamma((double)hyper[j][i]);
            }
            sum = 0.0;
            for (double i : this.statistic[j]) {
                sum += i;
            }
            res -= Gamma.logOfGamma((double)sum);
        }
        return res;
    }

    @Override
    public void acceptParameters() throws IOException {
        int n = this.samplingIndex;
        int n2 = this.counter[n];
        this.counter[n] = n2 + 1;
        this.writer.write("" + n2);
        for (int i = 0; i < this.params.length; ++i) {
            for (int j = 0; j < this.params[i].length; ++j) {
                this.writer.write("\t" + this.params[i][j]);
            }
        }
        this.writer.write("\n");
        this.writer.flush();
    }

    @Override
    public double getLogPosteriorFromStatistic() {
        double logPost = 0.0;
        for (int i = 0; i < this.params.length; ++i) {
            for (int j = 0; j < this.params[i].length; ++j) {
                logPost += this.statistic[i][j] * (this.params[i][j] - this.logNorm[i]);
            }
        }
        return logPost;
    }

    @Override
    public void extendSampling(int start, boolean append) throws IOException {
        if (this.paramsFile[start] == null) {
            this.paramsFile[start] = this.createFile();
        } else if (append) {
            this.parseParameterSet(start, this.counter[start] - 1);
            this.reader.close();
            this.reader = null;
        } else {
            this.counter[start] = 0;
        }
        this.writer = new BufferedWriter(new FileWriter(this.paramsFile[start], append));
        this.samplingIndex = start;
    }

    @Override
    public void initForSampling(int starts) throws IOException {
        for (int i = 0; i < this.hyperParams.length; ++i) {
            for (int j = 0; j < this.hyperParams[i].length; ++j) {
                if (Double.isNaN(this.hyperParams[i][j]) || !(this.hyperParams[i][j] <= 0.0)) continue;
                throw new IllegalArgumentException("All (not NAN) hyper-parameters must have a value > 0. Please check the hyper-parameter " + i + ".");
            }
        }
        if (this.paramsFile != null && this.paramsFile.length == starts) {
            for (int i = 0; i < starts; ++i) {
                if (this.paramsFile[i] != null) {
                    FileOutputStream o = new FileOutputStream(this.paramsFile[i]);
                    o.close();
                }
                this.counter[i] = 0;
            }
        } else {
            this.deleteParameterFiles();
            this.paramsFile = new File[starts];
            this.counter = new int[starts];
        }
    }

    private void deleteParameterFiles() {
        if (this.paramsFile != null) {
            for (int i = 0; i < this.paramsFile.length; ++i) {
                if (this.paramsFile[i] == null) continue;
                this.paramsFile[i].delete();
            }
        }
    }

    @Override
    public boolean isInSamplingMode() {
        return this.writer != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean parseNextParameterSet() {
        if (this.writer != null) {
            return false;
        }
        String str = null;
        try {
            str = this.reader.readLine();
        }
        catch (IOException iOException) {
            if (str == null) {
                return false;
            }
        }
        finally {
            if (str == null) {
                return false;
            }
        }
        this.parse(str);
        return true;
    }

    @Override
    public boolean parseParameterSet(int start, int n) throws IOException {
        String str;
        if (this.reader != null) {
            this.reader.close();
        }
        this.reader = new BufferedReader(new FileReader(this.paramsFile[start]));
        while ((str = this.reader.readLine()) != null) {
            if (Integer.parseInt(str.substring(0, str.indexOf("\t"))) != n) continue;
            this.parse(str);
            return true;
        }
        return false;
    }

    private void parse(String str) {
        String[] strArray = str.split("\t");
        int offset = 1;
        for (int i = 0; i < this.params.length; ++i) {
            for (int j = 0; j < this.params[i].length; ++j) {
                this.params[i][j] = Double.parseDouble(strArray[offset++]);
                this.probs[i][j] = Math.exp(this.params[i][j]);
            }
            this.logNorm[i] = 0.0;
        }
    }

    @Override
    public void samplingStopped() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    protected void finalize() throws Throwable {
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.reader != null) {
            this.reader.close();
        }
        this.deleteParameterFiles();
        super.finalize();
    }

    @Override
    public String getNodeShape(boolean forward) {
        String res;
        if (this.shape == null) {
            res = "";
            if (this.getAlphabetContainer().isReverseComplementable()) {
                res = res + "\"house\", orientation=";
                if (forward) {
                    res = res + "-";
                }
                res = res + "90";
            } else {
                res = res + "\"box\"";
            }
        } else {
            res = "\"" + this.shape + "\"";
        }
        return res;
    }

    @Override
    public String getNodeLabel(double weight, String name, NumberFormat nf) {
        if (weight < 0.0) {
            return "\"" + name + "\"";
        }
        StringBuffer buf = new StringBuffer();
        String namelabel = name;
        if (weight < 0.5) {
            namelabel = "<font color=\"white\">" + namelabel + "</font>";
        }
        buf.append("<<table border=\"0\" cellspacing=\"0\"><tr><td colspan=\"" + ((this.probs.length > 1 ? 1 : 0) + this.probs[0].length) + "\">" + namelabel + "</td></tr>");
        DiscreteAlphabet abc = (DiscreteAlphabet)this.con.getAlphabetAt(0);
        buf.append("<tr>");
        if (this.probs.length > 1) {
            buf.append("<td></td>");
        }
        for (int j = 0; j < this.probs[0].length; ++j) {
            buf.append("<td border=\"0\">");
            if (weight < 0.5) {
                buf.append("<font color=\"white\">" + abc.getSymbolAt(j) + "</font>");
            } else {
                buf.append(abc.getSymbolAt(j));
            }
            buf.append("</td>");
        }
        buf.append("</tr>");
        for (int i = 0; i < this.probs.length; ++i) {
            buf.append("<tr>");
            if (this.probs.length > 1) {
                buf.append("<td border=\"0\">");
                if (weight < 0.5) {
                    buf.append("<font color=\"white\">" + abc.getSymbolAt(i) + "</font>");
                } else {
                    buf.append(abc.getSymbolAt(i));
                }
                buf.append("</td>");
            }
            double[] trans = this.transformProbs(this.probs[i]);
            double en = (this.getInformationContent(this.probs[i]) + 2.0) / 3.0;
            for (int j = 0; j < this.probs[i].length; ++j) {
                buf.append("<td border=\"1\" width=\"25\" height=\"25\" bgcolor=\"" + this.getColor(j) + " " + trans[j] + " " + en + "\">");
                if (nf != null) {
                    buf.append(nf.format(this.probs[i][j]));
                }
                buf.append("</td>");
            }
            buf.append("</tr>");
        }
        buf.append("</table>>");
        return buf.toString();
    }

    private double getColor(int j) {
        if (this.colors == null) {
            this.colors = ToolBox.getUniqueHueValues((int)this.con.getAlphabetLengthAt(0));
        }
        return this.colors[j];
    }

    public void setLinear(boolean linear) {
        this.linear = linear;
    }

    private double getInformationContent(double[] probs) {
        double max = Math.log(probs.length);
        double en = 0.0;
        for (int i = 0; i < probs.length; ++i) {
            if (!(probs[i] > 0.0)) continue;
            en -= probs[i] * Math.log(probs[i]);
        }
        return (max - en) / max;
    }

    private double[] transformProbs(double[] probs) {
        if (this.linear) {
            return (double[])probs.clone();
        }
        double[] trans = new double[probs.length];
        double a = 15.0;
        double b = 4.0;
        for (int i = 0; i < probs.length; ++i) {
            trans[i] = 1.0 / (1.0 + Math.exp(-a * probs[i] + b));
        }
        return trans;
    }

    @Override
    public void fillSamplingGroups(int parameterOffset, LinkedList<int[]> list) {
        int off = 0;
        for (int i = 0; i < this.params.length; ++i) {
            int[] idxs = new int[this.params[i].length];
            for (int j = 0; j < idxs.length; ++j) {
                idxs[j] = j + off + this.offset + parameterOffset;
            }
            list.add(idxs);
            off += idxs.length;
        }
    }

    @Override
    public int getNumberOfParameters() {
        return this.params.length * this.params[0].length;
    }

    @Override
    public int getSizeOfEventSpace() {
        return this.params.length * this.params[0].length;
    }

    private File createFile() throws IOException {
        return File.createTempFile("samplingDEmission-", ".dat", null);
    }

    @Override
    public void setParameters(Emission t) throws IllegalArgumentException {
        if (!t.getClass().equals(this.getClass()) || ((AbstractConditionalDiscreteEmission)t).params.length != this.params.length) {
            throw new IllegalArgumentException("The transitions are not comparable.");
        }
        AbstractConditionalDiscreteEmission tt = (AbstractConditionalDiscreteEmission)t;
        for (int i = 0; i < this.params.length; ++i) {
            System.arraycopy(tt.params[i], 0, this.params[i], 0, tt.params[i].length);
        }
        this.precompute();
    }
}

