/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils;

import de.jstacs.classifiers.utils.PValueComputation;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.ComplementableDiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.utils.ComparableElement;
import de.jstacs.utils.ToolBox;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Random;

public class PFMComparator {
    private static Random r = new Random();

    public static String matrixToString(double[][] matrix) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < matrix.length; ++i) {
            sb.append(matrix[i][0]);
            for (int j = 1; j < matrix[i].length; ++j) {
                sb.append('\t');
                sb.append(matrix[i][j]);
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String getConsensus(AlphabetContainer con, double[][] pfm) {
        String c = "";
        for (int l = 0; l < pfm.length; ++l) {
            int m = 0;
            for (int p = 1; p < pfm[l].length; ++p) {
                if (!(pfm[l][m] < pfm[l][p])) continue;
                m = p;
            }
            c = c + con.getSymbol(l, m);
        }
        return c;
    }

    public static double[] getCounts(DataSet ... data) {
        double[] counts = new double[(int)data[0].getAlphabetContainer().getAlphabetLengthAt(0)];
        for (int d = 0; d < data.length; ++d) {
            for (int n = 0; n < data[d].getNumberOfElements(); ++n) {
                Sequence seq = data[d].getElementAt(n);
                for (int l = 0; l < seq.getLength(); ++l) {
                    int n2 = seq.discreteVal(l);
                    counts[n2] = counts[n2] + 1.0;
                }
            }
        }
        return counts;
    }

    public static void normalize(double[] counts) {
        int l;
        double sum = 0.0;
        for (l = 0; l < counts.length; ++l) {
            sum += counts[l];
        }
        l = 0;
        while (l < counts.length) {
            int n = l++;
            counts[n] = counts[n] / sum;
        }
    }

    public static double[][] getPFM(DataSet data) {
        return PFMComparator.getPFM(data, 0, data.getNumberOfElements());
    }

    public static double[][] getPFM(DataSet data, int start, int end) {
        if (data == null) {
            return null;
        }
        double[][] pfm = new double[data.getElementLength()][];
        AlphabetContainer con = data.getAlphabetContainer();
        for (int l = 0; l < pfm.length; ++l) {
            pfm[l] = new double[(int)con.getAlphabetLengthAt(l)];
        }
        for (int n = start; n < end; ++n) {
            Sequence seq = data.getElementAt(n);
            for (int l = 0; l < pfm.length; ++l) {
                double[] dArray = pfm[l];
                int n2 = seq.discreteVal(l);
                dArray[n2] = dArray[n2] + 1.0;
            }
        }
        return pfm;
    }

    public static double[][] getPWM(DataSet data, int start, int end) {
        double[][] pwm = PFMComparator.getPFM(data, start, end);
        for (int i = 0; i < pwm.length; ++i) {
            PFMComparator.normalize(pwm[i]);
        }
        return pwm;
    }

    public static double[][] getPFM(DataSet data, double[] weights) {
        if (data == null) {
            return null;
        }
        double[][] pfm = new double[data.getElementLength()][];
        AlphabetContainer con = data.getAlphabetContainer();
        for (int l = 0; l < pfm.length; ++l) {
            pfm[l] = new double[(int)con.getAlphabetLengthAt(l)];
        }
        for (int n = 0; n < data.getNumberOfElements(); ++n) {
            Sequence seq = data.getElementAt(n);
            for (int l = 0; l < pfm.length; ++l) {
                double[] dArray = pfm[l];
                int n2 = seq.discreteVal(l);
                dArray[n2] = dArray[n2] + weights[n];
            }
        }
        return pfm;
    }

    public static double[][] getReverseComplement(ComplementableDiscreteAlphabet abc, double[][] pfm) {
        int length = pfm.length;
        int symbols = (int)abc.length();
        double[][] pfmRC = new double[length][symbols];
        for (int l = 0; l < length; ++l) {
            for (int a = 0; a < symbols; ++a) {
                pfmRC[l][a] = pfm[length - 1 - l][abc.getComplementaryCode(a)];
            }
        }
        return pfmRC;
    }

    public static ArrayList<AbstractMap.SimpleEntry<String, double[][]>> readPFMsFromUniprobe(String startdir) throws IOException {
        LinkedList<File> dirs = new LinkedList<File>();
        dirs.add(new File(startdir));
        ArrayList<AbstractMap.SimpleEntry<String, double[][]>> res = new ArrayList<AbstractMap.SimpleEntry<String, double[][]>>();
        ArrayList strs = new ArrayList();
        while (dirs.size() > 0) {
            File dir = (File)dirs.pop();
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory() && !files[i].isHidden()) {
                    dirs.add(files[i]);
                    continue;
                }
                if (!files[i].getName().endsWith(".txt") && !files[i].getName().endsWith(".pwm")) continue;
                res.add(PFMComparator.readPFMFromUniprobe(dir.getName(), files[i]));
            }
        }
        return res;
    }

    public static AbstractMap.SimpleEntry<String, double[][]> readPFMFromUniprobe(String annotPrefix, File file) throws IOException {
        String annot = annotPrefix + file.getName().substring(0, file.getName().lastIndexOf(46));
        BufferedReader read = new BufferedReader(new FileReader(file));
        String temp = read.readLine();
        annot = annot + ": " + (temp == null ? "" : temp.trim());
        String line = null;
        ArrayList<String> strs = new ArrayList<String>();
        while ((line = read.readLine()) != null) {
            if ((line = line.trim()).length() <= 0) continue;
            strs.add(line);
        }
        read.close();
        String[] strings = new String[4];
        int j = strs.size() - 4;
        int k = 0;
        while (j < strs.size()) {
            strings[k] = (String)strs.get(j);
            if (strings[k].indexOf(58) >= 0) {
                strings[k] = strings[k].substring(strings[k].indexOf(58) + 1).trim();
            }
            ++j;
            ++k;
        }
        String[] parts = strings[0].split("\\s+");
        double[][] pwm = new double[parts.length][4];
        for (int j2 = 0; j2 < strings.length; ++j2) {
            parts = strings[j2].split("\\s+");
            if (parts.length != pwm.length) {
                throw new RuntimeException();
            }
            for (int k2 = 0; k2 < parts.length; ++k2) {
                pwm[k2][j2] = Double.parseDouble(parts[k2]);
            }
        }
        return new AbstractMap.SimpleEntry<String, double[][]>(annot, pwm);
    }

    public static ArrayList<AbstractMap.SimpleEntry<String, double[][]>> readPFMsFromJasparFastA(String filename) throws IOException {
        BufferedReader r = new BufferedReader(new FileReader(new File(filename)));
        ArrayList<AbstractMap.SimpleEntry<String, double[][]>> res = PFMComparator.readPFMsFromJasparFastA(r);
        r.close();
        return res;
    }

    public static ArrayList<AbstractMap.SimpleEntry<String, double[][]>> readPFMsFromJasparFastA(BufferedReader r) throws IOException {
        String line;
        ArrayList<AbstractMap.SimpleEntry<String, double[][]>> res = new ArrayList<AbstractMap.SimpleEntry<String, double[][]>>();
        String annot = null;
        double[][] mat = null;
        int i = 0;
        while ((line = r.readLine()) != null) {
            if ((line = line.trim()).length() <= 0) continue;
            if (line.startsWith(">")) {
                if (mat != null) {
                    res.add(new AbstractMap.SimpleEntry<String, double[][]>(annot, mat));
                    annot = null;
                    mat = null;
                }
                annot = line.substring(1).trim();
                i = 0;
                continue;
            }
            line = line.substring(line.indexOf(91) + 1, line.lastIndexOf(93)).trim();
            String[] parts = line.split("\\s+");
            if (mat == null) {
                mat = new double[parts.length][4];
            }
            for (int j = 0; j < parts.length; ++j) {
                mat[j][i] = Double.parseDouble(parts[j]);
            }
            ++i;
        }
        if (mat != null) {
            res.add(new AbstractMap.SimpleEntry<Object, double[][]>(annot, mat));
        }
        return res;
    }

    public static ArrayList<AbstractMap.SimpleEntry<String, double[][]>> readPFMsFromEMBL(String fileName, int max) throws IOException {
        String line;
        ArrayList<AbstractMap.SimpleEntry<String, double[][]>> res = new ArrayList<AbstractMap.SimpleEntry<String, double[][]>>();
        ArrayList<double[]> pfm = new ArrayList<double[]>();
        double[][] tooSmall = new double[][]{};
        BufferedReader r = new BufferedReader(new FileReader(new File(fileName)));
        while (res.size() < max && (line = r.readLine()) != null) {
            if (!line.startsWith("AC")) continue;
            String annot = line.substring(line.indexOf(32)).trim();
            while (!(line = r.readLine()).startsWith("ID")) {
            }
            annot = annot + " (" + line.substring(line.indexOf(32)).trim() + ")";
            while (!(line = r.readLine()).startsWith("01")) {
            }
            pfm.clear();
            do {
                String[] split = line.split("[ ]+");
                double[] positionalFrequencies = new double[split.length - 2];
                for (int a = 0; a < positionalFrequencies.length; ++a) {
                    positionalFrequencies[a] = Double.parseDouble(split[1 + a]);
                }
                pfm.add(positionalFrequencies);
            } while (!(line = r.readLine()).startsWith("XX"));
            res.add(new AbstractMap.SimpleEntry<String, T[]>(annot, pfm.toArray((T[])tooSmall)));
            while (!(line = r.readLine()).startsWith("//")) {
            }
        }
        r.close();
        return res;
    }

    public static ArrayList<AbstractMap.SimpleEntry<String, double[][]>> readPFMsFromTransfac(String fileName, int max) throws IOException {
        String line;
        ArrayList<AbstractMap.SimpleEntry<String, double[][]>> res = new ArrayList<AbstractMap.SimpleEntry<String, double[][]>>();
        ArrayList<double[]> pfm = new ArrayList<double[]>();
        double[][] tooSmall = new double[][]{};
        BufferedReader r = new BufferedReader(new FileReader(new File(fileName)));
        while (res.size() < max && (line = r.readLine()) != null) {
            while (!line.startsWith("DE")) {
                line = r.readLine();
            }
            String annot = line.substring(line.indexOf("DE") + 2).trim();
            while (!(line = r.readLine()).matches("^[0-9]+.*")) {
            }
            pfm.clear();
            do {
                String[] split = line.split("[ \\t]+");
                double[] positionalFrequencies = new double[split.length - 2];
                for (int a = 0; a < positionalFrequencies.length; ++a) {
                    positionalFrequencies[a] = Double.parseDouble(split[1 + a]);
                }
                pfm.add(positionalFrequencies);
            } while (!(line = r.readLine()).startsWith("XX"));
            res.add(new AbstractMap.SimpleEntry<String, T[]>(annot, pfm.toArray((T[])tooSmall)));
        }
        r.close();
        return res;
    }

    public static ComparableElement<String, Double>[] find(ComplementableDiscreteAlphabet abc, double[][] pfm, ArrayList<AbstractMap.SimpleEntry<String, double[][]>> knownPFMs, PFMDistance distance, int minOverlap, int allowMiniShift, boolean pValues, double threshold) {
        int i;
        ArrayList<ComparableElement<String, Double>> list = new ArrayList<ComparableElement<String, Double>>(10);
        double[][] pfmRC = PFMComparator.getReverseComplement(abc, pfm);
        int m = Math.min(minOverlap, pfm.length - allowMiniShift);
        int columns = 0;
        Hashtable<Integer, double[]> scores = new Hashtable<Integer, double[]>();
        if (pValues) {
            for (i = 0; i < knownPFMs.size(); ++i) {
                columns += knownPFMs.get(i).getValue().length;
            }
        }
        for (i = 0; i < knownPFMs.size(); ++i) {
            double[][] currentCand = knownPFMs.get(i).getValue();
            int myMinimalOverlap = Math.min(m, currentCand.length - allowMiniShift);
            double d = Math.min(distance.compare(pfm, currentCand, myMinimalOverlap), distance.compare(pfmRC, currentCand, myMinimalOverlap));
            if (pValues) {
                double[] values = (double[])scores.get(currentCand.length);
                if (values == null) {
                    values = new double[1000];
                    double[][] randomPFM = new double[currentCand.length][];
                    for (int n = 0; n < values.length; ++n) {
                        for (int l = 0; l < randomPFM.length; ++l) {
                            int len;
                            int c = r.nextInt(columns);
                            int idx = 0;
                            while ((len = knownPFMs.get(idx).getValue().length) <= c) {
                                c -= len;
                                ++idx;
                            }
                            randomPFM[l] = knownPFMs.get(idx).getValue()[c];
                        }
                        values[n] = Math.min(distance.compare(pfm, randomPFM, myMinimalOverlap), distance.compare(pfmRC, randomPFM, myMinimalOverlap));
                    }
                    Arrays.sort(values);
                    scores.put(currentCand.length, values);
                }
                d = PValueComputation.getPValue(values, d);
            }
            if (!(d <= threshold)) continue;
            list.add(new ComparableElement<String, Double>(knownPFMs.get(i).getKey(), d));
        }
        Object[] res = list.toArray(new ComparableElement[0]);
        Arrays.sort(res);
        return res;
    }

    public static class SymmetricKullbackLeiblerDivergence
    extends PFMDistance {
        private double ess;

        public SymmetricKullbackLeiblerDivergence(double ess) throws IllegalArgumentException {
            if (ess < 0.0) {
                throw new IllegalArgumentException("The ess has to be non-negative.");
            }
            this.ess = ess;
        }

        @Override
        protected double getDistance(double[][] pfm1, double[][] pfm2, int l1, int l2) {
            double res = 0.0;
            int l = 0;
            while (l1 < pfm1.length && l2 < pfm2.length) {
                int a;
                double sum2;
                if (pfm1[l1].length != pfm2[l2].length) {
                    throw new IllegalArgumentException("The PFMs are not comparable at column " + l1 + " and " + l2 + ".");
                }
                double sum1 = sum2 = this.ess;
                double pc = this.ess / (double)pfm1[l1].length;
                for (a = 0; a < pfm1[l1].length; ++a) {
                    sum1 += pfm1[l1][a];
                    sum2 += pfm2[l2][a];
                }
                for (a = 0; a < pfm1[l1].length; ++a) {
                    double p1_a = (pc + pfm1[l1][a]) / sum1;
                    double p2_a = (pc + pfm2[l2][a]) / sum2;
                    res += (p1_a - p2_a) * Math.log(p1_a / p2_a);
                }
                ++l1;
                ++l2;
                ++l;
            }
            return 1.0 / (2.0 * (double)l) * res;
        }
    }

    public static class OneMinusPearsonCorrelationCoefficient
    extends PFMDistance {
        @Override
        protected double getDistance(double[][] pfm1, double[][] pfm2, int l1, int l2) {
            double res = 0.0;
            int l = 0;
            while (l1 < pfm1.length && l2 < pfm2.length) {
                int a;
                if (pfm1[l1].length != pfm2[l2].length) {
                    throw new IllegalArgumentException("The PFMs are not comparable at column " + l1 + " and " + l2 + ".");
                }
                double sum2 = 0.0;
                double sum1 = 0.0;
                for (a = 0; a < pfm1[l1].length; ++a) {
                    sum1 += pfm1[l1][a];
                    sum2 += pfm2[l2][a];
                }
                double s2 = 0.0;
                double s1 = 0.0;
                double s = 0.0;
                for (a = 0; a < pfm1[l1].length; ++a) {
                    double d1 = pfm1[l1][a] / sum1 - 0.25;
                    double d2 = pfm2[l2][a] / sum2 - 0.25;
                    s += d1 * d2;
                    s1 += d1 * d1;
                    s2 += d2 * d2;
                }
                if (s1 > 0.0 && s2 > 0.0) {
                    res += s / Math.sqrt(s1 * s2);
                }
                ++l1;
                ++l2;
                ++l;
            }
            return 1.0 - 1.0 / (double)l * res;
        }
    }

    public static class NormalizedEuclideanDistance
    extends PFMDistance {
        @Override
        protected double getDistance(double[][] pfm1, double[][] pfm2, int l1, int l2) {
            double res = 0.0;
            int l = 0;
            while (l1 < pfm1.length && l2 < pfm2.length) {
                int a;
                if (pfm1[l1].length != pfm2[l2].length) {
                    throw new IllegalArgumentException("The PFMs are not comparable at column " + l1 + " and " + l2 + ".");
                }
                double sum2 = 0.0;
                double sum1 = 0.0;
                for (a = 0; a < pfm1[l1].length; ++a) {
                    sum1 += pfm1[l1][a];
                    sum2 += pfm2[l2][a];
                }
                double sum = 0.0;
                for (a = 0; a < pfm1[l1].length; ++a) {
                    double diff = pfm1[l1][a] / sum1 - pfm2[l2][a] / sum2;
                    sum += diff * diff;
                }
                res += Math.sqrt(sum);
                ++l1;
                ++l2;
                ++l;
            }
            return res / (Math.sqrt(2.0) * (double)l);
        }
    }

    public static class UniformBorderWrapper
    extends PFMDistance {
        private PFMDistance inner;

        public UniformBorderWrapper(PFMDistance inner) {
            this.inner = inner;
        }

        @Override
        protected double getDistance(double[][] pfm1, double[][] pfm2, int l1, int l2) {
            int i;
            System.out.print(l1 + " " + l2 + " ");
            double tempDist = this.inner.getDistance(pfm1, pfm2, l1, l2);
            System.out.print(tempDist + " ");
            Object p1 = null;
            Object p2 = null;
            if (l1 > 0 && l2 > 0) {
                int mi = Math.min(l1, l2);
                l1 -= mi;
                l2 -= mi;
            }
            if (l1 > l2) {
                double[][] temp = pfm1;
                pfm1 = pfm2;
                pfm2 = temp;
                int tl = l1;
                l1 = l2;
                l2 = tl;
            }
            int maxlen = Math.max(pfm1.length + l2, pfm2.length + l1);
            p1 = new double[maxlen][];
            p2 = new double[maxlen][];
            double n1 = ToolBox.sum(pfm1[0]);
            double n2 = ToolBox.sum(pfm2[0]);
            double[] c1 = new double[pfm1[0].length];
            for (int i2 = 0; i2 < c1.length; ++i2) {
                c1[i2] = n1 / (double)c1.length;
            }
            double[] c2 = new double[pfm2[0].length];
            for (i = 0; i < c2.length; ++i) {
                c2[i] = n2 / (double)c2.length;
            }
            for (i = 0; i < maxlen; ++i) {
                p1[i] = i < l2 || i >= pfm1.length ? (double[])c1.clone() : pfm1[i - l2];
                p2[i] = i < l1 || i >= pfm2.length ? (double[])c2.clone() : pfm2[i - l1];
            }
            double dist = this.inner.getDistance((double[][])p1, (double[][])p2, 0, 0);
            System.out.println(dist);
            return dist;
        }
    }

    public static abstract class PFMDistance {
        public final double getDistance(double[][] pfm1, double[][] pfm2, int offset) {
            if (offset >= 0) {
                return this.getDistance(pfm1, pfm2, offset, 0);
            }
            return this.getDistance(pfm1, pfm2, 0, -offset);
        }

        protected abstract double getDistance(double[][] var1, double[][] var2, int var3, int var4);

        public double compare(double[][] pfm1, double[][] pfm2, int minimalOverlap) {
            int l1 = pfm1.length;
            int l2 = pfm2.length;
            if (l1 < minimalOverlap || l2 < minimalOverlap) {
                throw new IllegalArgumentException("The PFM are too small to have a minimal overlap of " + minimalOverlap + ".");
            }
            double best = Double.POSITIVE_INFINITY;
            for (int offset = minimalOverlap - l2; offset <= l1 - minimalOverlap; ++offset) {
                double current = this.getDistance(pfm1, pfm2, offset);
                if (!(current < best)) continue;
                best = current;
            }
            return best;
        }
    }
}

