/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences;

import de.jstacs.data.sequences.Sequence;
import javax.naming.OperationNotSupportedException;

public class CyclicSequenceAdaptor<T>
extends Sequence<T> {
    private Sequence<T> seq;
    private int l;
    private int extLength;

    public CyclicSequenceAdaptor(Sequence<T> seq, int extLength) {
        super(seq.getAlphabetContainer(), seq.getAnnotation());
        this.seq = seq;
        this.l = this.seq.getLength();
        this.extLength = extLength;
    }

    public CyclicSequenceAdaptor(Sequence<T> seq) {
        this(seq, seq.getLength());
    }

    @Override
    public int compareTo(Sequence<T> s) {
        return this.seq.compareTo(s);
    }

    @Override
    public double continuousVal(int pos) {
        return this.seq.continuousVal(pos % this.l);
    }

    @Override
    public int discreteVal(int pos) {
        return this.seq.discreteVal(pos % this.l);
    }

    @Override
    protected CyclicSequenceAdaptor<T> flatCloneWithoutAnnotation() {
        return new CyclicSequenceAdaptor<T>(this.seq);
    }

    @Override
    public int getLength() {
        return this.extLength;
    }

    @Override
    protected int compareTo(T t1, T t2) {
        return this.seq.compareTo(t1, t2);
    }

    @Override
    protected Object getEmptyRepresentation() {
        return this.seq.getEmptyRepresentation();
    }

    @Override
    protected void addToRepresentation(Object representation, int pos, String delim) {
        this.seq.addToRepresentation(representation, pos % this.l, delim);
    }

    @Override
    protected String getStringRepresentation(Object representation) {
        return this.seq.getStringRepresentation(representation);
    }

    @Override
    protected int hashCodeForPos(int pos) {
        return this.seq.hashCodeForPos(pos % this.l);
    }

    @Override
    public boolean isMultiDimensional() {
        return this.seq.isMultiDimensional();
    }

    @Override
    public T getEmptyContainer() {
        return this.seq.getEmptyContainer();
    }

    @Override
    public void fillContainer(T container, int pos) {
        this.seq.fillContainer(container, pos % this.l);
    }

    @Override
    public CyclicSequenceAdaptor<T> reverse(int start, int end) throws OperationNotSupportedException {
        return new CyclicSequenceAdaptor<T>(this.seq.reverse(start, end));
    }

    @Override
    public CyclicSequenceAdaptor<T> complement() throws OperationNotSupportedException {
        return new CyclicSequenceAdaptor<T>(this.seq.complement());
    }

    @Override
    public CyclicSequenceAdaptor<T> reverseComplement() throws OperationNotSupportedException {
        return new CyclicSequenceAdaptor<T>(this.seq.reverseComplement());
    }

    @Override
    public CyclicSequenceAdaptor<T> complement(int start, int end) throws OperationNotSupportedException {
        return new CyclicSequenceAdaptor<T>(this.seq.complement(start, end));
    }

    @Override
    public CyclicSequenceAdaptor<T> reverseComplement(int start, int end) throws OperationNotSupportedException {
        return new CyclicSequenceAdaptor<T>(this.seq.reverseComplement(start, end));
    }

    public CyclicSequenceAdaptor<T> getSuperSequence(int length) {
        return new CyclicSequenceAdaptor<T>(this.seq, length);
    }
}

