/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.phylo.parser;

import de.jstacs.io.NonParsableException;
import de.jstacs.sequenceScores.statisticalModels.trainable.phylo.PhyloNode;
import de.jstacs.sequenceScores.statisticalModels.trainable.phylo.PhyloTree;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.EmptyStackException;
import java.util.Stack;

public class NewickParser {
    private StreamTokenizer tokenizer;
    private PhyloNode rootNode;

    public NewickParser(BufferedReader b) {
        this.tokenizer = new StreamTokenizer(b);
        this.tokenizer.eolIsSignificant(false);
        this.tokenizer.quoteChar(34);
        this.tokenizer.wordChars(39, 39);
        this.tokenizer.wordChars(33, 33);
        this.tokenizer.wordChars(35, 38);
        this.tokenizer.wordChars(42, 43);
        this.tokenizer.wordChars(45, 47);
        this.tokenizer.wordChars(60, 60);
        this.tokenizer.wordChars(62, 64);
        this.tokenizer.wordChars(94, 96);
        this.tokenizer.wordChars(123, 126);
    }

    public PhyloTree tokenize() throws NonParsableException {
        int openBracket = 40;
        int closeBracket = 41;
        int childSeparator = 44;
        int infoSeparator = 58;
        boolean EOT = false;
        boolean nameNext = true;
        PhyloNode lastNamed = null;
        Stack<PhyloNode> nodeStack = new Stack<PhyloNode>();
        int id = 0;
        this.rootNode = new PhyloNode();
        this.rootNode.setId(id++);
        PhyloTree tree = new PhyloTree(null, this.rootNode);
        nodeStack.push(this.rootNode);
        try {
            int thisToken;
            block11: while (!EOT && (thisToken = this.tokenizer.nextToken()) != -1) {
                switch (thisToken) {
                    case -3: {
                        if (!nameNext) {
                            System.err.println("Error: didn't expect this name here: " + this.tokenizer.sval);
                        }
                        lastNamed = this.popNodeAndName(this.tokenizer.sval, nodeStack);
                        nameNext = false;
                        continue block11;
                    }
                    case -2: {
                        if (nameNext) {
                            lastNamed = this.popNodeAndName(this.tokenizer.sval, nodeStack);
                        } else {
                            if (lastNamed != null) {
                                lastNamed.setWeight(this.tokenizer.nval);
                            } else {
                                System.err.println("Error: can't set value " + this.tokenizer.nval + " to a null node");
                            }
                            lastNamed = null;
                        }
                        nameNext = false;
                        continue block11;
                    }
                    case 58: {
                        if (nameNext) {
                            lastNamed = this.popNodeAndName(null, nodeStack);
                        }
                        nameNext = false;
                        continue block11;
                    }
                    case -1: {
                        if (nameNext) {
                            lastNamed = this.popNodeAndName(null, nodeStack);
                        }
                        EOT = true;
                        nameNext = false;
                        continue block11;
                    }
                    case 40: {
                        PhyloNode newNode = new PhyloNode();
                        newNode.setId(id++);
                        nodeStack.push(newNode);
                        nameNext = true;
                        continue block11;
                    }
                    case 41: {
                        if (nameNext) {
                            lastNamed = this.popNodeAndName(null, nodeStack);
                        }
                        nameNext = true;
                        continue block11;
                    }
                    case 44: {
                        if (nameNext) {
                            lastNamed = this.popNodeAndName(null, nodeStack);
                        }
                        PhyloNode newNode = new PhyloNode();
                        newNode.setId(id++);
                        nodeStack.push(newNode);
                        nameNext = true;
                        continue block11;
                    }
                }
            }
        }
        catch (IOException e) {
            NonParsableException npe = new NonParsableException(e.getMessage());
            throw npe;
        }
        return tree;
    }

    private PhyloNode popNodeAndName(String name, Stack nodeStack) throws NonParsableException {
        PhyloNode node = (PhyloNode)nodeStack.pop();
        node.setName(name == null ? "" : name);
        try {
            PhyloNode parent = (PhyloNode)nodeStack.peek();
            parent.addChild(node);
        }
        catch (EmptyStackException e) {
            NonParsableException npe = new NonParsableException(e.getMessage());
            throw npe;
        }
        return node;
    }
}

