/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.broad.tribble.util.LittleEndianInputStream;

public class BigWigSectionHeader {
    private static Logger log = Logger.getLogger(BigWigSectionHeader.class);
    public static final int SECTION_HEADER_SIZE = 24;
    public static final int FIXEDSTEP_ITEM_SIZE = 4;
    public static final int VARSTEP_ITEM_SIZE = 8;
    public static final int BEDGRAPH_ITEM_SIZE = 12;
    private int chromID;
    private int chromStart;
    private int chromEnd;
    private int itemStep;
    private int itemSpan;
    private WigItemType itemType;
    private byte reserved;
    private short itemCount;
    private boolean isValidType;
    private String itemDescription;

    public BigWigSectionHeader(LittleEndianInputStream littleEndianInputStream) {
        byte by;
        try {
            this.chromID = littleEndianInputStream.readInt();
            this.chromStart = littleEndianInputStream.readInt();
            this.chromEnd = littleEndianInputStream.readInt();
            this.itemStep = littleEndianInputStream.readInt();
            this.itemSpan = littleEndianInputStream.readInt();
            by = littleEndianInputStream.readByte();
            this.reserved = littleEndianInputStream.readByte();
            this.itemCount = littleEndianInputStream.readShort();
        }
        catch (IOException iOException) {
            log.error((Object)"Error reading wig section header ", (Throwable)iOException);
            throw new RuntimeException("Error reading wig section header", iOException);
        }
        this.isValidType = this.getItemType(by);
    }

    public BigWigSectionHeader(DataInputStream dataInputStream) {
        byte by;
        try {
            this.chromID = dataInputStream.readInt();
            this.chromStart = dataInputStream.readInt();
            this.chromEnd = dataInputStream.readInt();
            this.itemStep = dataInputStream.readInt();
            this.itemSpan = dataInputStream.readInt();
            by = dataInputStream.readByte();
            this.reserved = dataInputStream.readByte();
            this.itemCount = dataInputStream.readShort();
        }
        catch (IOException iOException) {
            log.error((Object)"Error reading wig section header ", (Throwable)iOException);
            throw new RuntimeException("Error reading wig section header", iOException);
        }
        this.isValidType = this.getItemType(by);
    }

    public int getChromID() {
        return this.chromID;
    }

    public int getChromosomeStart() {
        return this.chromStart;
    }

    public int getChromosomeEnd() {
        return this.chromEnd;
    }

    public int getItemStep() {
        return this.itemStep;
    }

    public int getItemSpan() {
        return this.itemSpan;
    }

    public WigItemType getItemType() {
        return this.itemType;
    }

    public boolean IsValidType() {
        return this.isValidType;
    }

    public short getItemCount() {
        return this.itemCount;
    }

    public byte getReserved() {
        return this.reserved;
    }

    public void print() {
        log.debug((Object)(" BigWig section header  for " + this.itemDescription + " data"));
        log.debug((Object)("Chromosome ID = " + this.chromID));
        log.debug((Object)("ChromStart = " + this.chromStart));
        log.debug((Object)("ChromEnd = " + this.chromEnd));
        log.debug((Object)("ItemStep = " + this.itemStep));
        log.debug((Object)("ItemSpan = " + this.itemSpan));
        log.debug((Object)("ItemType = " + (Object)((Object)this.itemType)));
        log.debug((Object)("mReserved = " + this.reserved));
        log.debug((Object)("mItemCount = " + this.itemCount));
    }

    private boolean getItemType(byte by) {
        boolean bl;
        if (by == 1) {
            this.itemType = WigItemType.BedGraph;
            this.itemDescription = "Wig Bed Graph";
            bl = true;
        } else if (by == 2) {
            this.itemType = WigItemType.VarStep;
            this.itemDescription = "Wig Variable Step";
            bl = true;
        } else if (by == 3) {
            this.itemType = WigItemType.FixedStep;
            this.itemDescription = "Wig Fixed Step";
            bl = true;
        } else {
            this.itemType = WigItemType.Unknown;
            this.itemDescription = "Wig Type Unknown";
            bl = false;
        }
        return bl;
    }

    public static enum WigItemType {
        BedGraph,
        VarStep,
        FixedStep,
        Unknown;

    }
}

